/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.util.SourcePosition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMirrorImpl
implements AnnotationMirror,
EclipseMirrorObject {
    private final IAnnotationBinding _domAnnotation;
    private final BaseProcessorEnv _env;
    private final EclipseDeclarationImpl _annotated;

    public AnnotationMirrorImpl(IAnnotationBinding annotationAstNode, EclipseDeclarationImpl decl, BaseProcessorEnv env) {
        this._domAnnotation = annotationAstNode;
        this._env = env;
        this._annotated = decl;
        assert (this._domAnnotation != null) : "annotation node missing.";
        assert (this._annotated != null) : "missing the declaration that is annotated with this annotation.";
    }

    @Override
    public AnnotationType getAnnotationType() {
        ITypeBinding binding = this._domAnnotation.getAnnotationType();
        if (binding == null || binding.isRecovered()) {
            Name typeNameNode;
            ASTNode node = this._annotated.getCompilationUnit().findDeclaringNode((IBinding)this._domAnnotation);
            String name = "";
            if (node != null && node instanceof Annotation && (typeNameNode = ((Annotation)node).getTypeName()) != null) {
                name = typeNameNode.toString();
            }
            return Factory.createErrorAnnotationType(name);
        }
        return (AnnotationType)((Object)Factory.createReferenceType(binding, this._env));
    }

    @Override
    public Map<AnnotationTypeElementDeclaration, AnnotationValue> getElementValues() {
        IMemberValuePairBinding[] pairs = this._domAnnotation.getDeclaredMemberValuePairs();
        if (pairs.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<AnnotationTypeElementDeclaration, AnnotationValue> result = new LinkedHashMap<AnnotationTypeElementDeclaration, AnnotationValue>(pairs.length * 4 / 3 + 1);
        IMemberValuePairBinding[] iMemberValuePairBindingArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseDeclarationImpl mirrorDecl;
            IMethodBinding elementMethod;
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            String name = pair.getName();
            if (name != null && (elementMethod = pair.getMethodBinding()) != null && (mirrorDecl = Factory.createDeclaration((IBinding)elementMethod, this._env)) != null && mirrorDecl.kind() == EclipseMirrorObject.MirrorKind.ANNOTATION_ELEMENT) {
                AnnotationTypeElementDeclaration elementDecl = (AnnotationTypeElementDeclaration)((Object)mirrorDecl);
                AnnotationValue annoValue = Factory.createAnnotationMemberValue(pair.getValue(), name, this, this._env, elementDecl.getReturnType());
                if (annoValue != null) {
                    result.put(elementDecl, annoValue);
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public SourcePosition getPosition() {
        if (this.isFromSource()) {
            CompilationUnit unit = this._annotated.getCompilationUnit();
            Annotation annotation = this.getAstNode();
            if (annotation == null) {
                return null;
            }
            Name astNode = annotation.getTypeName();
            if (astNode == null) {
                astNode = annotation;
            }
            int offset = astNode.getStartPosition();
            return new SourcePositionImpl(astNode.getStartPosition(), astNode.getLength(), unit.getLineNumber(offset), unit.getColumnNumber(offset), this._annotated);
        }
        return null;
    }

    public String toString() {
        AnnotationTypeDeclaration decl = this.getAnnotationType().getDeclaration();
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(decl.getQualifiedName());
        Map<AnnotationTypeElementDeclaration, AnnotationValue> values = this.getElementValues();
        if (!values.isEmpty()) {
            sb.append('(');
            boolean first = true;
            for (Map.Entry<AnnotationTypeElementDeclaration, AnnotationValue> e : values.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(e.getKey().getSimpleName());
                sb.append(" = ");
                sb.append(e.getValue().toString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public ITypeBinding[] getMemberValueTypeBinding(String membername) {
        IMemberValuePairBinding[] declaredPairs;
        if (membername == null) {
            return null;
        }
        IMemberValuePairBinding[] iMemberValuePairBindingArray = declaredPairs = this._domAnnotation.getDeclaredMemberValuePairs();
        int n = declaredPairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            if (membername.equals(pair.getName())) {
                Object value = pair.getValue();
                return this.getValueTypeBinding(value, pair.getMethodBinding().getReturnType());
            }
            ++n2;
        }
        IMethodBinding binding = this.getMethodBinding(membername);
        if (binding == null) {
            return null;
        }
        Object defaultValue = binding.getDefaultValue();
        if (defaultValue != null) {
            return this.getValueTypeBinding(defaultValue, binding.getReturnType());
        }
        return null;
    }

    private ITypeBinding[] getValueTypeBinding(Object value, ITypeBinding resolvedType) {
        if (value == null) {
            return null;
        }
        if (resolvedType.isPrimitive() || resolvedType.isAnnotation() || value instanceof String) {
            return new ITypeBinding[]{resolvedType};
        }
        if (resolvedType.isArray()) {
            Object[] elements = (Object[])value;
            ITypeBinding[] result = new ITypeBinding[elements.length];
            ITypeBinding leafType = resolvedType.getElementType();
            int i = 0;
            int len = elements.length;
            while (i < len) {
                ITypeBinding[] t = this.getValueTypeBinding(elements[i], leafType);
                result[i] = t == null ? null : t[0];
                ++i;
            }
            return result;
        }
        if (value instanceof IVariableBinding) {
            return new ITypeBinding[]{((IVariableBinding)value).getDeclaringClass()};
        }
        if (value instanceof ITypeBinding) {
            return new ITypeBinding[]{(ITypeBinding)value};
        }
        throw new IllegalStateException("value = " + value + " resolvedType = " + resolvedType);
    }

    public Object getValue(String memberName) {
        IMemberValuePairBinding[] declaredPairs;
        if (memberName == null) {
            return null;
        }
        IMemberValuePairBinding[] iMemberValuePairBindingArray = declaredPairs = this._domAnnotation.getDeclaredMemberValuePairs();
        int n = declaredPairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            if (memberName.equals(pair.getName())) {
                return pair.getValue();
            }
            ++n2;
        }
        IMethodBinding binding = this.getMethodBinding(memberName);
        if (binding == null) {
            return null;
        }
        return binding.getDefaultValue();
    }

    public IMethodBinding getMethodBinding(String memberName) {
        IMethodBinding[] methods;
        if (memberName == null) {
            return null;
        }
        ITypeBinding typeBinding = this._domAnnotation.getAnnotationType();
        if (typeBinding == null) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = methods = typeBinding.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (memberName.equals(method.getName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public IAnnotationBinding getResolvedAnnotaion() {
        return this._domAnnotation;
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.ANNOTATION_MIRROR;
    }

    boolean isFromSource() {
        return this._annotated.isFromSource();
    }

    Annotation getAstNode() {
        CompilationUnit unit;
        ASTNode node;
        if (this.isFromSource() && (node = (unit = this._annotated.getCompilationUnit()).findDeclaringNode((IBinding)this._domAnnotation)) instanceof Annotation) {
            return (Annotation)node;
        }
        return null;
    }

    ASTNode getASTNodeForElement(String name) {
        if (name == null) {
            return null;
        }
        Annotation anno = this.getAstNode();
        if (anno != null) {
            if (anno.isSingleMemberAnnotation()) {
                if ("value".equals(name)) {
                    return ((SingleMemberAnnotation)anno).getValue();
                }
            } else if (anno.isNormalAnnotation()) {
                List pairs = ((NormalAnnotation)anno).values();
                for (MemberValuePair pair : pairs) {
                    String pairName;
                    String string = pairName = pair.getName() == null ? null : pair.getName().toString();
                    if (!name.equals(pairName)) continue;
                    return pair.getValue();
                }
            }
        }
        return null;
    }

    CompilationUnit getCompilationUnit() {
        return this._annotated.getCompilationUnit();
    }

    @Override
    public BaseProcessorEnv getEnvironment() {
        return this._env;
    }

    public IFile getResource() {
        return this._annotated.getResource();
    }

    public EclipseDeclarationImpl getAnnotatedDeclaration() {
        return this._annotated;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationMirrorImpl) {
            return ((AnnotationMirrorImpl)obj)._domAnnotation == this._domAnnotation;
        }
        return false;
    }

    public int hashCode() {
        return this._domAnnotation.hashCode();
    }
}

