/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptorManager;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class NavigatorFilterService
implements INavigatorFilterService {
    private static final ViewerFilter[] NO_FILTERS = new ViewerFilter[0];
    private static final String ACTIVATION_KEY = ".filterActivation";
    private static final String DELIM = ":";
    private final NavigatorContentService contentService;
    private final Map<ICommonFilterDescriptor, ViewerFilter> declaredViewerFilters = new HashMap<ICommonFilterDescriptor, ViewerFilter>();
    private final Set enforcedViewerFilters = new HashSet();
    private final Set<String> activeFilters = new HashSet<String>();

    public NavigatorFilterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.restoreFilterActivation();
    }

    private synchronized void restoreFilterActivation() {
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            @Override
            public void run() throws Exception {
                IEclipsePreferences prefs = NavigatorContentService.getPreferencesRoot();
                if (prefs.get(NavigatorFilterService.this.getFilterActivationPreferenceKey(), null) != null) {
                    String activatedFiltersPreferenceValue = prefs.get(NavigatorFilterService.this.getFilterActivationPreferenceKey(), null);
                    String[] activeFilterIds = activatedFiltersPreferenceValue.split(NavigatorFilterService.DELIM);
                    int i = 0;
                    while (i < activeFilterIds.length) {
                        NavigatorFilterService.this.activeFilters.add(activeFilterIds[i]);
                        ++i;
                    }
                } else {
                    ICommonFilterDescriptor[] visibleFilterDescriptors = NavigatorFilterService.this.getVisibleFilterDescriptors();
                    int i = 0;
                    while (i < visibleFilterDescriptors.length) {
                        if (visibleFilterDescriptors[i].isActiveByDefault()) {
                            NavigatorFilterService.this.activeFilters.add(visibleFilterDescriptors[i].getId());
                        }
                        ++i;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistFilterActivationState() {
        Set<String> set = this.activeFilters;
        synchronized (set) {
            CommonFilterDescriptorManager dm = CommonFilterDescriptorManager.getInstance();
            StringBuffer activatedFiltersPreferenceValue = new StringBuffer(DELIM);
            Iterator<String> activeItr = this.activeFilters.iterator();
            while (activeItr.hasNext()) {
                String id = activeItr.next().toString();
                if (!dm.getFilterById(id).isVisibleInUi()) continue;
                activatedFiltersPreferenceValue.append(id).append(DELIM);
            }
            IEclipsePreferences prefs = NavigatorContentService.getPreferencesRoot();
            prefs.put(this.getFilterActivationPreferenceKey(), activatedFiltersPreferenceValue.toString());
            NavigatorContentService.flushPreferences(prefs);
        }
    }

    public void resetFilterActivationState() {
        IEclipsePreferences prefs = NavigatorContentService.getPreferencesRoot();
        prefs.remove(this.getFilterActivationPreferenceKey());
        NavigatorContentService.flushPreferences(prefs);
    }

    private String getFilterActivationPreferenceKey() {
        return String.valueOf(this.contentService.getViewerId()) + ACTIVATION_KEY;
    }

    @Override
    public ViewerFilter[] getVisibleFilters(boolean toReturnOnlyActiveFilters) {
        CommonFilterDescriptor[] descriptors = CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.contentService);
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        int i = 0;
        while (i < descriptors.length) {
            ViewerFilter instance;
            if ((!toReturnOnlyActiveFilters || this.isActive(descriptors[i].getId())) && (instance = this.getViewerFilter(descriptors[i])) != null) {
                filters.add(instance);
            }
            ++i;
        }
        filters.addAll(this.enforcedViewerFilters);
        if (filters.size() == 0) {
            return NO_FILTERS;
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewerFilter getViewerFilter(ICommonFilterDescriptor descriptor) {
        ViewerFilter filter = null;
        Map<ICommonFilterDescriptor, ViewerFilter> map = this.declaredViewerFilters;
        synchronized (map) {
            filter = this.declaredViewerFilters.get(descriptor);
            if (filter == null) {
                filter = ((CommonFilterDescriptor)descriptor).createFilter();
                this.declaredViewerFilters.put(descriptor, filter);
            }
        }
        return filter;
    }

    @Override
    public ICommonFilterDescriptor[] getVisibleFilterDescriptors() {
        return CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.contentService);
    }

    public ICommonFilterDescriptor[] getVisibleFilterDescriptorsForUI() {
        return CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.contentService, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive(String aFilterId) {
        Set<String> set = this.activeFilters;
        synchronized (set) {
            return this.activeFilters.contains(aFilterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveFilterIds(String[] theFilterIds) {
        Assert.isNotNull((Object)theFilterIds);
        Set<String> set = this.activeFilters;
        synchronized (set) {
            this.activeFilters.clear();
            this.activeFilters.addAll(Arrays.asList(theFilterIds));
        }
    }

    @Override
    public void activateFilterIdsAndUpdateViewer(String[] filterIdsToActivate) {
        boolean updateFilterActivation = false;
        Arrays.sort(filterIdsToActivate);
        CommonFilterDescriptor[] visibleFilterDescriptors = (CommonFilterDescriptor[])this.getVisibleFilterDescriptors();
        ArrayList<String> nonUiVisible = null;
        int i = 0;
        while (i < visibleFilterDescriptors.length) {
            int indexofFilterIdToBeActivated = Arrays.binarySearch(filterIdsToActivate, visibleFilterDescriptors[i].getId());
            if (indexofFilterIdToBeActivated >= 0 ^ this.isActive(visibleFilterDescriptors[i].getId())) {
                updateFilterActivation = true;
            }
            if (!visibleFilterDescriptors[i].isVisibleInUi()) {
                if (nonUiVisible == null) {
                    nonUiVisible = new ArrayList<String>();
                }
                nonUiVisible.add(visibleFilterDescriptors[i].getId());
            }
            ++i;
        }
        if (updateFilterActivation) {
            if (nonUiVisible != null) {
                i = 0;
                while (i < filterIdsToActivate.length) {
                    nonUiVisible.add(filterIdsToActivate[i]);
                    ++i;
                }
                filterIdsToActivate = nonUiVisible.toArray(new String[0]);
            }
            this.setActiveFilterIds(filterIdsToActivate);
            this.persistFilterActivationState();
            this.updateViewer();
            StructuredViewer commonViewer = (StructuredViewer)this.contentService.getViewer();
            commonViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void updateViewer() {
        StructuredViewer commonViewer = (StructuredViewer)this.contentService.getViewer();
        ViewerFilter[] visibleFilters = this.getVisibleFilters(true);
        commonViewer.setFilters(visibleFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveFilterIds(String[] theFilterIds) {
        Assert.isNotNull((Object)theFilterIds);
        Set<String> set = this.activeFilters;
        synchronized (set) {
            this.activeFilters.addAll(Arrays.asList(theFilterIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String aFilterId, boolean toMakeActive) {
        Set<String> set = this.activeFilters;
        synchronized (set) {
            boolean isActive = this.activeFilters.contains(aFilterId);
            if (isActive ^ toMakeActive) {
                if (toMakeActive) {
                    this.activeFilters.remove(aFilterId);
                } else {
                    this.activeFilters.add(aFilterId);
                }
            }
        }
    }
}

