/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class OpenMarkersViewHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MarkerSupportView part = this.getView(event);
        if (part == null) {
            return null;
        }
        try {
            String count = ExtendedMarkersView.newSecondaryID((IViewPart)part);
            String defaultName = NLS.bind((String)MarkerMessages.newViewTitle, (Object[])new Object[]{part.getSite().getRegisteredName(), count});
            InputDialog dialog = new InputDialog(part.getSite().getShell(), NLS.bind((String)MarkerMessages.NewViewHandler_dialogTitle, (Object[])new String[]{part.getSite().getRegisteredName()}), MarkerMessages.NewViewHandler_dialogMessage, defaultName, this.getValidator());
            if (dialog.open() != 0) {
                return this;
            }
            IViewPart newPart = part.getSite().getPage().showView(part.getSite().getId(), count, 1);
            if (newPart instanceof ExtendedMarkersView) {
                ((ExtendedMarkersView)newPart).initializeTitle(dialog.getValue());
            }
        }
        catch (PartInitException e) {
            throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        return this;
    }

    private IInputValidator getValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() > 0) {
                    return null;
                }
                return MarkerMessages.MarkerFilterDialog_emptyMessage;
            }
        };
    }
}

