/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DefaultSourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.sourcelookup.AddContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.DownAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.RemoveAction;
import org.eclipse.debug.internal.ui.sourcelookup.RestoreDefaultAction;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerAction;
import org.eclipse.debug.internal.ui.sourcelookup.SourceContainerViewer;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.debug.internal.ui.sourcelookup.UpAction;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.WorkingSetSourceContainer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class SourceLookupPanel
extends AbstractLaunchConfigurationTab
implements IPropertyChangeListener {
    protected ILaunchConfiguration fConfig;
    protected SourceContainerViewer fPathViewer;
    protected Button fDuplicatesButton;
    protected List<SourceContainerAction> fActions = new ArrayList<SourceContainerAction>(6);
    protected ISourceLookupDirector fLocator;
    protected AddContainerAction fAddAction;
    protected EditContainerAction fEditAction;
    protected RestoreDefaultAction fRestoreDefaultAction;

    @Override
    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createLabel(comp, SourceLookupUIMessages.sourceTab_lookupLabel, 2);
        this.fPathViewer = new SourceContainerViewer(comp, this);
        this.fPathViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fPathViewer.getControl().setFont(font);
        Composite pathButtonComp = SWTFactory.createComposite(comp, comp.getFont(), 1, 1, 258, 0, 0);
        SWTFactory.createVerticalSpacer(comp, 2);
        this.fDuplicatesButton = SWTFactory.createCheckButton(comp, SourceLookupUIMessages.sourceTab_searchDuplicateLabel, null, false, 2);
        this.fDuplicatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SourceLookupPanel.this.setDirty(true);
                SourceLookupPanel.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAddAction = new AddContainerAction();
        Button button = SWTFactory.createPushButton(pathButtonComp, this.fAddAction.getText(), null);
        this.fAddAction.setButton(button);
        this.addAction(this.fAddAction);
        this.fEditAction = new EditContainerAction();
        button = SWTFactory.createPushButton(pathButtonComp, this.fEditAction.getText(), null);
        this.fEditAction.setButton(button);
        this.addAction(this.fEditAction);
        SourceContainerAction action = new RemoveAction();
        button = SWTFactory.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new UpAction();
        button = SWTFactory.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        action = new DownAction();
        button = SWTFactory.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        this.addAction(action);
        this.fRestoreDefaultAction = new RestoreDefaultAction();
        button = SWTFactory.createPushButton(pathButtonComp, this.fRestoreDefaultAction.getText(), null);
        this.fRestoreDefaultAction.setButton(button);
        this.addAction(this.fRestoreDefaultAction);
        this.retargetActions(this.fPathViewer);
        IWorkingSetManager workingSetMgr = DebugUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
        workingSetMgr.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setControl((Control)comp);
    }

    protected void addAction(SourceContainerAction action) {
        this.fActions.add(action);
    }

    protected void retargetActions(SourceContainerViewer viewer) {
        for (SourceContainerAction action : this.fActions) {
            action.setViewer(viewer);
        }
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fLocator != null) {
            this.fLocator.dispose();
            this.fLocator = null;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        String memento = null;
        String type = null;
        try {
            memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (type == null) {
                type = configuration.getType().getSourceLocatorId();
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        if (type == null) {
            this.setErrorMessage(SourceLookupUIMessages.sourceLookupPanel_2);
            return;
        }
        boolean migration = false;
        try {
            IPersistableSourceLocator locator = this.getLaunchManager().newSourceLocator(type);
            if (!(locator instanceof AbstractSourceLookupDirector)) {
                memento = null;
                type = configuration.getType().getSourceLocatorId();
                if (type == null) {
                    this.setErrorMessage(SourceLookupUIMessages.sourceLookupPanel_2);
                    return;
                }
                locator = this.getLaunchManager().newSourceLocator(type);
                if (!(locator instanceof AbstractSourceLookupDirector)) {
                    this.setErrorMessage(SourceLookupUIMessages.sourceLookupPanel_2);
                    return;
                }
                migration = true;
            }
            this.fLocator = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                this.fLocator.initializeDefaults(configuration);
            } else {
                this.fLocator.initializeFromMemento(memento, configuration);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return;
        }
        this.initializeFrom(this.fLocator);
        if (migration && configuration.isWorkingCopy()) {
            this.setDirty(true);
            this.performApply((ILaunchConfigurationWorkingCopy)configuration);
        }
    }

    public void initializeFrom(ISourceLookupDirector locator) {
        if (this.fConfig == null) {
            this.fConfig = locator.getLaunchConfiguration();
        }
        this.fPathViewer.setEntries(locator.getSourceContainers());
        this.fDuplicatesButton.setSelection(locator.isFindDuplicates());
        this.fLocator = locator;
        this.fAddAction.setSourceLookupDirector(locator);
        this.fEditAction.setSourceLookupDirector(locator);
        this.fRestoreDefaultAction.setSourceLookupDirector(locator);
        this.setDirty(false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            if (this.fLocator == null) {
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                return;
            }
            ILaunchConfigurationWorkingCopy workingCopy = configuration;
            if (configuration == null) {
                try {
                    ILaunchConfiguration config = this.fLocator.getLaunchConfiguration();
                    if (config != null) {
                        workingCopy = config.getWorkingCopy();
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    this.setErrorMessage(SourceLookupUIMessages.sourceLookupPanel_1);
                    return;
                }
            }
            if (workingCopy == null) {
                DebugUIPlugin.logErrorMessage("Error occurred - a working copy could not be acquired, therefore source lookup path changes will not be applied.");
                return;
            }
            this.fLocator.setSourceContainers(this.fPathViewer.getEntries());
            this.fLocator.setFindDuplicates(this.fDuplicatesButton.getSelection());
            try {
                if (this.isDefault()) {
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                } else {
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, this.fLocator.getMemento());
                    workingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, this.fLocator.getId());
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                this.setErrorMessage(SourceLookupUIMessages.sourceLookupPanel_1);
            }
        }
    }

    protected boolean isDefault() {
        ISourceContainer[] current = this.getEntries();
        return !this.fDuplicatesButton.getSelection() && current.length == 1 && current[0] instanceof DefaultSourceContainer;
    }

    public ISourceContainer[] getEntries() {
        return this.fPathViewer.getEntries();
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    @Override
    public String getName() {
        return SourceLookupUIMessages.sourceTab_tabTitle;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void validateWorkingSetSourceContainers(IWorkingSet affectedWorkingSet) {
        List sourceContainers = (List)this.fPathViewer.getInput();
        if (sourceContainers != null) {
            int i = 0;
            while (i < sourceContainers.size()) {
                WorkingSetSourceContainer wsSrcContainer;
                if (sourceContainers.get(i) instanceof WorkingSetSourceContainer && (wsSrcContainer = (WorkingSetSourceContainer)((Object)sourceContainers.get(i))).getName().equals(affectedWorkingSet.getName())) {
                    sourceContainers.remove(i);
                }
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("workingSetRemove")) {
            this.validateWorkingSetSourceContainers((IWorkingSet)event.getOldValue());
        }
    }

    @Override
    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public ISourceLookupDirector getDirector() {
        return this.fLocator;
    }

    @Override
    public void dispose() {
        super.dispose();
        IWorkingSetManager workingSetMgr = DebugUIPlugin.getDefault().getWorkbench().getWorkingSetManager();
        workingSetMgr.removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

