/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.lib.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreNode {
    private final List<FastIgnoreRule> rules;

    public IgnoreNode() {
        this.rules = new ArrayList<FastIgnoreRule>();
    }

    public IgnoreNode(List<FastIgnoreRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        String txt;
        BufferedReader br = IgnoreNode.asReader(in);
        while ((txt = br.readLine()) != null) {
            if ((txt = txt.trim()).length() <= 0 || txt.startsWith("#") || txt.equals("/")) continue;
            this.rules.add(new FastIgnoreRule(txt));
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Constants.CHARSET));
    }

    public List<FastIgnoreRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory) {
        if (this.rules.isEmpty()) {
            return MatchResult.CHECK_PARENT;
        }
        for (int i = this.rules.size() - 1; i > -1; --i) {
            FastIgnoreRule rule = this.rules.get(i);
            if (!rule.isMatch(entryPath, isDirectory)) continue;
            if (rule.getResult()) {
                return MatchResult.IGNORED;
            }
            return MatchResult.NOT_IGNORED;
        }
        return MatchResult.CHECK_PARENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT;

    }
}

