/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareIndexWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        IResource[] resources = this.getSelectedResources();
        try {
            if (resources.length > 0) {
                CompareUtils.compare(resources, repository, "Index", "HEAD", false, workBenchPage);
            } else {
                IPath[] locations = this.getSelectedLocations(event);
                if (locations.length > 0) {
                    CompareUtils.compare(locations[0], repository, "Index", "HEAD", false, workBenchPage);
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        IResource resource = (IResource)AdapterUtils.adapt((Object)selection.getFirstElement(), IResource.class);
        if (resource != null) {
            if (resource instanceof IFile) {
                return this.isStaged(repository, resource.getLocation());
            }
        } else {
            IPath location = (IPath)AdapterUtils.adapt((Object)selection.getFirstElement(), IPath.class);
            if (location != null && !location.toFile().isDirectory()) {
                return this.isStaged(repository, location);
            }
        }
        return false;
    }

    private boolean isStaged(Repository repository, IPath location) {
        String resRelPath = RepositoryMapping.getMapping((IPath)location).getRepoRelativePath(location);
        if (resRelPath == null || resRelPath.length() == 0) {
            return false;
        }
        try {
            FileTreeIterator fileTreeIterator = new FileTreeIterator(repository);
            IndexDiff indexDiff = new IndexDiff(repository, "HEAD", (WorkingTreeIterator)fileTreeIterator);
            indexDiff.setFilter(PathFilterGroup.createFromStrings(Collections.singletonList(resRelPath)));
            indexDiff.diff();
            return indexDiff.getAdded().contains(resRelPath) || indexDiff.getChanged().contains(resRelPath) || indexDiff.getRemoved().contains(resRelPath);
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)location.toString()), e);
            return false;
        }
    }
}

