/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class SwitchToMenu
extends ContributionItem
implements IWorkbenchContribution {
    static final int MAX_NUM_MENU_ENTRIES = 20;
    private IHandlerService handlerService;
    private final Image branchImage = UIIcons.BRANCH.createImage();
    private final Image newBranchImage = UIIcons.CREATE_BRANCH.createImage();
    private final Image checkedOutImage = SWTUtils.getDecoratedImage(this.branchImage, UIIcons.OVR_CHECKEDOUT);

    public SwitchToMenu() {
        this(null);
    }

    public SwitchToMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        if (this.handlerService == null) {
            return;
        }
        Repository repository = SelectionUtils.getRepository(this.handlerService.getCurrentState());
        if (repository != null) {
            this.createDynamicMenu(menu, repository);
        }
    }

    private void createDynamicMenu(Menu menu, final Repository repository) {
        MenuItem newBranch = new MenuItem(menu, 8);
        newBranch.setText(UIText.SwitchToMenu_NewBranchMenuLabel);
        newBranch.setImage(this.newBranchImage);
        newBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceRef = repository.getConfig().getString("workflow", null, "defbranchstartpoint");
                try {
                    Ref ref = repository.getRef(sourceRef);
                    if (ref != null) {
                        BranchOperationUI.createWithRef(repository, ref.getName()).start();
                    } else {
                        BranchOperationUI.create(repository).start();
                    }
                }
                catch (IOException iOException) {
                    BranchOperationUI.create(repository).start();
                }
            }
        });
        SwitchToMenu.createSeparator(menu);
        try {
            String currentBranch = repository.getFullBranch();
            Map localBranches = repository.getRefDatabase().getRefs("refs/heads/");
            TreeMap<String, Ref> sortedRefs = new TreeMap<String, Ref>(CommonUtils.STRING_ASCENDING_COMPARATOR);
            List reflogEntries = repository.getReflogReader("HEAD").getReverseEntries();
            for (ReflogEntry entry : reflogEntries) {
                CheckoutEntry checkout = entry.parseCheckout();
                if (checkout == null) continue;
                Ref ref = (Ref)localBranches.get(checkout.getFromBranch());
                if (ref != null && sortedRefs.size() < 20) {
                    sortedRefs.put(checkout.getFromBranch(), ref);
                }
                if ((ref = (Ref)localBranches.get(checkout.getToBranch())) == null || sortedRefs.size() >= 20) continue;
                sortedRefs.put(checkout.getToBranch(), ref);
            }
            int itemCount = 0;
            for (Map.Entry entry : sortedRefs.entrySet()) {
                ++itemCount;
                String shortName = entry.getKey();
                String fullName = ((Ref)entry.getValue()).getName();
                this.createMenuItem(menu, repository, currentBranch, fullName, shortName);
                localBranches.remove(shortName);
            }
            if (itemCount < 20) {
                if (itemCount > 0 && localBranches.size() > 0) {
                    SwitchToMenu.createSeparator(menu);
                }
                sortedRefs.clear();
                sortedRefs.putAll(localBranches);
                for (Map.Entry entry : sortedRefs.entrySet()) {
                    if (++itemCount > 20) break;
                    String fullName = ((Ref)entry.getValue()).getName();
                    String shortName = entry.getKey();
                    this.createMenuItem(menu, repository, currentBranch, fullName, shortName);
                }
            }
            if (itemCount > 0) {
                SwitchToMenu.createSeparator(menu);
            }
            MenuItem others = new MenuItem(menu, 8);
            others.setText(UIText.SwitchToMenu_OtherMenuLabel);
            others.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BranchOperationUI.checkout(repository).start();
                }
            });
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private static MenuItem createSeparator(Menu menu) {
        return new MenuItem(menu, 2);
    }

    private void createMenuItem(Menu menu, final Repository repository, String currentBranch, final String fullName, String shortName) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(shortName);
        boolean checkedOut = currentBranch.equals(fullName);
        if (checkedOut) {
            item.setImage(this.checkedOutImage);
        } else {
            item.setImage(this.branchImage);
        }
        item.setEnabled(!checkedOut);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchOperationUI.checkout(repository, fullName).start();
            }
        });
    }

    public boolean isDynamic() {
        return true;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.handlerService = CommonUtils.getService(serviceLocator, IHandlerService.class);
    }

    public void dispose() {
        this.branchImage.dispose();
        this.newBranchImage.dispose();
        this.checkedOutImage.dispose();
    }
}

