/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CherryPickOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.CherryPick";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RevCommit> commits = this.getSelectedItems(RevCommit.class, event);
        if (commits == null || commits.isEmpty()) {
            return null;
        }
        final Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        Shell parent = this.getPart(event).getSite().getShell();
        if (!this.confirmCherryPick(parent, repo, commits)) {
            return null;
        }
        try {
            if (!UIRepositoryUtils.handleUncommittedFiles(repo, parent)) {
                return null;
            }
        }
        catch (GitAPIException e) {
            Activator.logError(e.getMessage(), e);
            return null;
        }
        final CherryPickOperation op = new CherryPickOperation(repo, commits);
        Job job = new Job(MessageFormat.format(UIText.CherryPickHandler_JobName, commits.size())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                    RebaseResult result = op.getResult();
                    if (result.getStatus() != RebaseResult.Status.OK) {
                        RebaseResultDialog.show(result, repo);
                    }
                }
                catch (CoreException e) {
                    Activator.logError(UIText.CherryPickOperation_InternalError, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CHERRY_PICK.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private boolean confirmCherryPick(final Shell shell, final Repository repository, final List<RevCommit> commits) throws ExecutionException {
        String message;
        final AtomicBoolean confirmed = new AtomicBoolean(false);
        try {
            message = MessageFormat.format(UIText.CherryPickHandler_ConfirmMessage, commits.size(), repository.getBranch());
        }
        catch (IOException e) {
            throw new ExecutionException("Exception obtaining current repository branch", (Throwable)e);
        }
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                ConfirmCherryPickDialog dialog = new ConfirmCherryPickDialog(shell, message, repository, commits);
                int result = dialog.open();
                confirmed.set(result == 0);
            }
        });
        return confirmed.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfirmCherryPickDialog
    extends MessageDialog {
        private RepositoryCommit[] commits;

        public ConfirmCherryPickDialog(Shell parentShell, String message, Repository repository, List<RevCommit> revCommits) {
            super(parentShell, UIText.CherryPickHandler_ConfirmTitle, null, message, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10);
            ArrayList<RepositoryCommit> repoCommits = new ArrayList<RepositoryCommit>();
            for (RevCommit commit : revCommits) {
                repoCommits.add(new RepositoryCommit(repository, commit));
            }
            this.commits = repoCommits.toArray(new RepositoryCommit[0]);
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            area.setLayout((Layout)new FillLayout());
            TreeViewer treeViewer = new TreeViewer(area);
            treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkbenchLabelProvider()));
            treeViewer.setInput((Object)this.commits);
            return area;
        }

        private static class ContentProvider
        extends WorkbenchContentProvider {
            private ContentProvider() {
            }

            public Object[] getElements(Object element) {
                return (Object[])element;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof RepositoryCommit) {
                    return ((RepositoryCommit)((Object)element)).getDiffs();
                }
                return super.getChildren(element);
            }
        }
    }
}

