/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FindResults;
import org.eclipse.egit.ui.internal.history.FindToolbarThread;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FindToolbar
extends Composite {
    public static final int PREFS_FINDIN_ALL = 0;
    private static final int PREFS_FINDIN_COMMENTS = 1;
    private static final int PREFS_FINDIN_AUTHOR = 2;
    private static final int PREFS_FINDIN_COMMITID = 3;
    private static final int PREFS_FINDIN_COMMITTER = 4;
    private static final int PREFS_FINDIN_REFERENCE = 5;
    private Color errorBackgroundColor;
    public final FindResults findResults = new FindResults();
    private IPersistentPreferenceStore store = (IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore();
    private List<Listener> eventList = new ArrayList<Listener>();
    private Table historyTable;
    private SWTCommit[] fileRevisions;
    private Text patternField;
    private Button nextButton;
    private Button previousButton;
    private Label currentPositionLabel;
    private ProgressBar progressBar;
    private String lastErrorPattern;
    private ToolItem prefsDropDown;
    private Menu prefsMenu;
    private MenuItem caseItem;
    private MenuItem allItem;
    private MenuItem commitIdItem;
    private MenuItem commentsItem;
    private MenuItem authorItem;
    private MenuItem committerItem;
    private MenuItem referenceItem;
    private Image nextIcon;
    private Image previousIcon;
    private Image allIcon;
    private Image commitIdIcon;
    private Image commentsIcon;
    private Image authorIcon;
    private Image committerIcon;
    private Image branchesIcon;

    public FindToolbar(Composite parent) {
        super(parent, 0);
        this.createToolbar();
    }

    private void createToolbar() {
        this.errorBackgroundColor = new Color((Device)this.getDisplay(), new RGB(255, 150, 150));
        this.nextIcon = UIIcons.ELCL16_NEXT.createImage();
        this.previousIcon = UIIcons.ELCL16_PREVIOUS.createImage();
        this.allIcon = UIIcons.SEARCH_COMMIT.createImage();
        this.commitIdIcon = UIIcons.ELCL16_ID.createImage();
        this.commentsIcon = UIIcons.ELCL16_COMMENTS.createImage();
        this.authorIcon = UIIcons.ELCL16_AUTHOR.createImage();
        this.committerIcon = UIIcons.ELCL16_COMMITTER.createImage();
        this.branchesIcon = UIIcons.BRANCHES.createImage();
        GridLayout findLayout = new GridLayout();
        findLayout.marginHeight = 2;
        findLayout.marginWidth = 2;
        findLayout.numColumns = 8;
        this.setLayout((Layout)findLayout);
        this.setLayoutData(new GridData(4, 4, true, false));
        Label findLabel = new Label((Composite)this, 0);
        findLabel.setText(UIText.HistoryPage_findbar_find);
        this.patternField = new Text((Composite)this, 128);
        GridData findTextData = new GridData(4, 0x1000000, true, false);
        findTextData.minimumWidth = 50;
        this.patternField.setLayoutData((Object)findTextData);
        this.patternField.setTextLimit(100);
        this.nextButton = new Button((Composite)this, 8);
        this.nextButton.setImage(this.nextIcon);
        this.nextButton.setText(UIText.HistoryPage_findbar_next);
        this.nextButton.setToolTipText(UIText.FindToolbar_NextTooltip);
        this.previousButton = new Button((Composite)this, 8);
        this.previousButton.setImage(this.previousIcon);
        this.previousButton.setText(UIText.HistoryPage_findbar_previous);
        this.previousButton.setToolTipText(UIText.FindToolbar_PreviousTooltip);
        final ToolBar toolBar = new ToolBar((Composite)this, 0x800000);
        new ToolItem(toolBar, 2);
        this.prefsDropDown = new ToolItem(toolBar, 4);
        this.prefsMenu = new Menu((Decorations)this.getShell(), 8);
        this.caseItem = new MenuItem(this.prefsMenu, 32);
        this.caseItem.setText(UIText.HistoryPage_findbar_ignorecase);
        new MenuItem(this.prefsMenu, 2);
        this.allItem = this.createFindInMenuItem();
        this.allItem.setText(UIText.HistoryPage_findbar_all);
        this.allItem.setImage(this.allIcon);
        this.commentsItem = this.createFindInMenuItem();
        this.commentsItem.setText(UIText.HistoryPage_findbar_comments);
        this.commentsItem.setImage(this.commentsIcon);
        this.authorItem = this.createFindInMenuItem();
        this.authorItem.setText(UIText.HistoryPage_findbar_author);
        this.authorItem.setImage(this.authorIcon);
        this.commitIdItem = this.createFindInMenuItem();
        this.commitIdItem.setText(UIText.HistoryPage_findbar_commit);
        this.commitIdItem.setImage(this.commitIdIcon);
        this.committerItem = this.createFindInMenuItem();
        this.committerItem.setText(UIText.HistoryPage_findbar_committer);
        this.committerItem.setImage(this.committerIcon);
        this.referenceItem = this.createFindInMenuItem();
        this.referenceItem.setText(UIText.HistoryPage_findbar_reference);
        this.referenceItem.setImage(this.branchesIcon);
        this.prefsDropDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle itemBounds = FindToolbar.this.prefsDropDown.getBounds();
                    Point point = toolBar.toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
                    FindToolbar.this.prefsMenu.setLocation(point);
                    FindToolbar.this.prefsMenu.setVisible(true);
                } else if (FindToolbar.this.allItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.commentsItem);
                } else if (FindToolbar.this.commentsItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.authorItem);
                } else if (FindToolbar.this.authorItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.commitIdItem);
                } else if (FindToolbar.this.commitIdItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.committerItem);
                } else if (FindToolbar.this.committerItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.referenceItem);
                } else if (FindToolbar.this.referenceItem.getSelection()) {
                    FindToolbar.this.selectFindInItem(FindToolbar.this.allItem);
                }
            }
        });
        this.currentPositionLabel = new Label((Composite)this, 0);
        GridData totalLabelData = new GridData();
        totalLabelData.horizontalAlignment = 4;
        totalLabelData.grabExcessHorizontalSpace = true;
        this.currentPositionLabel.setLayoutData((Object)totalLabelData);
        this.currentPositionLabel.setAlignment(131072);
        this.currentPositionLabel.setText("");
        this.progressBar = new ProgressBar((Composite)this, 256);
        GridData findProgressBarData = new GridData();
        findProgressBarData.heightHint = 12;
        findProgressBarData.widthHint = 35;
        this.progressBar.setLayoutData((Object)findProgressBarData);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.patternField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                final FindToolbarThread finder = FindToolbar.this.createFinder();
                FindToolbar.this.getDisplay().timerExec(200, new Runnable(){

                    public void run() {
                        finder.start();
                    }
                });
            }
        });
        final Listener findButtonsListener = new Listener(){

            public void handleEvent(Event event) {
                if (FindToolbar.this.patternField.getText().length() > 0 && FindToolbar.this.findResults.size() == 0) {
                    FindToolbarThread finder = FindToolbar.this.createFinder();
                    finder.start();
                    FindToolbar.this.patternField.setSelection(0, 0);
                } else {
                    int currentIx = FindToolbar.this.historyTable.getSelectionIndex();
                    int newIx = -1;
                    if (event.widget == FindToolbar.this.nextButton) {
                        newIx = FindToolbar.this.findResults.getIndexAfter(currentIx);
                        if (newIx == -1) {
                            newIx = FindToolbar.this.findResults.getFirstIndex();
                        }
                    } else {
                        newIx = FindToolbar.this.findResults.getIndexBefore(currentIx);
                        if (newIx == -1) {
                            newIx = FindToolbar.this.findResults.getLastIndex();
                        }
                    }
                    FindToolbar.this.sendEvent(event.widget, newIx);
                    String current = null;
                    int currentValue = FindToolbar.this.findResults.getMatchNumberFor(newIx);
                    current = currentValue == -1 ? "-" : String.valueOf(currentValue);
                    FindToolbar.this.currentPositionLabel.setText(String.valueOf(current) + "/" + FindToolbar.this.findResults.size());
                }
            }
        };
        this.nextButton.addListener(13, findButtonsListener);
        this.previousButton.addListener(13, findButtonsListener);
        this.patternField.addKeyListener((KeyListener)new KeyAdapter(){
            private Event event = new Event();

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (FindToolbar.this.nextButton.isEnabled()) {
                        this.event.widget = FindToolbar.this.nextButton;
                        findButtonsListener.handleEvent(this.event);
                    }
                } else if (e.keyCode == 0x1000001 && FindToolbar.this.previousButton.isEnabled()) {
                    this.event.widget = FindToolbar.this.previousButton;
                    findButtonsListener.handleEvent(this.event);
                }
            }
        });
        this.caseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindToolbar.this.store.setValue("findtoolbar_ignore_case", FindToolbar.this.caseItem.getSelection());
                if (FindToolbar.this.store.needsSaving()) {
                    try {
                        FindToolbar.this.store.save();
                    }
                    catch (IOException e1) {
                        Activator.handleError(e1.getMessage(), e1, false);
                    }
                }
                FindToolbar.this.clear();
            }
        });
        this.caseItem.setSelection(this.store.getBoolean("findtoolbar_ignore_case"));
        int selectedPrefsItem = this.store.getInt("findtoolbar_find_in");
        if (selectedPrefsItem == 0) {
            this.selectFindInItem(this.allItem);
        } else if (selectedPrefsItem == 1) {
            this.selectFindInItem(this.commentsItem);
        } else if (selectedPrefsItem == 2) {
            this.selectFindInItem(this.authorItem);
        } else if (selectedPrefsItem == 3) {
            this.selectFindInItem(this.commitIdItem);
        } else if (selectedPrefsItem == 4) {
            this.selectFindInItem(this.committerItem);
        } else if (selectedPrefsItem == 5) {
            this.selectFindInItem(this.referenceItem);
        }
        this.registerDisposal();
    }

    private void registerDisposal() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindToolbar.this.prefsMenu.dispose();
                FindToolbar.this.errorBackgroundColor.dispose();
                FindToolbar.this.nextIcon.dispose();
                FindToolbar.this.previousIcon.dispose();
                FindToolbar.this.allIcon.dispose();
                FindToolbar.this.commitIdIcon.dispose();
                FindToolbar.this.commentsIcon.dispose();
                FindToolbar.this.authorIcon.dispose();
                FindToolbar.this.committerIcon.dispose();
                FindToolbar.this.branchesIcon.dispose();
            }
        });
    }

    private MenuItem createFindInMenuItem() {
        final MenuItem menuItem = new MenuItem(this.prefsMenu, 16);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindToolbar.this.selectFindInItem(menuItem);
            }
        });
        return menuItem;
    }

    private void selectFindInItem(MenuItem menuItem) {
        if (menuItem == this.allItem) {
            this.selectFindInItem(menuItem, 0, this.allIcon, UIText.HistoryPage_findbar_changeto_comments);
        } else if (menuItem == this.commentsItem) {
            this.selectFindInItem(menuItem, 1, this.commentsIcon, UIText.HistoryPage_findbar_changeto_author);
        } else if (menuItem == this.authorItem) {
            this.selectFindInItem(menuItem, 2, this.authorIcon, UIText.HistoryPage_findbar_changeto_commit);
        } else if (menuItem == this.commitIdItem) {
            this.selectFindInItem(menuItem, 3, this.commitIdIcon, UIText.HistoryPage_findbar_changeto_committer);
        } else if (menuItem == this.committerItem) {
            this.selectFindInItem(menuItem, 4, this.committerIcon, UIText.HistoryPage_findbar_changeto_reference);
        } else if (menuItem == this.referenceItem) {
            this.selectFindInItem(menuItem, 5, this.branchesIcon, UIText.HistoryPage_findbar_changeto_all);
        }
    }

    private void selectFindInItem(MenuItem menuItem, int preferenceValue, Image dropDownIcon, String dropDownToolTip) {
        this.prefsDropDown.setImage(dropDownIcon);
        this.prefsDropDown.setToolTipText(dropDownToolTip);
        this.findInPreferenceChanged(preferenceValue, menuItem);
    }

    private void findInPreferenceChanged(int findin, MenuItem item) {
        this.store.setValue("findtoolbar_find_in", findin);
        if (this.store.needsSaving()) {
            try {
                this.store.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
        this.allItem.setSelection(false);
        this.commitIdItem.setSelection(false);
        this.commentsItem.setSelection(false);
        this.authorItem.setSelection(false);
        this.committerItem.setSelection(false);
        this.referenceItem.setSelection(false);
        item.setSelection(true);
        this.clear();
    }

    private FindToolbarThread createFinder() {
        FindToolbarThread finder = new FindToolbarThread();
        finder.pattern = this.patternField.getText();
        finder.fileRevisions = this.fileRevisions;
        finder.toolbar = this;
        finder.ignoreCase = this.caseItem.getSelection();
        if (this.allItem.getSelection()) {
            finder.findInCommitId = true;
            finder.findInComments = true;
            finder.findInAuthor = true;
            finder.findInCommitter = true;
            finder.findInReference = true;
        } else {
            finder.findInCommitId = this.commitIdItem.getSelection();
            finder.findInComments = this.commentsItem.getSelection();
            finder.findInAuthor = this.authorItem.getSelection();
            finder.findInCommitter = this.committerItem.getSelection();
            finder.findInReference = this.referenceItem.getSelection();
        }
        return finder;
    }

    void setInput(RevFlag hFlag, Table historyTable, SWTCommit[] commitArray) {
        this.fileRevisions = commitArray;
        this.historyTable = historyTable;
        this.findResults.setHighlightFlag(hFlag);
    }

    void progressUpdate(int percent) {
        int total = this.findResults.size();
        this.currentPositionLabel.setText("-/" + total);
        this.currentPositionLabel.setForeground(null);
        if (total > 0) {
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            this.patternField.setBackground(null);
        } else {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        this.progressBar.setSelection(percent);
        this.historyTable.clearAll();
    }

    void findCompletionUpdate(String pattern, boolean overflow) {
        int total = this.findResults.size();
        if (total > 0) {
            if (overflow) {
                this.currentPositionLabel.setText(String.valueOf(UIText.HistoryPage_findbar_exceeded) + " 1/" + total);
            } else {
                this.currentPositionLabel.setText("1/" + total);
            }
            int ix = this.findResults.getFirstIndex();
            this.sendEvent(null, ix);
            this.patternField.setBackground(null);
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            this.lastErrorPattern = null;
        } else if (pattern.length() > 0) {
            this.patternField.setBackground(this.errorBackgroundColor);
            this.currentPositionLabel.setText(UIText.HistoryPage_findbar_notFound);
            if (this.lastErrorPattern == null || !this.lastErrorPattern.startsWith(pattern)) {
                this.getDisplay().beep();
                this.nextButton.setEnabled(false);
                this.previousButton.setEnabled(false);
            }
            this.lastErrorPattern = pattern;
        } else {
            this.patternField.setBackground(null);
            this.currentPositionLabel.setText("");
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            this.lastErrorPattern = null;
        }
        this.progressBar.setSelection(0);
        this.historyTable.clearAll();
        if (overflow) {
            Display display = this.getDisplay();
            this.currentPositionLabel.setForeground(display.getSystemColor(3));
            display.beep();
        } else {
            this.currentPositionLabel.setForeground(null);
        }
    }

    void clear() {
        this.patternField.setBackground(null);
        if (this.patternField.getText().length() > 0) {
            this.patternField.selectAll();
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        this.currentPositionLabel.setText("");
        this.progressBar.setSelection(0);
        this.lastErrorPattern = null;
        this.findResults.clear();
        if (this.historyTable != null) {
            this.historyTable.clearAll();
        }
        FindToolbarThread.updateGlobalThreadIx();
    }

    private void sendEvent(Widget widget, int index) {
        Event event = new Event();
        event.type = 13;
        event.index = index;
        event.widget = widget;
        event.data = this.fileRevisions[index];
        for (Listener listener : this.eventList) {
            listener.handleEvent(event);
        }
    }

    void addSelectionListener(Listener listener) {
        this.eventList.add(listener);
    }
}

