/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.CheckoutCommand;
import org.eclipse.egit.ui.internal.repository.tree.command.OpenInEditorCommand;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)nodes.get(0);
        if (node instanceof RefNode || node instanceof TagNode) {
            return new CheckoutCommand().execute(event);
        }
        if (node instanceof FileNode) {
            return new OpenInEditorCommand().execute(event);
        }
        if (node instanceof StashedCommitNode) {
            RepositoryCommit repositoryCommit = new RepositoryCommit(node.getRepository(), (RevCommit)((StashedCommitNode)node).getObject());
            repositoryCommit.setStash(true);
            CommitEditor.openQuiet(repositoryCommit);
        }
        return null;
    }
}

