/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.command.DeleteRepositoryConfirmDialog;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.removeRepository(event, false);
        return null;
    }

    protected void removeRepository(final ExecutionEvent event, final boolean delete) {
        List<RepositoryNode> selectedNodes;
        IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        IWorkbenchSiteProgressService service = CommonUtils.getService((IServiceLocator)activeSite, IWorkbenchSiteProgressService.class);
        try {
            selectedNodes = this.getSelectedNodes(event);
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
            return;
        }
        boolean deleteWorkingDir = false;
        boolean removeProjects = false;
        final List<IProject> projectsToDelete = this.findProjectsToDelete(selectedNodes);
        if (delete) {
            if (selectedNodes.size() > 1) {
                return;
            }
            if (selectedNodes.size() == 1) {
                Repository repository = (Repository)selectedNodes.get(0).getObject();
                if (repository.isBare()) {
                    String title = UIText.RemoveCommand_ConfirmDeleteBareRepositoryTitle;
                    String message = NLS.bind((String)UIText.RemoveCommand_ConfirmDeleteBareRepositoryMessage, (Object)repository.getDirectory().getPath());
                    if (!MessageDialog.openConfirm((Shell)this.getShell(event), (String)title, (String)message)) {
                        return;
                    }
                } else {
                    DeleteRepositoryConfirmDialog dlg = new DeleteRepositoryConfirmDialog(this.getShell(event), repository, projectsToDelete.size());
                    if (dlg.open() != 0) {
                        return;
                    }
                    deleteWorkingDir = dlg.shouldDeleteWorkingDir();
                    removeProjects = dlg.shouldRemoveProjects();
                }
            }
        } else if (!projectsToDelete.isEmpty()) {
            final boolean[] confirmedCanceled = new boolean[2];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        confirmedCanceled[0] = RemoveCommand.this.confirmProjectDeletion(projectsToDelete, event);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        confirmedCanceled[1] = true;
                    }
                }
            });
            if (confirmedCanceled[1]) {
                return;
            }
            removeProjects = confirmedCanceled[0];
        }
        final boolean deleteWorkDir = deleteWorkingDir;
        final boolean removeProj = removeProjects;
        WorkspaceJob job = new WorkspaceJob(UIText.RemoveCommand_RemoveRepositoriesJob){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                monitor.setTaskName(UIText.RepositoriesView_DeleteRepoDeterminProjectsMessage);
                if (removeProj) {
                    RemoveCommand.this.deleteProjects(delete, projectsToDelete, monitor);
                }
                for (RepositoryNode node : selectedNodes) {
                    RemoveCommand.this.util.removeDir(node.getRepository().getDirectory());
                }
                if (delete) {
                    try {
                        RemoveCommand.this.deleteRepositoryContent(selectedNodes, deleteWorkDir);
                    }
                    catch (IOException e) {
                        return Activator.createErrorStatus(e.getMessage(), e);
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REPOSITORY_DELETE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        service.schedule((Job)job);
    }

    private void deleteProjects(final boolean delete, final List<IProject> projectsToDelete, IProgressMonitor monitor) {
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                for (IProject prj : projectsToDelete) {
                    prj.delete(delete, false, actMonitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, monitor);
        }
        catch (CoreException e1) {
            Activator.logError(e1.getMessage(), e1);
        }
    }

    private void deleteRepositoryContent(List<RepositoryNode> selectedNodes, boolean deleteWorkDir) throws IOException {
        for (RepositoryNode node : selectedNodes) {
            boolean isWorkingDirEmpty;
            Object[] files;
            File workTree;
            Repository repo = node.getRepository();
            File file = workTree = deleteWorkDir && !repo.isBare() ? repo.getWorkTree() : null;
            if (workTree != null && (files = workTree.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    if (this.isTracked(file2, repo)) {
                        FileUtils.delete((File)file2, (int)3);
                    }
                    ++n2;
                }
            }
            repo.close();
            if (!repo.isBare()) {
                RemoveCommand.closeSubmoduleRepositories(repo);
            }
            FileUtils.delete((File)repo.getDirectory(), (int)7);
            if (workTree == null) continue;
            if (node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES) {
                FileUtils.delete((File)workTree, (int)7);
                node.getParent().getRepository().notifyIndexChanged();
            }
            boolean bl = isWorkingDirEmpty = (files = workTree.list()) != null && files.length == 0;
            if (!isWorkingDirEmpty) continue;
            FileUtils.delete((File)workTree, (int)6);
        }
    }

    /*
     * Exception decompiling
     */
    private static void closeSubmoduleRepositories(Repository repo) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isTracked(File file, Repository repo) throws IOException {
        ObjectId objectId = repo.resolve("HEAD");
        RevTree tree = objectId != null ? new RevWalk(repo).parseTree((AnyObjectId)objectId) : null;
        TreeWalk treeWalk = new TreeWalk(repo);
        treeWalk.setRecursive(true);
        if (tree != null) {
            treeWalk.addTree((AnyObjectId)tree);
        } else {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
        treeWalk.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(Repository.stripWorkDir((File)repo.getWorkTree(), (File)file))));
        return treeWalk.next();
    }

    private List<IProject> findProjectsToDelete(List<RepositoryNode> selectedNodes) {
        ArrayList<IProject> projectsToDelete = new ArrayList<IProject>();
        for (RepositoryNode node : selectedNodes) {
            if (node.getRepository().isBare()) continue;
            File workDir = node.getRepository().getWorkTree();
            Path wdPath = new Path(workDir.getAbsolutePath());
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                IPath location = prj.getLocation();
                if (location != null && wdPath.isPrefixOf(location)) {
                    projectsToDelete.add(prj);
                }
                ++n2;
            }
        }
        return projectsToDelete;
    }

    private boolean confirmProjectDeletion(List<IProject> projectsToDelete, ExecutionEvent event) throws OperationCanceledException {
        String message = NLS.bind((String)UIText.RepositoriesView_ConfirmProjectDeletion_Question, (Object)projectsToDelete.size());
        MessageDialog dlg = new MessageDialog(this.getShell(event), UIText.RepositoriesView_ConfirmProjectDeletion_WindowTitle, null, message, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int index = dlg.open();
        if (index == 0) {
            return true;
        }
        if (index == 1) {
            return false;
        }
        throw new OperationCanceledException();
    }
}

