/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.SubmoduleAddOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.submodule.AddSubmoduleWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleAddCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode<?>> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List nodes = this.getSelectedNodes(event);
        if (nodes.isEmpty()) {
            return null;
        }
        Repository repo = ((RepositoryTreeNode)nodes.get(0)).getRepository();
        if (repo == null) {
            return null;
        }
        AddSubmoduleWizard wizard = new AddSubmoduleWizard(repo);
        WizardDialog dialog = new WizardDialog(this.getShell(event), (IWizard)wizard);
        if (dialog.open() == 0) {
            String path = wizard.getPath();
            String uri = wizard.getUri().toPrivateASCIIString();
            final SubmoduleAddOperation op = new SubmoduleAddOperation(repo, path, uri);
            WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.SubmoduleAddCommand_JobTitle, path, uri)){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    monitor.beginTask("", -1);
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException e) {
                        Activator.logError(UIText.SubmoduleAddCommand_AddError, e);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (JobFamilies.SUBMODULE_ADD.equals(family)) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            job.setUser(true);
            job.setRule(op.getSchedulingRule());
            job.schedule();
        }
        return null;
    }
}

