/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Collection collection = (Collection)receiver;
        if (collection.isEmpty()) {
            return false;
        }
        if ("projectSingleRepository".equals(property)) {
            if (collection.size() != 1) {
                return false;
            }
            Repository repository = SelectionPropertyTester.getRepositoryOfProjects(collection, true);
            return SelectionPropertyTester.testRepositoryProperties(repository, args);
        }
        if ("projectsWithRepositories".equals(property)) {
            Repository repository = SelectionPropertyTester.getRepositoryOfProjects(collection, false);
            return repository != null;
        }
        if ("resourcesSingleRepository".equals(property)) {
            IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
            IResource[] resources = SelectionUtils.getSelectedResources(selection);
            Repository repository = SelectionPropertyTester.getRepositoryOfResources(resources);
            return SelectionPropertyTester.testRepositoryProperties(repository, args);
        }
        if ("fileOrFolderInRepository".equals(property)) {
            RepositoryMapping m;
            if (collection.size() != 1) {
                return false;
            }
            IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
            if (selection.size() != 1) {
                return false;
            }
            Object firstElement = selection.getFirstElement();
            IResource resource = (IResource)AdapterUtils.adapt((Object)firstElement, IResource.class);
            if ((resource instanceof IFile || resource instanceof IFolder) && (m = RepositoryMapping.getMapping((IResource)resource)) != null) {
                return SelectionPropertyTester.testRepositoryProperties(m.getRepository(), args);
            }
        }
        return false;
    }

    private static IStructuredSelection getStructuredSelection(Collection<?> collection) {
        Object firstElement = collection.iterator().next();
        if (collection.size() == 1 && firstElement instanceof ITextSelection) {
            return SelectionUtils.getStructuredSelection((ISelection)((ITextSelection)firstElement));
        }
        return new StructuredSelection(new ArrayList(collection));
    }

    private static boolean testRepositoryProperties(Repository repository, Object[] properties) {
        if (repository == null) {
            return false;
        }
        Object[] objectArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            String s = (String)arg;
            if (!ResourcePropertyTester.testRepositoryState(repository, s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static Repository getRepositoryOfProjects(Collection<?> collection, boolean single) {
        Repository repo = null;
        for (Object element : collection) {
            IProject project = (IProject)AdapterUtils.adapt(element, IProject.class);
            if (project != null) {
                Repository r = SelectionPropertyTester.getRepositoryOfMapping((IResource)project);
                if (single && r != null && repo != null && r != repo) {
                    return null;
                }
                if (r == null) continue;
                repo = r;
                continue;
            }
            IWorkingSet workingSet = (IWorkingSet)AdapterUtils.adapt(element, IWorkingSet.class);
            if (workingSet == null) continue;
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                Repository r = SelectionPropertyTester.getRepositoryOfProject(adaptable);
                if (single && r != null && repo != null && r != repo) {
                    return null;
                }
                if (r != null) {
                    repo = r;
                }
                ++n2;
            }
        }
        return repo;
    }

    private static Repository getRepositoryOfResources(IResource[] resources) {
        Repository repo = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Repository r = SelectionPropertyTester.getRepositoryOfMapping(resource);
            if (r != null && repo != null && r != repo) {
                return null;
            }
            if (r != null) {
                repo = r;
            }
            ++n2;
        }
        return repo;
    }

    private static Repository getRepositoryOfProject(Object object) {
        IProject project = (IProject)AdapterUtils.adapt((Object)object, IProject.class);
        if (project != null) {
            return SelectionPropertyTester.getRepositoryOfMapping((IResource)project);
        }
        return null;
    }

    private static Repository getRepositoryOfMapping(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping != null) {
            return mapping.getRepository();
        }
        return null;
    }
}

