/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecorationResult;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.util.FS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class StagingViewLabelProvider
extends LabelProvider {
    private StagingView stagingView;
    private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private Image DEFAULT = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image SUBMODULE = UIIcons.REPOSITORY.createImage();
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final GitLightweightDecorator.DecorationHelper decorationHelper = new GitLightweightDecorator.DecorationHelper(Activator.getDefault().getPreferenceStore());
    private boolean fileNameMode = false;

    public StagingViewLabelProvider(StagingView stagingView) {
        this.stagingView = stagingView;
    }

    public StagingViewLabelProvider setFileNameMode(boolean enable) {
        this.fileNameMode = enable;
        return this;
    }

    public void dispose() {
        this.SUBMODULE.dispose();
        this.resourceManager.dispose();
        super.dispose();
    }

    private Image getEditorImage(StagingEntry diff) {
        if (diff.isSubmodule()) {
            return this.SUBMODULE;
        }
        Image image = this.DEFAULT;
        String name = new Path(diff.getPath()).lastSegment();
        if (name != null) {
            ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
            image = (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
        }
        if (diff.isSymlink()) {
            try {
                String targetPath;
                File diffFile;
                IPath diffLocation = diff.getLocation();
                if (diffLocation != null && (diffFile = diffLocation.toFile()).exists() && (targetPath = FS.DETECTED.readSymLink(diffFile)) != null && new File(diffFile, targetPath).isDirectory()) {
                    image = this.FOLDER;
                }
            }
            catch (IOException e) {
                Activator.error(UIText.StagingViewLabelProvider_SymlinkError, e);
            }
            image = this.addSymlinkDecorationToImage(image);
        }
        return image;
    }

    private Image getDecoratedImage(Image base, ImageDescriptor decorator) {
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, decorator, 3);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    private Image addSymlinkDecorationToImage(Image base) {
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, UIIcons.OVR_SYMLINK, 1);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    public Image getImage(Object element) {
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry c = (StagingFolderEntry)element;
            if (c.getContainer() == null) {
                return this.FOLDER;
            }
            return this.workbenchLabelProvider.getImage((Object)((StagingFolderEntry)element).getContainer());
        }
        StagingEntry c = (StagingEntry)element;
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, c);
        return this.getDecoratedImage(this.getEditorImage(c), decoration.getOverlay());
    }

    public String getText(Object element) {
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
            return stagingFolderEntry.getNodePath().toString();
        }
        StagingEntry stagingEntry = (StagingEntry)element;
        DecorationResult decoration = new DecorationResult();
        this.decorationHelper.decorate(decoration, stagingEntry);
        StyledString styled = new StyledString();
        String prefix = decoration.getPrefix();
        String suffix = decoration.getSuffix();
        if (prefix != null) {
            styled.append(prefix, StyledString.DECORATIONS_STYLER);
        }
        if (this.stagingView.getPresentation() == StagingView.Presentation.LIST) {
            if (this.fileNameMode) {
                IPath parsed = Path.fromOSString((String)stagingEntry.getPath());
                if (parsed.segmentCount() > 1) {
                    styled.append(parsed.lastSegment());
                    if (suffix != null) {
                        styled.append(suffix, StyledString.DECORATIONS_STYLER);
                    }
                    styled.append(' ');
                    styled.append('-', StyledString.QUALIFIER_STYLER);
                    styled.append(' ');
                    styled.append(parsed.removeLastSegments(1).toString(), StyledString.QUALIFIER_STYLER);
                } else {
                    styled.append(stagingEntry.getPath());
                    if (suffix != null) {
                        styled.append(suffix, StyledString.DECORATIONS_STYLER);
                    }
                }
            } else {
                styled.append(stagingEntry.getPath());
                if (suffix != null) {
                    styled.append(suffix, StyledString.DECORATIONS_STYLER);
                }
            }
        } else {
            styled.append(stagingEntry.getName());
        }
        return styled.toString();
    }
}

