/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class AnalyzerFactory
implements IExecutableExtension {
    private String locale = null;

    public Analyzer create() {
        if (this.locale == null) {
            return null;
        }
        Version version = Version.LUCENE_35;
        if ("pt".equals(this.locale)) {
            return new BrazilianAnalyzer(version);
        }
        if ("ja".equals(this.locale)) {
            return new CJKAnalyzer(version);
        }
        if ("ko".equals(this.locale)) {
            return new CJKAnalyzer(version);
        }
        if ("pt".equals(this.locale)) {
            return new BrazilianAnalyzer(version);
        }
        if ("cs".equals(this.locale)) {
            return new CzechAnalyzer(version);
        }
        if ("de".equals(this.locale)) {
            return new GermanAnalyzer(version);
        }
        if ("el".equals(this.locale)) {
            return new GreekAnalyzer(version);
        }
        if ("fr".equals(this.locale)) {
            return new FrenchAnalyzer(version);
        }
        if ("nl".equals(this.locale)) {
            return new DutchAnalyzer(version);
        }
        if ("ru".equals(this.locale)) {
            return new RussianAnalyzer(version);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.locale = (String)data;
        }
    }
}

