/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.eclipse.help.internal.search.QueryWordsToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryWordsPhrase
extends QueryWordsToken {
    private List<String> words = new ArrayList<String>();

    public QueryWordsPhrase() {
        super(4, "");
    }

    public void addWord(String word) {
        this.words.add(word);
        this.value = this.words.size() <= 1 ? word : String.valueOf(this.value) + " " + word;
    }

    public List<String> getWords() {
        return this.words;
    }

    @Override
    public Query createLuceneQuery(String field, float boost) {
        PhraseQuery q = new PhraseQuery();
        for (String word : this.getWords()) {
            Term t = new Term(field, word);
            q.add(t);
            q.setBoost(boost);
        }
        return q;
    }
}

