/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.TargetContentsGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ContentSection
extends SectionPart {
    private TargetContentsGroup fContentGroup;
    private TargetEditor fEditor;

    public ContentSection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        section.setText(PDEUIMessages.ContentSection_0);
        section.setDescription(PDEUIMessages.ContentSection_1);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        client.setLayoutData((Object)new GridData(1808));
        this.fContentGroup = TargetContentsGroup.createInForm(client, toolkit);
        this.fEditor.getTargetChangedListener().setContentTree(this.fContentGroup);
        this.fContentGroup.addTargetChangedListener(this.fEditor.getTargetChangedListener());
        this.fContentGroup.addTargetChangedListener(new ITargetChangedListener(){

            @Override
            public void contentsChanged(ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
                ContentSection.this.markDirty();
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    public void refresh() {
        this.fEditor.getTargetChangedListener().contentsChanged(this.getTarget(), (Object)this, false, false);
        super.refresh();
    }
}

