/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.refactoring.CreateHeaderChangeOperation;

public class FindReferenceOperation
implements IWorkspaceRunnable {
    private BundleDescription fDesc;
    private String fNewId;
    private Change[] fChanges;

    public FindReferenceOperation(BundleDescription desc, String newId) {
        this.fDesc = desc;
        this.fNewId = newId;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        ArrayList<TextFileChange> list = new ArrayList<TextFileChange>();
        if (this.fDesc != null) {
            monitor.beginTask("", 3);
            this.findRequireBundleReferences(list, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.findFragmentReferences(list, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.findXFriendReferences(list, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        this.fChanges = list.toArray(new Change[list.size()]);
    }

    public Change[] getChanges() {
        return this.fChanges;
    }

    private void findRequireBundleReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        String oldId = this.fDesc.getSymbolicName();
        BundleDescription[] dependents = this.fDesc.getDependents();
        monitor.beginTask("", dependents.length);
        int i = 0;
        while (i < dependents.length) {
            BundleSpecification[] requires = dependents[i].getRequiredBundles();
            boolean found = false;
            int j = 0;
            while (j < requires.length) {
                if (requires[j].getName().equals(oldId)) {
                    CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((BundleDescription)dependents[i]), "Require-Bundle", oldId, this.fNewId);
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    TextFileChange change = op.getChange();
                    if (change != null) {
                        changes.add(change);
                    }
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                monitor.worked(1);
            }
            ++i;
        }
    }

    private void findFragmentReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        BundleDescription[] fragments = this.fDesc.getFragments();
        monitor.beginTask("", fragments.length);
        String id = this.fDesc.getSymbolicName();
        int i = 0;
        while (i < fragments.length) {
            IPluginModelBase base = PluginRegistry.findModel((BundleDescription)fragments[i]);
            if (base instanceof IFragmentModel && id.equals(((IFragmentModel)base).getFragment().getPluginId())) {
                CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(base, "Fragment-Host", id, this.fNewId);
                op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                TextFileChange change = op.getChange();
                if (change != null) {
                    changes.add(change);
                }
            } else {
                monitor.worked(1);
            }
            ++i;
        }
    }

    private void findXFriendReferences(ArrayList<TextFileChange> changes, IProgressMonitor monitor) throws CoreException {
        StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
        ExportPackageDescription[] pkgs = helper.getVisiblePackages(this.fDesc);
        String id = this.fDesc.getSymbolicName();
        monitor.beginTask("", pkgs.length);
        int i = 0;
        while (i < pkgs.length) {
            String[] friends = (String[])pkgs[i].getDirective("x-friends");
            if (friends != null) {
                int j = 0;
                while (j < friends.length) {
                    if (friends[j].equals(id)) {
                        CreateHeaderChangeOperation op = new CreateHeaderChangeOperation(PluginRegistry.findModel((BundleDescription)pkgs[i].getExporter()), "Export-Package", id, this.fNewId);
                        op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        TextFileChange change = op.getChange();
                        if (change == null) break;
                        changes.add(change);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

