/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickOperation
implements IEGitOperation {
    private final Repository repo;
    private List<RevCommit> commits;
    private RebaseResult result;

    public CherryPickOperation(Repository repository, List<RevCommit> commits) {
        this.repo = repository;
        this.commits = commits;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 2);
                pm.subTask(MessageFormat.format(CoreText.CherryPickOperation_cherryPicking, CherryPickOperation.this.commits.size()));
                RebaseCommand.InteractiveHandler handler = new RebaseCommand.InteractiveHandler(){

                    public void prepareSteps(List<RebaseTodoLine> steps) {
                        for (RebaseTodoLine step : steps) {
                            try {
                                step.setAction(RebaseTodoLine.Action.PICK);
                            }
                            catch (IllegalTodoFileModification illegalTodoFileModification) {}
                        }
                        ArrayList stepCommits = new ArrayList(CherryPickOperation.this.commits);
                        Collections.reverse(stepCommits);
                        for (RevCommit commit : stepCommits) {
                            RebaseTodoLine step = new RebaseTodoLine(RebaseTodoLine.Action.PICK, commit.abbreviate(7), "");
                            steps.add(step);
                        }
                    }

                    public String modifyCommitMessage(String oldMessage) {
                        return oldMessage;
                    }
                };
                try {
                    Git git = new Git(CherryPickOperation.this.repo);
                    ObjectId headCommitId = CherryPickOperation.this.repo.resolve("HEAD");
                    RevCommit headCommit = new RevWalk(CherryPickOperation.this.repo).parseCommit((AnyObjectId)headCommitId);
                    CherryPickOperation.this.result = git.rebase().setUpstream(headCommit.getParent(0)).runInteractively(handler).setOperation(RebaseCommand.Operation.BEGIN).call();
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                pm.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(CherryPickOperation.this.repo), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                pm.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repo);
    }

    public RebaseResult getResult() {
        return this.result;
    }
}

