/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class StashApplyOperation
implements IEGitOperation {
    private final Repository repository;
    private final RevCommit commit;

    public StashApplyOperation(Repository repository, RevCommit commit) {
        this.repository = repository;
        this.commit = commit;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 3);
                try {
                    try {
                        IProject[] validProjects = ProjectUtil.getValidOpenProjects(StashApplyOperation.this.repository);
                        pm.worked(1);
                        Git.wrap((Repository)StashApplyOperation.this.repository).stashApply().setStashRef(StashApplyOperation.this.commit.name()).call();
                        pm.worked(1);
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    }
                    catch (JGitInternalException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                    catch (GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    pm.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

