/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurroundWithTryCatchRefactoring
extends Refactoring {
    public static final String GROUP_EXC_TYPE = "exc_type";
    public static final String GROUP_EXC_NAME = "exc_name";
    private Selection fSelection;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode[] fSelectedNodes;
    private LinkedProposalModel fLinkedProposalModel;
    private final boolean fIsMultiCatch;

    private SurroundWithTryCatchRefactoring(ICompilationUnit cu, Selection selection, boolean isMultiCatch) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fIsMultiCatch = isMultiCatch;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, ITextSelection selection) {
        return SurroundWithTryCatchRefactoring.create(cu, selection, false);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length) {
        return SurroundWithTryCatchRefactoring.create(cu, offset, length, false);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, ITextSelection selection, boolean isMultiCatch) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(selection.getOffset(), selection.getLength()), isMultiCatch);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit cu, int offset, int length, boolean isMultiCatch) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(offset, length), isMultiCatch);
    }

    public LinkedProposalModel getLinkedProposalModel() {
        return this.fLinkedProposalModel;
    }

    public void setLeaveDirty(boolean leaveDirty) {
        this.fLeaveDirty = leaveDirty;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.SurroundWithTryCatchRefactoring_name;
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        if (this.fIsMultiCatch && (exceptions == null || exceptions.length <= 1)) {
            result.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.SurroundWithTryCatchRefactoring_notMultipleexceptions));
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        CompilationUnit rootNode = new RefactoringASTParser(8).parse((ITypeRoot)this.fCUnit, true, pm);
        return this.checkActivationBasics(rootNode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 2);
        try {
            CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
            if (this.fLeaveDirty) {
                result.setSaveMode(4);
            }
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            this.fRewriter = ASTRewrite.create((AST)this.fAnalyzer.getEnclosingBodyDeclaration().getAST());
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(this.fAnalyzer.getSelectedNodes(), this.fCUnit.getBuffer(), this.fSelection.getOffset(), this.fSelection.getLength()));
            this.fImportRewrite = StubUtility.createImportRewrite(this.fRootNode, true);
            this.fLinkedProposalModel = new LinkedProposalModel();
            this.fScope = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
            this.fScope.setCursor(this.fSelection.getOffset());
            this.fSelectedNodes = this.fAnalyzer.getSelectedNodes();
            this.createTryCatchStatement(this.fCUnit.getBuffer(), this.fCUnit.findRecommendedLineSeparator());
            if (this.fImportRewrite.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewrite.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{edit}));
            }
            TextEdit change = this.fRewriter.rewriteAST();
            root.addChild(change);
            result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{change}));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void createTryCatchStatement(IBuffer buffer, String lineDelimiter) throws CoreException {
        ArrayList<Object> result = new ArrayList<Object>(1);
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), this.fImportRewrite);
        if (!this.fIsMultiCatch) {
            int i = 0;
            while (i < exceptions.length) {
                ITypeBinding exception = exceptions[i];
                CatchClause catchClause = this.getAST().newCatchClause();
                tryStatement.catchClauses().add(catchClause);
                SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
                String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
                String name = this.fScope.createName(varName, false);
                decl.setName(this.getAST().newSimpleName(name));
                Type type = this.fImportRewrite.addImport(exception, this.getAST(), (ImportRewrite.ImportRewriteContext)context);
                decl.setType(type);
                catchClause.setException(decl);
                Statement st = this.getCatchBody(ASTNodes.getQualifiedTypeName(type), name, lineDelimiter);
                if (st != null) {
                    catchClause.getBody().statements().add(st);
                }
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(this.fRewriter.track((ASTNode)decl.getType()), i == 0);
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_NAME + i, true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
                ++i;
            }
        } else {
            List<ITypeBinding> filteredExceptions = this.filterSubtypeExceptions(exceptions);
            CatchClause catchClause = this.getAST().newCatchClause();
            SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
            String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
            String name = this.fScope.createName(varName, false);
            decl.setName(this.getAST().newSimpleName(name));
            UnionType unionType = this.getAST().newUnionType();
            List types = unionType.types();
            int i = 0;
            for (ITypeBinding exception : filteredExceptions) {
                Type type = this.fImportRewrite.addImport(exception, this.getAST(), (ImportRewrite.ImportRewriteContext)context);
                types.add(type);
                this.fLinkedProposalModel.getPositionGroup(GROUP_EXC_TYPE + i, true).addPosition(this.fRewriter.track((ASTNode)type), i == 0);
                ++i;
            }
            decl.setType((Type)unionType);
            catchClause.setException(decl);
            this.fLinkedProposalModel.getPositionGroup("exc_name0", true).addPosition(this.fRewriter.track((ASTNode)decl.getName()), false);
            Statement st = this.getCatchBody("Exception", name, lineDelimiter);
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            tryStatement.catchClauses().add(catchClause);
        }
        List<ASTNode> variableDeclarations = this.getSpecialVariableDeclarationStatements();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)tryStatement.getBody(), Block.STATEMENTS_PROPERTY);
        boolean selectedNodeRemoved = false;
        ASTNode expressionStatement = null;
        int i = 0;
        while (i < this.fSelectedNodes.length) {
            ASTNode node = this.fSelectedNodes[i];
            if (node instanceof VariableDeclarationStatement && variableDeclarations.contains(node)) {
                AST ast = this.getAST();
                VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
                VariableDeclarationStatement copy = (VariableDeclarationStatement)ASTNode.copySubtree((AST)ast, (ASTNode)statement);
                List modifiers = copy.modifiers();
                Iterator iter = modifiers.iterator();
                while (iter.hasNext()) {
                    IExtendedModifier modifier = (IExtendedModifier)iter.next();
                    if (!modifier.isModifier() || !Modifier.isFinal((int)((Modifier)modifier).getKeyword().toFlagValue())) continue;
                    iter.remove();
                }
                List fragments = copy.fragments();
                for (VariableDeclarationFragment fragment : fragments) {
                    fragment.setInitializer(null);
                }
                CompilationUnit root = (CompilationUnit)statement.getRoot();
                int extendedStart = root.getExtendedStartPosition((ASTNode)statement);
                if (extendedStart != statement.getStartPosition() && extendedStart >= this.fSelection.getOffset()) {
                    String commentToken = buffer.getText(extendedStart, statement.getStartPosition() - extendedStart);
                    commentToken = Strings.trimTrailingTabsAndSpaces(commentToken);
                    Type type = statement.getType();
                    String typeName = buffer.getText(type.getStartPosition(), type.getLength());
                    copy.setType((Type)this.fRewriter.createStringPlaceholder(String.valueOf(commentToken) + typeName, type.getNodeType()));
                }
                result.add(copy);
                fragments = statement.fragments();
                if (!fragments.isEmpty()) {
                    ArrayList<ExpressionStatement> newExpressionStatements = new ArrayList<ExpressionStatement>();
                    for (VariableDeclarationFragment fragment : fragments) {
                        Expression initializer = fragment.getInitializer();
                        if (initializer == null) continue;
                        Assignment assignment = ast.newAssignment();
                        assignment.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)fragment.getName()));
                        assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)initializer));
                        newExpressionStatements.add(ast.newExpressionStatement((Expression)assignment));
                    }
                    if (!newExpressionStatements.isEmpty()) {
                        if (this.fSelectedNodes.length == 1) {
                            expressionStatement = this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()]));
                        } else {
                            this.fRewriter.replace((ASTNode)statement, this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()])), null);
                        }
                    } else {
                        this.fRewriter.remove((ASTNode)statement, null);
                        selectedNodeRemoved = true;
                    }
                } else {
                    this.fRewriter.remove((ASTNode)statement, null);
                    selectedNodeRemoved = true;
                }
            }
            ++i;
        }
        result.add(tryStatement);
        ASTNode replacementNode = result.size() == 1 ? (ASTNode)result.get(0) : this.fRewriter.createGroupNode(result.toArray(new ASTNode[result.size()]));
        if (this.fSelectedNodes.length == 1) {
            if (expressionStatement != null) {
                statements.insertLast(expressionStatement, null);
            } else if (!selectedNodeRemoved) {
                statements.insertLast(this.fRewriter.createMoveTarget(this.fSelectedNodes[0]), null);
            }
            this.fRewriter.replace(this.fSelectedNodes[0], replacementNode, null);
        } else {
            ListRewrite source = this.fRewriter.getListRewrite(this.fSelectedNodes[0].getParent(), (ChildListPropertyDescriptor)this.fSelectedNodes[0].getLocationInParent());
            ASTNode toMove = source.createMoveTarget(this.fSelectedNodes[0], this.fSelectedNodes[this.fSelectedNodes.length - 1], replacementNode, null);
            statements.insertLast(toMove, null);
        }
    }

    private List<ITypeBinding> filterSubtypeExceptions(ITypeBinding[] exceptions) {
        ArrayList<ITypeBinding> filteredExceptions = new ArrayList<ITypeBinding>();
        filteredExceptions.addAll(Arrays.asList(exceptions));
        Iterator subtypeIterator = filteredExceptions.iterator();
        block0: while (subtypeIterator.hasNext()) {
            ITypeBinding iTypeBinding = (ITypeBinding)subtypeIterator.next();
            for (ITypeBinding superTypeBinding : filteredExceptions) {
                if (iTypeBinding.equals((Object)superTypeBinding) || !iTypeBinding.isSubTypeCompatible(superTypeBinding)) continue;
                subtypeIterator.remove();
                continue block0;
            }
        }
        return filteredExceptions;
    }

    private List<ASTNode> getSpecialVariableDeclarationStatements() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(3);
        VariableDeclaration[] locals = this.fAnalyzer.getAffectedLocals();
        int i = 0;
        while (i < locals.length) {
            ASTNode parent = locals[i].getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++i;
        }
        return result;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, this.fSelectedNodes[0], lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(s, 41);
    }
}

