/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.jdt.internal.ui.util.PatternMatcher;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;

public class TypeInfoFilter {
    private final String fText;
    private final IJavaSearchScope fSearchScope;
    private final boolean fIsWorkspaceScope;
    private final int fElementKind;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
    private final PatternMatcher fPackageMatcher;
    private final PatternMatcher fNameMatcher;
    private static final int TYPE_MODIFIERS = 25088;

    public TypeInfoFilter(String text, IJavaSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
        this.fText = text;
        this.fSearchScope = scope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope());
        this.fElementKind = elementKind;
        this.fFilterExtension = extension;
        int index = text.lastIndexOf(".");
        if (index == -1) {
            this.fNameMatcher = new PatternMatcher(text);
            this.fPackageMatcher = null;
        } else {
            this.fPackageMatcher = new PatternMatcher(this.evaluatePackagePattern(text.substring(0, index)));
            String name = text.substring(index + 1);
            if (name.length() == 0) {
                name = "*";
            }
            this.fNameMatcher = new PatternMatcher(name);
        }
    }

    private String evaluatePackagePattern(String s) {
        StringBuffer buf = new StringBuffer();
        boolean hasWildCard = false;
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '.') {
                if (!hasWildCard) {
                    buf.append('*');
                }
                hasWildCard = false;
            } else if (ch == '*' || ch == '?') {
                hasWildCard = true;
            }
            buf.append(ch);
            ++i;
        }
        if (!hasWildCard) {
            if (len == 0) {
                buf.append('?');
            }
            buf.append('*');
        }
        return buf.toString();
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        return this.fText.indexOf(46, text.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        int ccMask = 384;
        return (this.fNameMatcher.getMatchKind() & ccMask) != 0;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public int getElementKind() {
        return this.fElementKind;
    }

    public IJavaSearchScope getSearchScope() {
        return this.fSearchScope;
    }

    public int getPackageFlags() {
        if (this.fPackageMatcher == null) {
            return 0;
        }
        return this.fPackageMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(TypeNameMatch type) {
        return Strings.startsWithIgnoreCase(type.getSimpleTypeName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(TypeNameMatch type) {
        if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesHistoryElement(TypeNameMatch type) {
        if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesFilterExtension(TypeNameMatch type) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setMatch(type);
        return this.fFilterExtension.select(this.fAdapter);
    }

    private boolean matchesName(TypeNameMatch type) {
        if (this.fText.length() == 0) {
            return true;
        }
        return this.fNameMatcher.matches(type.getSimpleTypeName());
    }

    private boolean matchesPackage(TypeNameMatch type) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(type.getTypeContainerName());
    }

    private boolean matchesScope(TypeNameMatch type) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return this.fSearchScope.encloses((IJavaElement)type.getType());
    }

    private boolean matchesModifiers(TypeNameMatch type) {
        if (this.fElementKind == 0) {
            return true;
        }
        int modifiers = type.getModifiers() & 0x6200;
        switch (this.fElementKind) {
            case 5: {
                return modifiers == 0;
            }
            case 8: {
                return Flags.isAnnotation((int)modifiers);
            }
            case 6: {
                return modifiers == 512;
            }
            case 7: {
                return Flags.isEnum((int)modifiers);
            }
            case 10: {
                return modifiers == 0 || modifiers == 512;
            }
            case 9: {
                return modifiers == 0 || Flags.isEnum((int)modifiers);
            }
            case 11: {
                return Flags.isInterface((int)modifiers);
            }
        }
        return false;
    }
}

