/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.HashSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

class SearchScopeProjectAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeProjectAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_project_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_project_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IJavaSearchScope getSearchScope(int includeMask) {
        IMember[] members = this.fGroup.getView().getInputElements();
        if (members == null) {
            return null;
        }
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < members.length) {
            projects.add(members[i].getJavaProject());
            ++i;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])((IJavaElement[])projects.toArray(new IJavaProject[projects.size()])), (int)includeMask);
    }

    public int getSearchScopeType() {
        return 2;
    }

    public String getFullDescription(int includeMask) {
        IMember[] members = this.fGroup.getView().getInputElements();
        if (members != null) {
            HashSet<String> projectNames = new HashSet<String>();
            int i = 0;
            while (i < members.length) {
                projectNames.add(members[i].getJavaProject().getElementName());
                ++i;
            }
            JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
            return factory.getProjectScopeDescription(projectNames.toArray(new String[projectNames.size()]), includeMask);
        }
        return "";
    }
}

