/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    public int F_PUBLIC = 1;
    public int F_PRIVATE = 2;
    public int F_PROTECTED = 4;
    public int F_STATIC = 8;
    public int F_FINAL = 16;
    public int F_ABSTRACT = 1024;
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String MODIFIERS = "NewTypeWizardPage.modifiers";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private StringButtonStatusDialogField fPackageDialogField;
    private SelectionButtonDialogField fEnclosingTypeSelection;
    private StringButtonDialogField fEnclosingTypeDialogField;
    private boolean fCanModifyPackage;
    private boolean fCanModifyEnclosingType;
    private IPackageFragment fCurrPackage;
    private IType fCurrEnclosingType;
    private IType fCurrType;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField<InterfaceWrapper> fSuperInterfacesDialogField;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;
    private SelectionButtonDialogField fAddCommentButton;
    private boolean fUseAddCommentButtonValue;
    private IType fCreatedType;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private JavaTypeCompletionProcessor fEnclosingTypeCompletionProcessor;
    private StubTypeContext fSuperClassStubTypeContext;
    private StubTypeContext fSuperInterfaceStubTypeContext;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fPackageStatus;
    protected IStatus fTypeNameStatus;
    protected IStatus fSuperClassStatus;
    protected IStatus fModifierStatus;
    protected IStatus fSuperInterfacesStatus;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;
    private final int STATIC_INDEX = 2;
    private final int ENUM_ANNOT_STATIC_INDEX = 1;
    private int fTypeKind;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    public static final int ENUM_TYPE = 3;
    public static final int ANNOTATION_TYPE = 4;

    public NewTypeWizardPage(boolean isClass, String pageName) {
        this(isClass ? 1 : 2, pageName);
    }

    public NewTypeWizardPage(int typeKind, String pageName) {
        super(pageName);
        this.fTypeKind = typeKind;
        this.fCreatedType = null;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fPackageDialogField = new StringButtonStatusDialogField(adapter);
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(this.getPackageLabel());
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_package_button);
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener(adapter);
        this.fEnclosingTypeSelection.setLabelText(this.getEnclosingTypeLabel());
        this.fEnclosingTypeDialogField = new StringButtonDialogField(adapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener(adapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_enclosing_button);
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener(adapter);
        this.fTypeNameDialogField.setLabelText(this.getTypeNameLabel());
        this.fSuperClassDialogField = new StringButtonDialogField(adapter);
        this.fSuperClassDialogField.setDialogFieldListener(adapter);
        this.fSuperClassDialogField.setLabelText(this.getSuperClassLabel());
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField<InterfaceWrapper>(adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener(adapter);
        this.fSuperInterfacesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fSuperInterfacesDialogField.setLabelText(this.getSuperInterfacesLabel());
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        String[] buttonNames1 = new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_public, NewWizardMessages.NewTypeWizardPage_modifiers_default, NewWizardMessages.NewTypeWizardPage_modifiers_private, NewWizardMessages.NewTypeWizardPage_modifiers_protected};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.setLabelText(this.getModifiersLabel());
        this.fAccMdfButtons.setSelection(0, true);
        String[] buttonNames2 = this.fTypeKind == 1 ? new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_abstract, NewWizardMessages.NewTypeWizardPage_modifiers_final, NewWizardMessages.NewTypeWizardPage_modifiers_static} : (this.fTypeKind == 3 || this.fTypeKind == 4 ? new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_abstract, NewWizardMessages.NewTypeWizardPage_modifiers_static} : new String[]{});
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.enableSelectionButton(2, false);
        this.fAccMdfButtons.enableSelectionButton(3, false);
        this.fOtherMdfButtons.enableSelectionButton(2, false);
        if (this.fTypeKind == 3 || this.fTypeKind == 4) {
            this.fOtherMdfButtons.enableSelectionButton(0, false);
            this.fOtherMdfButtons.enableSelectionButton(1, false);
        }
        this.fAddCommentButton = new SelectionButtonDialogField(32);
        this.fAddCommentButton.setLabelText(NewWizardMessages.NewTypeWizardPage_addcomment_label);
        this.fUseAddCommentButtonValue = false;
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.fEnclosingTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        this.fPackageStatus = new StatusInfo();
        this.fEnclosingTypeStatus = new StatusInfo();
        this.fCanModifyPackage = true;
        this.fCanModifyEnclosingType = true;
        this.updateEnableState();
        this.fTypeNameStatus = new StatusInfo();
        this.fSuperClassStatus = new StatusInfo();
        this.fSuperInterfacesStatus = new StatusInfo();
        this.fModifierStatus = new StatusInfo();
    }

    protected void initTypePage(IJavaElement elem) {
        String text;
        String initSuperclass = "java.lang.Object";
        ArrayList<String> initSuperinterfaces = new ArrayList<String>(5);
        IJavaProject project = null;
        IPackageFragment pack = null;
        IType enclosingType = null;
        if (elem != null) {
            IType typeInCU;
            project = elem.getJavaProject();
            pack = (IPackageFragment)elem.getAncestor(4);
            if (pack == null && project != null) {
                pack = this.getPackage(project);
            }
            if ((typeInCU = (IType)elem.getAncestor(7)) != null) {
                if (typeInCU.getCompilationUnit() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
            try {
                IType type = null;
                if (elem.getElementType() == 7 && (type = (IType)elem).exists()) {
                    String superName = SuperInterfaceSelectionDialog.getNameWithTypeParameters(type);
                    if (type.isInterface()) {
                        initSuperinterfaces.add(superName);
                    } else {
                        initSuperclass = superName;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        String typeName = "";
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && (text = selection.getText()) != null && NewTypeWizardPage.validateJavaTypeName(text, project).isOK()) {
            typeName = text;
        }
        this.setPackageFragment(pack, true);
        this.setEnclosingType(enclosingType, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(typeName, true);
        this.setSuperClass(initSuperclass, true);
        this.setSuperInterfaces(initSuperinterfaces, true);
        this.setAddComments(StubUtility.doAddComments(project), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPackageFragment getPackage(IJavaProject javaProject) {
        String packName = null;
        IPackageFragmentRoot pkgFragmentRoot = this.getPackageFragmentRoot();
        IJavaElement[] packages = null;
        try {
            if (pkgFragmentRoot == null) return null;
            if (!pkgFragmentRoot.exists()) return null;
            packages = pkgFragmentRoot.getChildren();
            if (packages.length == 1) {
                packName = javaProject.getElementName();
                IStatus status = NewTypeWizardPage.validatePackageName(packName, javaProject);
                if (status.getSeverity() != 0) return null;
                return pkgFragmentRoot.getPackageFragment(packName);
            }
            int noOfPackages = 0;
            IPackageFragment thePackage = null;
            IJavaElement[] iJavaElementArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (noOfPackages != true) return null;
                    packName = thePackage.getElementName();
                    return pkgFragmentRoot.getPackageFragment(packName);
                }
                IJavaElement pack = iJavaElementArray[n2];
                IPackageFragment pkg = (IPackageFragment)pack;
                if (!(pkg.hasSubpackages() && !pkg.hasChildren() || pkg.isDefaultPackage())) {
                    thePackage = pkg;
                    if (++noOfPackages > 1) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private static IStatus validateJavaTypeName(String text, IJavaProject project) {
        if (project == null || !project.exists()) {
            return JavaConventions.validateJavaTypeName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validateJavaTypeName(text, (IJavaElement)project);
    }

    private static IStatus validatePackageName(String text, IJavaProject project) {
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validatePackageName(text, (IJavaElement)project);
    }

    protected String getPackageLabel() {
        return NewWizardMessages.NewTypeWizardPage_package_label;
    }

    protected String getEnclosingTypeLabel() {
        return NewWizardMessages.NewTypeWizardPage_enclosing_selection_label;
    }

    protected String getTypeNameLabel() {
        return NewWizardMessages.NewTypeWizardPage_typename_label;
    }

    protected String getModifiersLabel() {
        return NewWizardMessages.NewTypeWizardPage_modifiers_acc_label;
    }

    protected String getSuperClassLabel() {
        return NewWizardMessages.NewTypeWizardPage_superclass_label;
    }

    protected String getSuperInterfacesLabel() {
        if (this.fTypeKind != 2) {
            return NewWizardMessages.NewTypeWizardPage_interfaces_class_label;
        }
        return NewWizardMessages.NewTypeWizardPage_interfaces_ifc_label;
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fPackageDialogField.getTextControl(null);
        BidiUtils.applyBidiProcessing((Text)text, (String)"java");
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fCurrPackageCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text text = this.fEnclosingTypeDialogField.getTextControl(composite);
        SWTUtil.setAccessibilityText((Control)text, NewWizardMessages.NewTypeWizardPage_enclosing_field_description);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fEnclosingTypeCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text text = this.fTypeNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        TextFieldNavigationHandler.install(text);
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (NewTypeWizardPage.this.fCanModifyPackage && !NewTypeWizardPage.this.fEnclosingTypeSelection.isSelected() && e.start == 0 && e.end == ((Text)e.widget).getCharCount()) {
                    String typeNameWithoutParameters = NewTypeWizardPage.getTypeNameWithoutParameters(e.text);
                    int lastDot = typeNameWithoutParameters.lastIndexOf(46);
                    if (lastDot == -1 || lastDot == typeNameWithoutParameters.length() - 1) {
                        return;
                    }
                    String pack = typeNameWithoutParameters.substring(0, lastDot);
                    if (NewTypeWizardPage.validatePackageName(pack, null).getSeverity() == 4) {
                        return;
                    }
                    NewTypeWizardPage.this.fPackageDialogField.setText(pack);
                    e.text = e.text.substring(lastDot + 1);
                }
            }
        });
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), 1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
        if (this.fTypeKind == 1) {
            DialogField.createEmptySpace(composite);
            control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
            gd = new GridData(256);
            gd.horizontalSpan = nColumns - 2;
            control.setLayoutData((Object)gd);
            DialogField.createEmptySpace(composite);
        }
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        BidiUtils.applyBidiProcessing((Text)text, (String)"java");
        JavaTypeCompletionProcessor superClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        superClassCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperClassStubTypeContext();
            }
        });
        ControlContentAssistHelper.createTextContentAssistant(text, superClassCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        final TableViewer tableViewer = this.fSuperInterfacesDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        TableTextCellEditor cellEditor = new TableTextCellEditor(tableViewer, 0){

            protected Control createControl(Composite parent) {
                Control control = super.createControl(parent);
                BidiUtils.applyBidiProcessing((Text)this.text, (String)"java");
                return control;
            }

            protected void doSetFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                    this.text.setSelection(this.text.getText().length());
                    this.checkSelection();
                    this.checkDeleteable();
                    this.checkSelectable();
                }
            }
        };
        JavaTypeCompletionProcessor superInterfaceCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        superInterfaceCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperInterfacesStubTypeContext();
            }
        });
        SubjectControlContentAssistant contentAssistant = ControlContentAssistHelper.createJavaContentAssistant(superInterfaceCompletionProcessor);
        Text cellEditorText = cellEditor.getText();
        ContentAssistHandler.createHandlerForText((Text)cellEditorText, (SubjectControlContentAssistant)contentAssistant);
        TextFieldNavigationHandler.install(cellEditorText);
        cellEditor.setContentAssistant(contentAssistant);
        tableViewer.setCellEditors(new CellEditor[]{cellEditor});
        tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                ((InterfaceWrapper)element).interfaceName = (String)value;
                NewTypeWizardPage.this.fSuperInterfacesDialogField.elementChanged((InterfaceWrapper)element);
            }

            public Object getValue(Object element, String property) {
                return ((InterfaceWrapper)element).interfaceName;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fTypeKind == 1 ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void createCommentControls(Composite composite, int nColumns) {
        Link link = new Link(composite, 0);
        link.setText(NewWizardMessages.NewTypeWizardPage_addcomment_description);
        link.addSelectionListener((SelectionListener)new TypeFieldsAdapter());
        link.setLayoutData((Object)new GridData(4, 2, false, false, nColumns, 1));
        DialogField.createEmptySpace(composite);
        this.fAddCommentButton.doFillIntoGrid(composite, nColumns - 1);
    }

    protected void setFocus() {
        if (this.fTypeNameDialogField.isEnabled()) {
            this.fTypeNameDialogField.setFocus();
        } else {
            this.setFocusOnContainer();
        }
    }

    private void typePageLinkActivated() {
        IJavaProject project = this.getJavaProject();
        if (project != null) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project.getProject(), (String)"org.eclipse.jdt.ui.propertyPages.CodeTemplatePreferencePage", null, null);
            dialog.open();
        } else {
            String title = NewWizardMessages.NewTypeWizardPage_configure_templates_title;
            String message = NewWizardMessages.NewTypeWizardPage_configure_templates_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fPackageDialogField) {
            IPackageFragment pack = this.choosePackage();
            if (pack != null) {
                this.fPackageDialogField.setText(pack.getElementName());
            }
        } else if (field == this.fEnclosingTypeDialogField) {
            IType type2 = this.chooseEnclosingType();
            if (type2 != null) {
                this.fEnclosingTypeDialogField.setText(type2.getFullyQualifiedName('.'));
            }
        } else if (field == this.fSuperClassDialogField && (type = this.chooseSuperClass()) != null) {
            this.fSuperClassDialogField.setText(SuperInterfaceSelectionDialog.getNameWithTypeParameters(type));
        }
    }

    private void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField && index == 0) {
            this.chooseSuperInterfaces();
            List<InterfaceWrapper> interfaces = this.fSuperInterfacesDialogField.getElements();
            if (!interfaces.isEmpty()) {
                InterfaceWrapper element = interfaces.get(interfaces.size() - 1);
                this.fSuperInterfacesDialogField.editElement(element);
            }
        }
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fPackageDialogField) {
            this.fPackageStatus = this.packageChanged();
            this.updatePackageStatusLabel();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = PACKAGE;
        } else if (field == this.fEnclosingTypeDialogField) {
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSING;
        } else if (field == this.fEnclosingTypeSelection) {
            this.updateEnableState();
            boolean isEnclosedType = this.isEnclosingTypeSelected();
            if (!isEnclosedType) {
                if (this.fAccMdfButtons.isSelected(2) || this.fAccMdfButtons.isSelected(3)) {
                    this.fAccMdfButtons.setSelection(2, false);
                    this.fAccMdfButtons.setSelection(3, false);
                    this.fAccMdfButtons.setSelection(0, true);
                }
                if (this.fOtherMdfButtons.isSelected(2)) {
                    this.fOtherMdfButtons.setSelection(2, false);
                }
            }
            this.fAccMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fAccMdfButtons.enableSelectionButton(3, isEnclosedType);
            this.fOtherMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSINGSELECTION;
        } else if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = SUPER;
        } else if (field == this.fSuperInterfacesDialogField) {
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
            fieldName = INTERFACES;
        } else if (field == this.fOtherMdfButtons || field == this.fAccMdfButtons) {
            this.fModifierStatus = this.modifiersChanged();
            fieldName = MODIFIERS;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
        }
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public String getEnclosingTypeText() {
        return this.fEnclosingTypeDialogField.getText();
    }

    public IPackageFragment getPackageFragment() {
        if (!this.isEnclosingTypeSelected()) {
            return this.fCurrPackage;
        }
        if (this.fCurrEnclosingType != null) {
            return this.fCurrEnclosingType.getPackageFragment();
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        this.fCanModifyPackage = canBeModified;
        String str = pack == null ? "" : pack.getElementName();
        this.fPackageDialogField.setText(str);
        this.updateEnableState();
    }

    public IType getEnclosingType() {
        if (this.isEnclosingTypeSelected()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public void setEnclosingType(IType type, boolean canBeModified) {
        this.fCurrEnclosingType = type;
        this.fCanModifyEnclosingType = canBeModified;
        String str = type == null ? "" : type.getFullyQualifiedName('.');
        this.fEnclosingTypeDialogField.setText(str);
        this.updateEnableState();
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf += this.F_PUBLIC;
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf += this.F_PRIVATE;
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf += this.F_PROTECTED;
        }
        if (this.fOtherMdfButtons.isSelected(0)) {
            mdf += this.F_ABSTRACT;
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf += this.F_FINAL;
        }
        if (this.fOtherMdfButtons.isSelected(2)) {
            mdf += this.F_STATIC;
        }
        return mdf;
    }

    public void setModifiers(int modifiers, boolean canBeModified) {
        if (Flags.isPublic((int)modifiers)) {
            this.fAccMdfButtons.setSelection(0, true);
        } else if (Flags.isPrivate((int)modifiers)) {
            this.fAccMdfButtons.setSelection(2, true);
        } else if (Flags.isProtected((int)modifiers)) {
            this.fAccMdfButtons.setSelection(3, true);
        } else {
            this.fAccMdfButtons.setSelection(1, true);
        }
        if (Flags.isAbstract((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(0, true);
        }
        if (Flags.isFinal((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(1, true);
        }
        if (Flags.isStatic((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(2, true);
        }
        this.fAccMdfButtons.setEnabled(canBeModified);
        this.fOtherMdfButtons.setEnabled(canBeModified);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    public List<String> getSuperInterfaces() {
        List<InterfaceWrapper> interfaces = this.fSuperInterfacesDialogField.getElements();
        ArrayList<String> result = new ArrayList<String>(interfaces.size());
        for (InterfaceWrapper wrapper : interfaces) {
            result.add(wrapper.interfaceName);
        }
        return result;
    }

    public void setSuperInterfaces(List<String> interfacesNames, boolean canBeModified) {
        ArrayList<InterfaceWrapper> interfaces = new ArrayList<InterfaceWrapper>(interfacesNames.size());
        Iterator<String> iter = interfacesNames.iterator();
        while (iter.hasNext()) {
            interfaces.add(new InterfaceWrapper(iter.next()));
        }
        this.fSuperInterfacesDialogField.setElements(interfaces);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    public boolean addSuperInterface(String superInterface) {
        return this.fSuperInterfacesDialogField.addElement(new InterfaceWrapper(superInterface));
    }

    public void setAddComments(boolean doAddComments, boolean canBeModified) {
        this.fAddCommentButton.setSelection(doAddComments);
        this.fAddCommentButton.setEnabled(canBeModified);
    }

    public void enableCommentControl(boolean useAddCommentValue) {
        this.fUseAddCommentButtonValue = useAddCommentValue;
    }

    public boolean isAddComments() {
        if (this.fUseAddCommentButtonValue) {
            return this.fAddCommentButton.isSelected();
        }
        return StubUtility.doAddComments(this.getJavaProject());
    }

    public IResource getModifiedResource() {
        IType enclosing = this.getEnclosingType();
        if (enclosing != null) {
            return enclosing.getResource();
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            String cuName = this.getCompilationUnitName(this.getTypeNameWithoutParameters());
            return pack.getCompilationUnit(cuName).getResource();
        }
        return null;
    }

    @Override
    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!(this.fTypeKind != 4 && this.fTypeKind != 3 || status.matches(4))) {
            if (root != null && !JavaModelUtil.is50OrHigher(root.getJavaProject())) {
                return new StatusInfo(4, Messages.format(NewWizardMessages.NewTypeWizardPage_warning_NotJDKCompliant, BasicElementLabels.getJavaElementName(root.getJavaProject().getElementName())));
            }
            if (this.fTypeKind == 3) {
                try {
                    if (this.findType(root.getJavaProject(), "java.lang.Enum") == null) {
                        return new StatusInfo(2, NewWizardMessages.NewTypeWizardPage_warning_EnumClassNotFound);
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(root);
        if (root != null) {
            this.fEnclosingTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
        }
        return status;
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fPackageDialogField.enableButton(root != null);
        IJavaProject project = root != null ? root.getJavaProject() : null;
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = NewTypeWizardPage.validatePackageName(packName, project);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(Messages.format(NewWizardMessages.NewTypeWizardPage_warning_DiscouragedPackageName, val.getMessage()));
            }
        } else {
            status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_DefaultPackageDiscouraged);
        }
        if (project != null) {
            if (project.exists() && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = project.getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_ClashOutputLocation);
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            this.fCurrPackage = root.getPackageFragment(packName);
            IResource resource = this.fCurrPackage.getResource();
            if (resource != null) {
                if (resource.isVirtual()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_PackageIsVirtual);
                    return status;
                }
                if (!ResourcesPlugin.getWorkspace().validateFiltered(resource).isOK()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_PackageNameFiltered);
                    return status;
                }
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private void updatePackageStatusLabel() {
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.NewTypeWizardPage_default);
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    private void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fPackageDialogField.setEnabled(this.fCanModifyPackage && !enclosing);
        this.fEnclosingTypeDialogField.setEnabled(this.fCanModifyEnclosingType && enclosing);
        if (this.fTypeKind == 3 || this.fTypeKind == 4) {
            this.fOtherMdfButtons.enableSelectionButton(0, enclosing);
            this.fOtherMdfButtons.enableSelectionButton(1, enclosing);
        }
    }

    protected IStatus enclosingTypeChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fEnclosingTypeDialogField.enableButton(root != null);
        if (root == null) {
            status.setError("");
            return status;
        }
        String enclName = this.getEnclosingTypeText();
        if (enclName.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeEnterName);
            return status;
        }
        try {
            IType type = this.findType(root.getJavaProject(), enclName);
            if (type == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
                return status;
            }
            if (type.getCompilationUnit() == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotInCU);
                return status;
            }
            if (!JavaModelUtil.isEditable(type.getCompilationUnit())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotEditable);
                return status;
            }
            this.fCurrEnclosingType = type;
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)type);
            if (!enclosingRoot.equals(root)) {
                status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_EnclosingNotInSourceFolder);
            }
            return status;
        }
        catch (JavaModelException e) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
            JavaPlugin.log(e);
            return status;
        }
    }

    private IType findType(IJavaProject project, String typeName) throws JavaModelException {
        if (project.exists()) {
            return project.findType(typeName);
        }
        return null;
    }

    private String getTypeNameWithoutParameters() {
        return NewTypeWizardPage.getTypeNameWithoutParameters(this.getTypeName());
    }

    private static String getTypeNameWithoutParameters(String typeNameWithParameters) {
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }

    protected String getCompilationUnitName(String typeName) {
        return String.valueOf(typeName) + ".java";
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrType = null;
        String typeNameWithParameters = this.getTypeName();
        if (typeNameWithParameters.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
            return status;
        }
        String typeName = this.getTypeNameWithoutParameters();
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
            return status;
        }
        IJavaProject project = this.getJavaProject();
        IStatus val = NewTypeWizardPage.validateJavaTypeName(typeName, project);
        if (val.getSeverity() == 4) {
            status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(Messages.format(NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, val.getMessage()));
        }
        if (!this.isEnclosingTypeSelected()) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null) {
                ICompilationUnit cu = pack.getCompilationUnit(this.getCompilationUnitName(typeName));
                this.fCurrType = cu.getType(typeName);
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
                if (!ResourcesPlugin.getWorkspace().validateFiltered(resource).isOK()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameFiltered);
                    return status;
                }
                URI location = resource.getLocationURI();
                if (location != null) {
                    try {
                        IFileStore store = EFS.getStore((URI)location);
                        if (store.fetchInfo().exists()) {
                            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExistsDifferentCase);
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_uri_location_unkown, BasicElementLabels.getURLPart(Resources.getLocationString(resource))));
                    }
                }
            }
        } else {
            IType type = this.getEnclosingType();
            if (type != null) {
                this.fCurrType = type.getType(typeName);
                if (this.fCurrType.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
            }
        }
        if (!typeNameWithParameters.equals(typeName) && project != null) {
            if (!JavaModelUtil.is50OrHigher(project)) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeParameters);
                return status;
            }
            String typeDeclaration = "class " + typeNameWithParameters + " {}";
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setSource(typeDeclaration.toCharArray());
            parser.setProject(project);
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
            IProblem[] problems = compilationUnit.getProblems();
            if (problems.length > 0) {
                status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, problems[0].getMessage()));
                return status;
            }
        }
        return status;
    }

    protected IStatus superClassChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperClassDialogField.enableButton(root != null);
        this.fSuperClassStubTypeContext = null;
        String sclassName = this.getSuperClass();
        if (sclassName.length() == 0) {
            return status;
        }
        if (root != null) {
            Type type = TypeContextChecker.parseSuperClass(sclassName);
            if (type == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                return status;
            }
            if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher(root.getJavaProject())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_SuperClassNotParameterized);
                return status;
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private StubTypeContext getSuperClassStubTypeContext() {
        if (this.fSuperClassStubTypeContext == null) {
            String typeName = this.fCurrType != null ? this.getTypeName() : "$$__$$";
            this.fSuperClassStubTypeContext = TypeContextChecker.createSuperClassStubTypeContext(typeName, this.getEnclosingType(), this.getPackageFragment());
        }
        return this.fSuperClassStubTypeContext;
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperInterfacesDialogField.enableButton(0, root != null);
        if (root != null) {
            List<InterfaceWrapper> elements = this.fSuperInterfacesDialogField.getElements();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                String intfname = elements.get((int)i).interfaceName;
                Type type = TypeContextChecker.parseSuperInterface(intfname);
                if (type == null) {
                    status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperInterfaceName, BasicElementLabels.getJavaElementName(intfname)));
                    return status;
                }
                if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher(root.getJavaProject())) {
                    status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_SuperInterfaceNotParameterized, BasicElementLabels.getJavaElementName(intfname)));
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    private StubTypeContext getSuperInterfacesStubTypeContext() {
        if (this.fSuperInterfaceStubTypeContext == null) {
            String typeName = this.fCurrType != null ? this.getTypeName() : "$$__$$";
            this.fSuperInterfaceStubTypeContext = TypeContextChecker.createSuperInterfaceStubTypeContext(typeName, this.getEnclosingType(), this.getPackageFragment());
        }
        return this.fSuperInterfaceStubTypeContext;
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        int modifiers = this.getModifiers();
        if (Flags.isFinal((int)modifiers) && Flags.isAbstract((int)modifiers)) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_ModifiersFinalAndAbstract);
        }
        return status;
    }

    protected IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 0);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChooseEnclosingTypeDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChooseEnclosingTypeDialog_description);
        dialog.setInitialPattern(Signature.getSimpleName((String)this.getEnclosingTypeText()));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseSuperClass() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_message);
        dialog.setInitialPattern(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void chooseSuperInterfaces() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return;
        }
        SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this, project);
        dialog.setTitle(this.getInterfaceDialogTitle());
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_message);
        dialog.open();
    }

    private String getInterfaceDialogTitle() {
        if (this.fTypeKind == 2) {
            return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_interface_title;
        }
        return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_class_title;
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewTypeWizardPage_operationdesc, 8);
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment pack = this.getPackageFragment();
        if (pack == null) {
            pack = root.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            pack = root.createPackageFragment(packName, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
        ICompilationUnit connectedCU = null;
        try {
            String fileComment;
            IType createdType;
            ImportsManager imports;
            Set<String> existingImports;
            boolean needsSave;
            ICompilationUnit parentCU;
            String typeName = this.getTypeNameWithoutParameters();
            boolean isInnerClass = this.isEnclosingTypeSelected();
            int indent = 0;
            String lineDelimiter = null;
            if (!isInnerClass) {
                lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getJavaProject());
                String cuName = this.getCompilationUnitName(typeName);
                parentCU = pack.createCompilationUnit(cuName, "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                needsSave = true;
                parentCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                connectedCU = parentCU;
                IBuffer buffer = parentCU.getBuffer();
                String simpleTypeStub = this.constructSimpleTypeStub();
                String cuContent = this.constructCUContent(parentCU, simpleTypeStub, lineDelimiter);
                buffer.setContents(cuContent);
                CompilationUnit astRoot = this.createASTForImports(parentCU);
                existingImports = this.getExistingImports(astRoot);
                imports = new ImportsManager(astRoot);
                imports.addImport(JavaModelUtil.concatenateName(pack.getElementName(), typeName));
                String typeContent = this.constructTypeStub(parentCU, imports, lineDelimiter);
                int index = cuContent.lastIndexOf(simpleTypeStub);
                if (index == -1) {
                    AbstractTypeDeclaration typeNode = (AbstractTypeDeclaration)astRoot.types().get(0);
                    int start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                    int end = typeNode.getStartPosition() + typeNode.getLength();
                    buffer.replace(start, end - start, typeContent);
                } else {
                    buffer.replace(index, simpleTypeStub.length(), typeContent);
                }
                createdType = parentCU.getType(typeName);
            } else {
                IType enclosingType = this.getEnclosingType();
                parentCU = enclosingType.getCompilationUnit();
                needsSave = !parentCU.isWorkingCopy();
                parentCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                connectedCU = parentCU;
                CompilationUnit astRoot = this.createASTForImports(parentCU);
                imports = new ImportsManager(astRoot);
                existingImports = this.getExistingImports(astRoot);
                IType[] topLevelTypes = parentCU.getTypes();
                int i = 0;
                while (i < topLevelTypes.length) {
                    imports.addImport(topLevelTypes[i].getFullyQualifiedName('.'));
                    ++i;
                }
                lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)enclosingType);
                StringBuffer content = new StringBuffer();
                String comment = this.getTypeComment(parentCU, lineDelimiter);
                if (comment != null) {
                    content.append(comment);
                    content.append(lineDelimiter);
                }
                content.append(this.constructTypeStub(parentCU, imports, lineDelimiter));
                IJavaElement sibling = null;
                if (enclosingType.isEnum()) {
                    IField[] fields = enclosingType.getFields();
                    if (fields.length > 0) {
                        int i2 = 0;
                        int max = fields.length;
                        while (i2 < max) {
                            if (!fields[i2].isEnumConstant()) {
                                sibling = fields[i2];
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    IJavaElement[] elems = enclosingType.getChildren();
                    sibling = elems.length > 0 ? elems[0] : null;
                }
                createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                indent = StubUtility.getIndentUsed((IJavaElement)enclosingType) + 1;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ICompilationUnit cu = createdType.getCompilationUnit();
            imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JavaModelUtil.reconcile(cu);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            CompilationUnit astRoot = this.createASTForImports(imports.getCompilationUnit());
            imports = new ImportsManager(astRoot);
            this.createTypeMembers(createdType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.removeUnusedImports(cu, existingImports, false);
            JavaModelUtil.reconcile(cu);
            ISourceRange range = createdType.getSourceRange();
            IBuffer buf = cu.getBuffer();
            String originalContent = buf.getText(range.getOffset(), range.getLength());
            String formattedContent = CodeFormatterUtil.format(4, originalContent, indent, lineDelimiter, pack.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces(formattedContent);
            buf.replace(range.getOffset(), range.getLength(), formattedContent);
            if (!isInnerClass && (fileComment = this.getFileComment(cu)) != null && fileComment.length() > 0) {
                buf.replace(0, 0, String.valueOf(fileComment) + lineDelimiter);
            }
            this.fCreatedType = createdType;
            if (needsSave) {
                cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
        }
        finally {
            if (connectedCU != null) {
                connectedCU.discardWorkingCopy();
            }
            monitor.done();
        }
    }

    private CompilationUnit createASTForImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        parser.setFocalPosition(0);
        return (CompilationUnit)parser.createAST(null);
    }

    private Set<String> getExistingImports(CompilationUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)imports.get(i)));
            ++i;
        }
        return res;
    }

    private void removeUnusedImports(ICompilationUnit cu, Set<String> existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)importsDecls.get(importsDecls.size() - 1));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String fileComment = this.getFileComment(cu, lineDelimiter);
        String typeComment = this.getTypeComment(cu, lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent(cu, fileComment, typeComment, typeContent, lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private void writeSuperClass(StringBuffer buf, ImportsManager imports) {
        String superclass = this.getSuperClass();
        if (this.fTypeKind == 1 && superclass.length() > 0 && !"java.lang.Object".equals(superclass)) {
            buf.append(" extends ");
            ITypeBinding binding = null;
            if (this.fCurrType != null) {
                binding = TypeContextChecker.resolveSuperClass(superclass, this.fCurrType, this.getSuperClassStubTypeContext());
            }
            if (binding != null) {
                buf.append(imports.addImport(binding));
            } else {
                buf.append(imports.addImport(superclass));
            }
        }
    }

    private void writeSuperInterfaces(StringBuffer buf, ImportsManager imports) {
        List<String> interfaces = this.getSuperInterfaces();
        int last = interfaces.size() - 1;
        if (last >= 0) {
            if (this.fTypeKind != 2) {
                buf.append(" implements ");
            } else {
                buf.append(" extends ");
            }
            String[] intfs = interfaces.toArray(new String[interfaces.size()]);
            ITypeBinding[] bindings = this.fCurrType != null ? TypeContextChecker.resolveSuperInterfaces(intfs, this.fCurrType, this.getSuperInterfacesStubTypeContext()) : new ITypeBinding[intfs.length];
            int i = 0;
            while (i <= last) {
                ITypeBinding binding = bindings[i];
                if (binding != null) {
                    buf.append(imports.addImport(binding));
                } else {
                    buf.append(imports.addImport(intfs[i]));
                }
                if (i < last) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    private String constructSimpleTypeStub() {
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(this.getTypeName());
        buf.append("{ }");
        return buf.toString();
    }

    private String constructTypeStub(ICompilationUnit parentCU, ImportsManager imports, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        String type = "";
        String templateID = "";
        switch (this.fTypeKind) {
            case 1: {
                type = "class ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
                break;
            }
            case 2: {
                type = "interface ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.interfacebody";
                break;
            }
            case 3: {
                type = "enum ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.enumbody";
                break;
            }
            case 4: {
                type = "@interface ";
                templateID = "org.eclipse.jdt.ui.text.codetemplates.annotationbody";
            }
        }
        buf.append(type);
        buf.append(this.getTypeName());
        this.writeSuperClass(buf, imports);
        this.writeSuperInterfaces(buf, imports);
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody(templateID, parentCU, this.getTypeName(), lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    protected void createTypeMembers(IType newType, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
    }

    protected String getFileComment(ICompilationUnit parentCU) {
        return null;
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.isAddComments()) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) {
        if (this.isAddComments()) {
            try {
                StringBuffer typeName = new StringBuffer();
                if (this.isEnclosingTypeSelected()) {
                    typeName.append(this.getEnclosingType().getTypeQualifiedName('.')).append('.');
                }
                typeName.append(this.getTypeNameWithoutParameters());
                String[] typeParamNames = new String[]{};
                String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), typeParamNames, lineDelimiter);
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU) {
        if (StubUtility.doAddComments(parentCU.getJavaProject())) {
            return this.getTypeComment(parentCU, StubUtility.getLineDelimiterUsed((IJavaElement)parentCU));
        }
        return null;
    }

    protected String getTemplate(String name, ICompilationUnit parentCU) {
        return this.getTemplate(name, parentCU, 0);
    }

    protected String getTemplate(String name, ICompilationUnit parentCU, int pos) {
        try {
            Template template = JavaPlugin.getDefault().getTemplateStore().findTemplate(name);
            if (template != null) {
                return JavaContext.evaluateTemplate(template, parentCU, pos);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (TemplateException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    protected IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        ICompilationUnit cu = type.getCompilationUnit();
        JavaModelUtil.reconcile(cu);
        IMethod[] typeMethods = type.getMethods();
        HashSet<String> handleIds = new HashSet<String>(typeMethods.length);
        int index = 0;
        while (index < typeMethods.length) {
            handleIds.add(typeMethods[index].getHandleIdentifier());
            ++index;
        }
        ArrayList<IMethod> newMethods = new ArrayList<IMethod>();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITypeBinding binding = ASTNodes.getTypeBinding(unit, type);
        if (binding != null) {
            Object operation;
            if (doUnimplementedMethods) {
                operation = new AddUnimplementedMethodsOperation(unit, binding, null, -1, false, true, false);
                ((AddUnimplementedMethodsOperation)operation).setCreateComments(this.isAddComments());
                ((AddUnimplementedMethodsOperation)operation).run(monitor);
                this.createImports(imports, ((AddUnimplementedMethodsOperation)operation).getCreatedImports());
            }
            if (doConstructors) {
                operation = new AddUnimplementedConstructorsOperation(unit, binding, null, -1, false, true, false);
                ((AddUnimplementedConstructorsOperation)operation).setOmitSuper(true);
                ((AddUnimplementedConstructorsOperation)operation).setCreateComments(this.isAddComments());
                ((AddUnimplementedConstructorsOperation)operation).run(monitor);
                this.createImports(imports, ((AddUnimplementedConstructorsOperation)operation).getCreatedImports());
            }
        }
        JavaModelUtil.reconcile(cu);
        typeMethods = type.getMethods();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            if (!handleIds.contains(typeMethods[index2].getHandleIdentifier())) {
                newMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        IMethod[] methods = new IMethod[newMethods.size()];
        newMethods.toArray(methods);
        return methods;
    }

    private void createImports(ImportsManager imports, String[] createdImports) {
        int index = 0;
        while (index < createdImports.length) {
            imports.addImport(createdImports[index]);
            ++index;
        }
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    NewTypeWizardPage.this.createType(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public static class ImportsManager {
        private final CompilationUnit fAstRoot;
        private final ImportRewrite fImportsRewrite;

        ImportsManager(CompilationUnit astRoot) {
            this.fAstRoot = astRoot;
            this.fImportsRewrite = StubUtility.createImportRewrite(astRoot, true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            return this.fImportsRewrite.addImport(qualifiedTypeName);
        }

        public String addImport(String qualifiedTypeName, int insertPosition) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fAstRoot, insertPosition, this.fImportsRewrite);
            return this.fImportsRewrite.addImport(qualifiedTypeName, (ImportRewrite.ImportRewriteContext)context);
        }

        public String addImport(ITypeBinding typeBinding) {
            return this.fImportsRewrite.addImport(typeBinding);
        }

        public String addImport(ITypeBinding typeBinding, int insertPosition) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fAstRoot, insertPosition, this.fImportsRewrite);
            return this.fImportsRewrite.addImport(typeBinding, (ImportRewrite.ImportRewriteContext)context);
        }

        public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
            return this.fImportsRewrite.addStaticImport(declaringTypeName, simpleName, isField);
        }

        void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
            TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
            JavaModelUtil.applyEdit(this.fImportsRewrite.getCompilationUnit(), edit, needsSave, null);
        }

        void removeImport(String qualifiedName) {
            this.fImportsRewrite.removeImport(qualifiedName);
        }

        void removeStaticImport(String qualifiedName) {
            this.fImportsRewrite.removeStaticImport(qualifiedName);
        }
    }

    private static class InterfaceWrapper {
        public String interfaceName;

        public InterfaceWrapper(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public int hashCode() {
            return this.interfaceName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((InterfaceWrapper)obj).interfaceName.equals(this.interfaceName);
        }
    }

    private static class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get("org.eclipse.jdt.ui.int_obj.gif");

        public String getText(Object element) {
            return BasicElementLabels.getJavaElementName(((InterfaceWrapper)element).interfaceName);
        }

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter<InterfaceWrapper>,
    SelectionListener {
        private TypeFieldsAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewTypeWizardPage.this.typePageChangeControlPressed(field);
        }

        @Override
        public void customButtonPressed(ListDialogField<InterfaceWrapper> field, int index) {
            NewTypeWizardPage.this.typePageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField<InterfaceWrapper> field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        @Override
        public void doubleClicked(ListDialogField<InterfaceWrapper> field) {
        }

        public void widgetSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated();
        }
    }
}

