/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int settings;
        boolean success;
        byte[] buffer = Converter.wcsToMbcs(null, this.title, true);
        int handle = 0;
        handle = OS.GTK_VERSION >= OS.VERSION(3, 4, 0) ? OS.gtk_color_chooser_dialog_new(buffer, this.parent.topHandle()) : OS.gtk_color_selection_dialog_new(buffer);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int colorsel = 0;
        GdkColor color = new GdkColor();
        GdkRGBA rgba = new GdkRGBA();
        if (OS.GTK_VERSION <= OS.VERSION(3, 4, 0)) {
            if (this.parent != null) {
                int shellHandle = this.parent.topHandle();
                OS.gtk_window_set_transient_for(handle, shellHandle);
                int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
                if (pixbufs != 0) {
                    OS.gtk_window_set_icon_list(handle, pixbufs);
                    OS.g_list_free(pixbufs);
                }
            }
            int group = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(group, handle);
            OS.gtk_window_set_modal(handle, true);
            if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                colorsel = OS.gtk_color_selection_dialog_get_color_selection(handle);
            } else {
                GtkColorSelectionDialog dialog = new GtkColorSelectionDialog();
                OS.memmove(dialog, handle);
                colorsel = dialog.colorsel;
            }
            if (this.rgb != null) {
                color.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
                color.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
                color.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
                OS.gtk_color_selection_set_current_color(colorsel, color);
            }
            OS.gtk_color_selection_set_has_palette(colorsel, true);
        } else {
            if (this.rgb != null) {
                rgba.red = (double)this.rgb.red / 255.0;
                rgba.green = (double)this.rgb.green / 255.0;
                rgba.blue = (double)this.rgb.blue / 255.0;
            }
            OS.gtk_color_chooser_set_use_alpha(handle, false);
            OS.gtk_color_chooser_set_rgba(handle, rgba);
        }
        if (this.rgbs != null) {
            int colors = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
            int i = 0;
            while (i < this.rgbs.length) {
                RGB rgb = this.rgbs[i];
                if (rgb != null) {
                    color.red = (short)(rgb.red & 0xFF | (rgb.red & 0xFF) << 8);
                    color.green = (short)(rgb.green & 0xFF | (rgb.green & 0xFF) << 8);
                    color.blue = (short)(rgb.blue & 0xFF | (rgb.blue & 0xFF) << 8);
                    OS.memmove(colors + i * GdkColor.sizeof, color, GdkColor.sizeof);
                }
                ++i;
            }
            int strPtr = OS.gtk_color_selection_palette_to_string(colors, this.rgbs.length);
            int length = OS.strlen(strPtr);
            buffer = new byte[length];
            OS.memmove(buffer, strPtr, length);
            String paletteString = new String(Converter.mbcsToWcs(null, buffer));
            buffer = Converter.wcsToMbcs(null, paletteString, true);
            OS.g_free(colors);
            int settings2 = OS.gtk_settings_get_default();
            if (settings2 != 0) {
                OS.gtk_settings_set_string_property(settings2, OS.gtk_color_palette, buffer, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
            }
        }
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        int hookId = 0;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0);
        }
        display.sendPreExternalEventDispatchEvent();
        int response = OS.gtk_dialog_run(handle);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (OS.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = response == -5;
        if (success) {
            int red = 0;
            int green = 0;
            int blue = 0;
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                OS.gtk_color_chooser_get_rgba(handle, rgba);
                red = (int)(rgba.red * 255.0);
                green = (int)(rgba.green * 255.0);
                blue = (int)(rgba.blue * 255.0);
            } else {
                OS.gtk_color_selection_get_current_color(colorsel, color);
                red = color.red >> 8 & 0xFF;
                green = color.green >> 8 & 0xFF;
                blue = color.blue >> 8 & 0xFF;
            }
            this.rgb = new RGB(red, green, blue);
        }
        if ((settings = OS.gtk_settings_get_default()) != 0) {
            int[] ptr = new int[1];
            OS.g_object_get(settings, OS.gtk_color_palette, ptr, 0);
            if (ptr[0] != 0) {
                int length = OS.strlen(ptr[0]);
                buffer = new byte[length];
                OS.memmove(buffer, ptr[0], length);
                OS.g_free(ptr[0]);
                String[] gdkColorStrings = null;
                if (length > 0) {
                    String gtk_color_palette = new String(Converter.mbcsToWcs(null, buffer));
                    gdkColorStrings = ColorDialog.splitString(gtk_color_palette, ':');
                    length = gdkColorStrings.length;
                }
                this.rgbs = new RGB[length];
                int i = 0;
                while (i < length) {
                    String colorString = gdkColorStrings[i];
                    buffer = Converter.wcsToMbcs(null, colorString, true);
                    OS.gdk_color_parse(buffer, color);
                    int red = color.red >> 8 & 0xFF;
                    int green = color.green >> 8 & 0xFF;
                    int blue = color.blue >> 8 & 0xFF;
                    this.rgbs[i] = new RGB(red, green, blue);
                    ++i;
                }
            }
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        if (!success) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public void setRGBs(RGB[] rgbs) {
        this.rgbs = rgbs;
    }

    static String[] splitString(String text, char ch) {
        String[] substrings = new String[1];
        int start = 0;
        int pos = 0;
        while (pos != -1) {
            pos = text.indexOf(ch, start);
            if (pos == -1) {
                substrings[substrings.length - 1] = text.substring(start);
                continue;
            }
            substrings[substrings.length - 1] = text.substring(start, pos);
            start = pos + 1;
            String[] newSubstrings = new String[substrings.length + 1];
            System.arraycopy(substrings, 0, newSubstrings, 0, substrings.length);
            substrings = newSubstrings;
        }
        return substrings;
    }
}

