/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    int textEntryHandle;
    int containerHandle;
    int calendarHandle;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    String dateTimeString;
    boolean firstTime = true;
    Color fg;
    Color bg;
    boolean hasFocus;
    boolean monthChanged;
    boolean calendarDisplayed;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Point prefferedSize = null;
    Listener mouseEventListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    static final int SPACE_FOR_CURSOR = 1;
    static final int GTK2_MANUAL_BORDER_PADDING = 2;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if (this.isDate() || this.isTime()) {
            this.createText();
        }
        if (this.isCalendar()) {
            OS.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
        }
        if (this.isDateWithDropDownButton()) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.setDropDownButtonSize();
                }
            });
        }
        this.initAccessible();
        if (this.isDateWithDropDownButton()) {
            Point size = this.computeSize(-1, -1);
            this.setBounds(0, 0, size.x, size.y);
        }
    }

    void createText() {
        this.calendar = Calendar.getInstance();
        this.formatSymbols = new DateFormatSymbols();
        if (this.isDate()) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
        } else if (this.isTime()) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
        }
        this.dateTimeString = this.getFormattedString(this.style);
        if (this.dateTimeString != null) {
            this.setText(this.dateTimeString);
        }
    }

    static int checkStyle(int style) {
        if (!OS.GTK3 && DateTime.isDateWithDropDownButton(style &= 0xFFFFFCFF)) {
            style &= 0xFBFFFFFF;
        }
        if (((style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (!changed && (this.isDate() || this.isTime()) && OS.GTK3 && this.prefferedSize != null) {
            width = wHint != -1 ? wHint : this.prefferedSize.x;
            height = hHint != -1 ? hHint : this.prefferedSize.y;
            return new Point(width, height);
        }
        if (wHint == -1 || hHint == -1) {
            if (this.isCalendar()) {
                Point size = this.computeNativeSize(this.containerHandle, wHint, hHint, changed);
                width = size.x;
                height = size.y;
            } else {
                Point textSize = this.computeNativeSize(this.textEntryHandle, wHint, hHint, changed);
                Rectangle trim = this.computeTrim(0, 0, textSize.x, textSize.y);
                if (this.isDateWithDropDownButton()) {
                    Point buttonSize = this.down.computeSize(-1, -1, changed);
                    width = trim.width + buttonSize.x;
                    height = Math.max(trim.height, buttonSize.y);
                } else if (this.isDate() || this.isTime()) {
                    if (OS.GTK3) {
                        width = trim.width;
                        height = trim.height;
                    } else {
                        width = textSize.x;
                        height = textSize.y;
                    }
                }
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int borderWidth = this.getBorderWidth();
        if (this.prefferedSize == null && this.isDateWithDropDownButton() && OS.GTK3) {
            this.prefferedSize = new Point(width + 2 * borderWidth, height + 2 * borderWidth);
            return this.prefferedSize;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        if (this.isCalendar()) {
            return super.computeTrim(x, y, width, height);
        }
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int xborder = 0;
        int yborder = 0;
        if (OS.GTK3) {
            GtkBorder tmp = new GtkBorder();
            int context = OS.gtk_widget_get_style_context(this.textEntryHandle);
            OS.gtk_style_context_get_padding(context, 0, tmp);
            trim.x -= tmp.left;
            trim.y -= tmp.top;
            trim.width += tmp.left + tmp.right;
            trim.height += tmp.top + tmp.bottom;
            if ((this.style & 0x800) != 0) {
                OS.gtk_style_context_get_border(context, 0, tmp);
                trim.x -= tmp.left;
                trim.y -= tmp.top;
                trim.width += tmp.left + tmp.right;
                trim.height += tmp.top + tmp.bottom;
            }
        } else {
            if ((this.style & 0x800) != 0) {
                Point thickness = this.getThickness(this.textEntryHandle);
                xborder += thickness.x;
                yborder += thickness.y;
            }
            GtkBorder innerBorder = Display.getEntryInnerBorder(this.textEntryHandle);
            trim.x -= innerBorder.left;
            trim.y -= innerBorder.top;
            trim.width += innerBorder.left + innerBorder.right;
            trim.height += innerBorder.top + innerBorder.bottom;
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        ++trim.width;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    void createHandle(int index) {
        this.createHandle();
    }

    void createHandle() {
        if (this.isCalendar()) {
            this.state |= 8;
            this.createHandleForFixed();
            this.createHandleForCalendar();
        } else {
            this.createHandleForFixed();
            if (this.isDateWithDropDownButton()) {
                this.createHandleForDateWithDropDown();
            } else {
                this.createHandleForDateTime();
            }
            OS.gtk_editable_set_editable(this.textEntryHandle, (this.style & 8) == 0);
            OS.gtk_entry_set_has_frame(this.textEntryHandle, (this.style & 0x800) != 0);
        }
    }

    private void createHandleForFixed() {
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
    }

    private void createHandleForCalendar() {
        this.calendarHandle = OS.gtk_calendar_new();
        if (this.calendarHandle == 0) {
            this.error(2);
        }
        this.handle = this.calendarHandle;
        this.containerHandle = this.calendarHandle;
        OS.gtk_container_add(this.fixedHandle, this.calendarHandle);
        OS.gtk_calendar_set_display_options(this.calendarHandle, 3);
        OS.gtk_widget_show(this.calendarHandle);
    }

    private void createHandleForDateWithDropDown() {
        this.containerHandle = this.gtk_box_new(0, false, 0);
        if (this.containerHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.containerHandle);
        this.textEntryHandle = OS.gtk_entry_new();
        if (this.textEntryHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.containerHandle, this.textEntryHandle);
        OS.gtk_widget_show(this.containerHandle);
        OS.gtk_widget_show(this.textEntryHandle);
        this.handle = this.containerHandle;
        if (this.handle == 0) {
            this.error(2);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    private void createHandleForDateTime() {
        int adjusment = OS.gtk_adjustment_new(0.0, -9999.0, 9999.0, 1.0, 0.0, 0.0);
        this.textEntryHandle = OS.gtk_spin_button_new(adjusment, 1.0, 0);
        if (this.textEntryHandle == 0) {
            this.error(2);
        }
        this.handle = this.textEntryHandle;
        this.containerHandle = this.textEntryHandle;
        OS.gtk_spin_button_set_numeric(this.textEntryHandle, false);
        OS.gtk_container_add(this.fixedHandle, this.textEntryHandle);
        OS.gtk_spin_button_set_wrap(this.textEntryHandle, (this.style & 0x40) != 0);
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        this.gtk_widget_set_can_focus(this.down.handle, false);
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DateTime.this.popupCalendar.calendarDisplayed = !DateTime.this.isDropped();
                DateTime.this.setFocus();
                DateTime.this.dropDownCalendar(!DateTime.this.isDropped());
            }
        });
        this.popupListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == DateTime.this.popupShell) {
                    DateTime.this.popupShellEvent(event);
                    return;
                }
                if (event.widget == DateTime.this.popupCalendar) {
                    DateTime.this.popupCalendarEvent(event);
                    return;
                }
                if (event.widget == DateTime.this) {
                    DateTime.this.onDispose(event);
                    return;
                }
                if (event.widget == DateTime.this.getShell()) {
                    DateTime.this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (DateTime.this.isDisposed()) {
                                return;
                            }
                            DateTime.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.popupFilter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == DateTime.this.getShell()) {
                    DateTime.this.handleFocus(16);
                }
            }
        };
    }

    void createPopupShell(int year, int month, int day) {
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.mouseEventListener = new Listener(){

            public void handleEvent(Event event) {
                Control c;
                if (event.widget instanceof Control && (c = (Control)event.widget) != DateTime.this.down && c.getShell() != DateTime.this.popupShell) {
                    DateTime.this.dropDownCalendar(false);
                }
            }
        };
        int[] listeners = new int[]{21, 4, 9};
        int i = 0;
        while (i < listeners.length) {
            this.popupShell.addListener(listeners[i], this.popupListener);
            ++i;
        }
        listeners = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        i = 0;
        while (i < listeners.length) {
            this.popupCalendar.addListener(listeners[i], this.popupListener);
            ++i;
        }
        this.addListener(12, this.popupListener);
        if (year != -1) {
            this.popupCalendar.setDate(year, month, day);
        }
    }

    void setFontDescription(int font) {
        if (this.isDateWithDropDownButton()) {
            this.prefferedSize = null;
            this.setFontDescription(this.textEntryHandle, font);
        }
        super.setFontDescription(font);
    }

    boolean checkSubwindow() {
        return false;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if (this.isCalendar()) {
            this.getDate();
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.popupCalendar = null;
        this.down = null;
        this.dateTimeString = null;
    }

    void dropDownCalendar(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.hideDropDownCalendar();
            return;
        }
        this.setCurrentDate();
        if (this.getShell() != this.popupShell.getParent()) {
            this.recreateCalendar();
        }
        Point containerBounds = this.getSize();
        Point calendarSize = this.popupCalendar.computeSize(-1, -1, false);
        this.popupCalendar.setBounds(1, 1, Math.max(containerBounds.x - 2, calendarSize.x), calendarSize.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        this.focusDayOnPopupCalendar();
        Display display = this.getDisplay();
        Rectangle coordsRelativeToScreen = display.map((Control)this.getParent(), null, this.getBounds());
        Rectangle displayRect = this.getMonitor().getClientArea();
        this.showPopupShell(containerBounds, calendarSize, coordsRelativeToScreen, displayRect);
        display.addFilter(3, this.mouseEventListener);
    }

    private void showPopupShell(Point containerBounds, Point calendarSize, Rectangle coordsRelativeToScreen, Rectangle displayRect) {
        int width = Math.max(containerBounds.x, calendarSize.x + 2);
        int height = calendarSize.y + 2;
        int y = this.calculateCalendarYpos(containerBounds, coordsRelativeToScreen, height, displayRect);
        int x = this.calculateCalendarXpos(calendarSize, coordsRelativeToScreen, displayRect, width);
        this.popupShell.setBounds(x, y, width, height);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
    }

    private int calculateCalendarYpos(Point containerBounds, Rectangle coordsRelativeToScreen, int height, Rectangle displayRect) {
        int dateEntryHeight = this.computeNativeSize((int)this.containerHandle, (int)-1, (int)-1, (boolean)false).y;
        int y = coordsRelativeToScreen.y + containerBounds.y / 2 + dateEntryHeight / 2;
        if (y + height > displayRect.y + displayRect.height) {
            y -= height + dateEntryHeight;
        }
        return y;
    }

    private int calculateCalendarXpos(Point calendarSize, Rectangle coordsRelativeToScreen, Rectangle displayRect, int width) {
        Integer x = coordsRelativeToScreen.x;
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - calendarSize.x;
        }
        return x;
    }

    private void focusDayOnPopupCalendar() {
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2);
        if (this.savedYear == currentYear && this.savedMonth == currentMonth) {
            int currentDay = Calendar.getInstance().get(5);
            OS.gtk_calendar_mark_day(this.popupCalendar.handle, currentDay);
        }
    }

    private void setCurrentDate() {
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
    }

    private void recreateCalendar() {
        int year = this.popupCalendar.getYear();
        int month = this.popupCalendar.getMonth();
        int day = this.popupCalendar.getDay();
        this.popupCalendar.removeListener(12, this.popupListener);
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
        this.createPopupShell(year, month, day);
    }

    private void hideDropDownCalendar() {
        this.popupShell.setVisible(false);
        OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
        this.display.removeFilter(3, this.mouseEventListener);
    }

    String formattedStringValue(int fieldName, int value, boolean adjust) {
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            return ampm[value];
        }
        if (adjust) {
            if (fieldName == 10 && value == 0) {
                return String.valueOf(12);
            }
            if (fieldName == 2) {
                return String.valueOf(value + 1);
            }
        }
        return String.valueOf(value);
    }

    GdkColor getBackgroundColor() {
        if (this.isCalendar()) {
            return this.getBaseColor();
        }
        return super.getBackgroundColor();
    }

    String getComputeSizeString(int style) {
        if ((style & 0x20) != 0) {
            return (style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int fieldName) {
        int i = 0;
        while (i < this.fieldCount) {
            if (this.fieldNames[i] == fieldName) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getFormattedString(int style) {
        String formattedSting = null;
        if (this.isTime()) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            int a = this.calendar.get(9);
            formattedSting = (h < 10 ? "0" : "") + h + ":";
            formattedSting = (style & 0x8000) != 0 ? String.valueOf(formattedSting) + (m < 10 ? "0" : "") + m + " " + ampm[a] : String.valueOf(formattedSting) + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s + " " + ampm[a];
        } else if (this.isDate()) {
            int y = this.calendar.get(1);
            int m = this.calendar.get(2) + 1;
            int d = this.calendar.get(5);
            formattedSting = (m < 10 ? "0" : "") + m + "/";
            formattedSting = (style & 0x8000) != 0 ? String.valueOf(formattedSting) + y : String.valueOf(formattedSting) + (d < 10 ? "0" : "") + d + "/" + y;
        }
        return formattedSting;
    }

    void getDate() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.calendarHandle, y, m, d);
        this.year = y[0];
        this.month = m[0];
        this.day = d[0];
    }

    public int getDay() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    String getNameText() {
        if (this.isTime()) {
            return String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds();
        }
        return String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if (this.isCalendar()) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        StringBuffer result = new StringBuffer();
        if (this.isTime()) {
            int h = this.calendar.get(10);
            if (h == 0) {
                h = 12;
            }
            result.append(h);
            int m = this.calendar.get(12);
            result.append(":" + (m < 10 ? "0" : "") + m);
            if ((this.style & 0x8000) == 0) {
                int s = this.calendar.get(13);
                result.append(":" + (s < 10 ? "0" : "") + s);
            }
            result.append(" " + this.formatSymbols.getAmPmStrings()[this.calendar.get(9)]);
        } else {
            Calendar cal = this.calendar;
            if (this.isCalendar()) {
                this.formatSymbols = new DateFormatSymbols();
                cal = Calendar.getInstance();
                this.getDate();
                cal.set(this.year, this.month, this.day);
            }
            if ((this.style & 0x8000) == 0) {
                result.append(String.valueOf(this.formatSymbols.getWeekdays()[cal.get(7)]) + ", ");
            }
            result.append(String.valueOf(this.formatSymbols.getMonths()[cal.get(2)]) + " ");
            if ((this.style & 0x8000) == 0) {
                result.append(String.valueOf(cal.get(5)) + ", ");
            }
            result.append(cal.get(1));
        }
        return result.toString();
    }

    public int getYear() {
        this.checkWidget();
        if (this.isCalendar()) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    int gtk_day_selected(int widget) {
        this.sendSelectionEvent();
        return 0;
    }

    int gtk_day_selected_double_click(int widget) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_month_changed(int widget) {
        if (this.calendarDisplayed) {
            this.calendarDisplayed = false;
        } else {
            this.monthChanged = true;
        }
        this.sendSelectionEvent();
        return 0;
    }

    int eventHandle() {
        return this.dateTimeHandle();
    }

    int focusHandle() {
        return this.dateTimeHandle();
    }

    int fontHandle() {
        return this.dateTimeHandle();
    }

    private int dateTimeHandle() {
        if (this.isCalendar() && this.calendarHandle != 0) {
            return this.calendarHandle;
        }
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0) {
            return this.textEntryHandle;
        }
        return super.focusHandle();
    }

    void hookEvents() {
        super.hookEvents();
        if (this.isCalendar()) {
            this.hookEventsForCalendar();
        } else {
            int eventMask = 772;
            OS.gtk_widget_add_events(this.textEntryHandle, eventMask);
            if ((this.style & 4) == 0) {
                this.hookEventsForDateTimeSpinner();
            }
            if (OS.G_OBJECT_TYPE(this.textEntryHandle) == OS.GTK_TYPE_MENU()) {
                this.hookEventsForMenu();
            }
        }
    }

    private final void hookEventsForCalendar() {
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected, this.display.getClosure(61), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.day_selected_double_click, this.display.getClosure(66), false);
        OS.g_signal_connect_closure(this.calendarHandle, OS.month_changed, this.display.getClosure(62), false);
    }

    private final void hookEventsForDateTimeSpinner() {
        OS.g_signal_connect_closure(this.textEntryHandle, OS.output, this.display.getClosure(36), true);
        OS.g_signal_connect_closure(this.textEntryHandle, OS.focus_in_event, this.display.getClosure(21), true);
    }

    private final void hookEventsForMenu() {
        OS.g_signal_connect_closure(this.down.handle, OS.selection_done, this.display.getClosure(68), true);
    }

    void incrementField(int amount) {
        int fieldName = this.fieldNames[this.currentField];
        int value = this.calendar.get(fieldName);
        if (fieldName == 10) {
            int max = this.calendar.getMaximum(10);
            int min = this.calendar.getMinimum(10);
            if (value == max && amount == 1 || value == min && amount == -1) {
                int temp = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = temp;
            }
        }
        this.setTextField(fieldName, value + amount, true, true);
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    private boolean isCalendar() {
        return (this.style & 0x400) != 0;
    }

    private boolean isDateWithDropDownButton() {
        return (this.style & 4) != 0 && (this.style & 0x20) != 0;
    }

    private static boolean isDateWithDropDownButton(int style) {
        return (style & 4) != 0 && (style & 0x20) != 0;
    }

    private boolean isDate() {
        return (this.style & 0x20) != 0;
    }

    private boolean isTime() {
        return (this.style & 0x80) != 0;
    }

    private boolean isReadOnly() {
        return (this.style & 8) != 0;
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DateTime.this.getSpokenText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = DateTime.this.isCalendar() ? 41 : 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            public void getSelection(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                if (DateTime.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int fieldName, int value) {
        Calendar validCalendar = this.isCalendar() ? Calendar.getInstance() : this.calendar;
        int min = validCalendar.getActualMinimum(fieldName);
        int max = validCalendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    boolean isValidDate(int year, int month, int day) {
        if (year < 1752 || year > 9999) {
            return false;
        }
        Calendar valid = Calendar.getInstance();
        valid.set(year, month, day);
        return valid.get(1) == year && valid.get(2) == month && valid.get(5) == day;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(year, month, day);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.popupCalendar.monthChanged) {
                    this.popupCalendar.monthChanged = false;
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int year = this.popupCalendar.getYear();
                int month = this.popupCalendar.getMonth();
                int day = this.popupCalendar.getDay();
                this.setDate(year, month, day);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.addFilter(15, this.popupFilter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.down || focusControl == this.popupCalendar) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.removeFilter(3, this.mouseEventListener);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle bounds = this.popupCalendar.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, bounds.width + 1, bounds.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectField(int index) {
        if (index != this.currentField) {
            this.commitCurrentField();
        }
        final int start = this.fieldIndices[index].x;
        final int end = this.fieldIndices[index].y;
        Point pt = this.getSelection();
        if (index == this.currentField && start == pt.x && end == pt.y) {
            return;
        }
        this.currentField = index;
        this.display.syncExec(new Runnable(){

            public void run() {
                if (DateTime.this.textEntryHandle != 0) {
                    String value = DateTime.this.getText(DateTime.this.getText(), start, end - 1);
                    int s = value.lastIndexOf(32);
                    s = s == -1 ? start : start + s + 1;
                    DateTime.this.setSelection(s, end);
                }
            }
        });
    }

    void sendSelectionEvent() {
        int[] y = new int[1];
        int[] m = new int[1];
        int[] d = new int[1];
        OS.gtk_calendar_get_date(this.calendarHandle, y, m, d);
        if (d[0] != this.day || m[0] != this.month || y[0] != this.year) {
            this.year = y[0];
            this.month = m[0];
            this.day = d[0];
            if (this.year == Calendar.getInstance().get(1) && this.month == Calendar.getInstance().get(2)) {
                OS.gtk_calendar_mark_day(this.calendarHandle, Calendar.getInstance().get(5));
            } else {
                OS.gtk_calendar_clear_marks(this.calendarHandle);
            }
            this.sendSelectionEvent(13);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!OS.GTK3 && this.isCalendar() && color == null) {
            OS.gtk_widget_modify_base(this.containerHandle, 0, null);
        }
        this.bg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    void setBackgroundColor(GdkColor color) {
        if (this.isCalendar() && !OS.GTK3) {
            OS.gtk_widget_modify_base(this.containerHandle, 0, color);
        } else {
            super.setBackgroundColor(color);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isDateWithDropDownButton()) {
            this.down.setEnabled(enabled);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.containerHandle, color, false);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setFieldOfInternalDataStructure(int fieldName, int value) {
        if (this.calendar.get(fieldName) == value) {
            return;
        }
        if (fieldName == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(fieldName, value);
        if (this.calendar.get(fieldName) != value) {
            this.calendar.set(fieldName, value);
        }
        this.sendSelectionEvent(13);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (!this.isValidDate(year, month, day)) {
            return;
        }
        if (this.isCalendar()) {
            this.year = year;
            this.month = month;
            this.day = day;
            OS.gtk_calendar_select_month(this.calendarHandle, month, year);
            OS.gtk_calendar_select_day(this.calendarHandle, day);
        } else {
            this.calendar.set(year, month, day);
            this.updateControl();
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), day)) {
            return;
        }
        if (this.isCalendar()) {
            this.day = day;
            OS.gtk_calendar_select_day(this.calendarHandle, day);
        } else {
            this.calendar.set(5, day);
            this.updateControl();
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = hours;
        } else {
            this.calendar.set(11, hours);
            this.updateControl();
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.down != null) {
            this.down.setMenu(menu);
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (this.isCalendar()) {
            this.minutes = minutes;
        } else {
            this.calendar.set(12, minutes);
            this.updateControl();
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), month, this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.month = month;
            OS.gtk_calendar_select_month(this.calendarHandle, month, this.year);
        } else {
            this.calendar.set(2, month);
            this.updateControl();
        }
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if (this.isCalendar()) {
            this.seconds = seconds;
        } else {
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if (this.isCalendar()) {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        } else {
            this.calendar.set(11, hours);
            this.calendar.set(12, minutes);
            this.calendar.set(13, seconds);
            this.updateControl();
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        if (!this.isValidDate(year, this.getMonth(), this.getDay())) {
            return;
        }
        if (this.isCalendar()) {
            this.year = year;
            OS.gtk_calendar_select_month(this.calendarHandle, this.month, year);
        } else {
            this.calendar.set(1, year);
            this.updateControl();
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        int calendarPrefferedVerticalSize;
        if (this.isDateWithDropDownButton() && OS.GTK3) {
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_get_preferred_size(this.textEntryHandle, null, requisition);
            int oldHeight = requisition.height;
            int newWidth = width - (this.down.getSize().x + this.getGtkBorderPadding().right);
            OS.gtk_widget_set_size_request(this.textEntryHandle, newWidth >= 0 ? newWidth : 0, oldHeight);
        }
        int fixedGtkVersion = OS.VERSION(3, 14, 2);
        if (this.isCalendar() && OS.GTK3 && OS.GTK_VERSION < fixedGtkVersion && height > (calendarPrefferedVerticalSize = this.computeSize((int)-1, (int)-1, (boolean)true).y)) {
            height = calendarPrefferedVerticalSize;
        }
        super.setBounds(x, y, width, height);
    }

    private void setDropDownButtonSize() {
        int dateEntryHeight;
        Rectangle rect = this.getClientArea();
        int parentWidth = rect.width;
        int parentHeight = rect.height;
        Point buttonSize = this.down.computeSize(-1, parentHeight);
        int newHeight = dateEntryHeight = this.computeNativeSize((int)this.textEntryHandle, (int)-1, (int)-1, (boolean)false).y;
        int newXpos = parentWidth - buttonSize.x;
        int newYPos = parentHeight / 2 - dateEntryHeight / 2;
        this.down.setBounds(newXpos, newYPos, buttonSize.x, newHeight);
    }

    GtkBorder getGtkBorderPadding() {
        if (OS.GTK3) {
            GtkBorder gtkBorderPadding = new GtkBorder();
            int context = OS.gtk_widget_get_style_context(this.textEntryHandle);
            OS.gtk_style_context_get_padding(context, 0, gtkBorderPadding);
            return gtkBorderPadding;
        }
        GtkBorder padding = new GtkBorder();
        padding.right = 2;
        padding.left = 2;
        padding.top = 2;
        padding.bottom = 2;
        return padding;
    }

    boolean onNumberKeyInput(int key) {
        int fieldName = this.fieldNames[this.currentField];
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        int length = end - start;
        String newText = this.keyToString(key);
        if (fieldName == 9) {
            String[] ampm = this.formatSymbols.getAmPmStrings();
            if (newText.equalsIgnoreCase(ampm[0].substring(0, 1)) || newText.equalsIgnoreCase(ampm[0])) {
                this.setTextField(fieldName, 0, true, false);
            } else if (newText.equalsIgnoreCase(ampm[1].substring(0, 1)) || newText.equalsIgnoreCase(ampm[1])) {
                this.setTextField(fieldName, 1, true, false);
            }
            return false;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(newText);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            String value = this.getText(start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            newText = value + newText;
        }
        int newTextLength = newText.length();
        boolean first = this.characterCount == 0;
        this.characterCount = newTextLength < length ? newTextLength : 0;
        int max = this.calendar.getActualMaximum(fieldName);
        int min = this.calendar.getActualMinimum(fieldName);
        int newValue = this.unformattedIntValue(fieldName, newText, this.characterCount == 0, max);
        if (newValue == -1) {
            this.characterCount = 0;
            return false;
        }
        if (first && newValue == 0 && length > 1) {
            this.setTextField(fieldName, newValue, false, false);
        } else if (min <= newValue && newValue <= max) {
            this.setTextField(fieldName, newValue, this.characterCount == 0, this.characterCount == 0);
        } else if (newTextLength >= length && (newValue = this.unformattedIntValue(fieldName, newText = newText.substring(newTextLength - length + 1), this.characterCount == 0, max)) != -1) {
            this.characterCount = length - 1;
            if (min <= newValue && newValue <= max) {
                this.setTextField(fieldName, newValue, this.characterCount == 0, true);
            }
        }
        return false;
    }

    private String keyToString(int key) {
        if (key >= 65456 && key <= 65465) {
            key -= 65408;
        }
        char keyChar = (char)key;
        return "" + keyChar;
    }

    int unformattedIntValue(int fieldName, String newText, boolean adjust, int max) {
        int newValue;
        try {
            newValue = Integer.parseInt(newText);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (fieldName == 2 && adjust && --newValue == -1) {
            newValue = max;
        }
        if (fieldName == 10 && adjust && newValue == 12) {
            newValue = 0;
        }
        return newValue;
    }

    void updateControl() {
        if ((this.isDate() || this.isTime()) && this.textEntryHandle != 0) {
            this.setText(this.getFormattedString(this.style));
        }
        this.redraw();
    }

    void register() {
        super.register();
        if (this.containerHandle != 0) {
            this.display.addWidget(this.containerHandle, this);
        }
        if (this.textEntryHandle != 0) {
            this.display.addWidget(this.textEntryHandle, this);
        }
    }

    void deregister() {
        super.deregister();
        if (this.containerHandle != 0) {
            this.display.removeWidget(this.containerHandle);
        }
        if (this.fixedHandle != 0) {
            this.display.removeWidget(this.fixedHandle);
        }
        if (this.textEntryHandle != 0) {
            this.display.removeWidget(this.textEntryHandle);
        }
    }

    int getArrow(int widget) {
        int adj_value = (int)OS.gtk_adjustment_get_value(OS.gtk_spin_button_get_adjustment(widget));
        int new_value = 0;
        if (this.isDate()) {
            new_value = this.getMonth() + 1;
        } else if (this.isTime() && (new_value = this.getHours() > 12 ? this.getHours() - 12 : this.getHours()) == 0) {
            new_value = 12;
        }
        if (adj_value == 0 && this.firstTime) {
            return 0;
        }
        this.firstTime = false;
        if (adj_value == new_value) {
            return 0;
        }
        return adj_value > new_value ? 0x1000001 : 0x1000002;
    }

    void setText(String dateTimeText) {
        if (dateTimeText != null) {
            byte[] dateTimeConverted = Converter.wcsToMbcs(null, dateTimeText, true);
            OS.gtk_entry_set_width_chars(this.textEntryHandle, dateTimeText.length());
            OS.gtk_entry_set_text(this.textEntryHandle, dateTimeConverted);
        }
    }

    int gtk_key_press_event(int widget, int event) {
        if (!this.isReadOnly() && (this.isTime() || this.isDate())) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65362: 
                case 65431: {
                    this.incrementField(1);
                    this.commitCurrentField();
                    break;
                }
                case 65364: 
                case 65433: {
                    this.incrementField(-1);
                    this.commitCurrentField();
                    break;
                }
                case 65363: 
                case 65432: {
                    this.selectField((this.currentField + 1) % this.fieldCount);
                    this.sendEvent(31);
                    break;
                }
                case 65361: 
                case 65430: {
                    int index = this.currentField - 1;
                    this.selectField(index < 0 ? this.fieldCount - 1 : index);
                    this.sendEvent(31);
                    break;
                }
                case 65360: 
                case 65429: {
                    int fieldName = this.fieldNames[this.currentField];
                    this.setTextField(fieldName, this.calendar.getActualMinimum(fieldName), true, true);
                    break;
                }
                case 65367: 
                case 65436: {
                    int fieldName = this.fieldNames[this.currentField];
                    this.setTextField(fieldName, this.calendar.getActualMaximum(fieldName), true, true);
                    break;
                }
                default: {
                    this.onNumberKeyInput(key);
                }
            }
        }
        return 1;
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int newValue;
            this.characterCount = 0;
            int fieldName = this.fieldNames[this.currentField];
            int start = this.fieldIndices[this.currentField].x;
            int end = this.fieldIndices[this.currentField].y;
            String value = this.getText(this.getText(), start, end - 1);
            int s = value.lastIndexOf(32);
            if (s != -1) {
                value = value.substring(s + 1);
            }
            if ((newValue = this.unformattedIntValue(fieldName, value, this.characterCount == 0, this.calendar.getActualMaximum(fieldName))) != -1) {
                this.setTextField(fieldName, newValue, true, true);
            }
        }
    }

    Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        OS.gtk_editable_get_selection_bounds(this.textEntryHandle, start, end);
        int ptr = OS.gtk_entry_get_text(this.textEntryHandle);
        start[0] = OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
        end[0] = OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
        Point selection = new Point(start[0], end[0]);
        return selection;
    }

    String getText() {
        this.checkWidget();
        if (this.textEntryHandle != 0) {
            int str = OS.gtk_entry_get_text(this.textEntryHandle);
            if (str == 0) {
                return "";
            }
            int length = OS.strlen(str);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, str, length);
            return new String(Converter.mbcsToWcs(null, buffer));
        }
        return "";
    }

    String getText(String str, int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    void setSelection(int start, int end) {
        this.checkWidget();
        int ptr = OS.gtk_entry_get_text(this.textEntryHandle);
        start = OS.g_utf16_offset_to_utf8_offset(ptr, start);
        end = OS.g_utf16_offset_to_utf8_offset(ptr, end);
        OS.gtk_editable_set_position(this.textEntryHandle, start);
        OS.gtk_editable_select_region(this.textEntryHandle, start, end);
    }

    void setTextField(int fieldName, int value, boolean commitInternalDataStructure, boolean adjustDisplayedFormatting) {
        int start = this.fieldIndices[this.currentField].x;
        int end = this.fieldIndices[this.currentField].y;
        this.setSelection(start, end);
        if (commitInternalDataStructure) {
            int validValue = this.validateValueBounds(fieldName, value);
            this.setFieldOfInternalDataStructure(fieldName, validValue);
            this.updateControl();
        } else {
            String newValue = this.formattedStringValue(fieldName, value, adjustDisplayedFormatting);
            newValue = this.padWithZeros(start, end, newValue);
            this.replaceCurrentlySelectedTextRegion(newValue);
        }
        this.selectField(this.currentField);
    }

    private String padWithZeros(int start, int end, String newValue) {
        int prependCount = end - start - newValue.length();
        int i = 0;
        while (i < prependCount) {
            newValue = "0" + newValue;
            ++i;
        }
        return newValue;
    }

    private int validateValueBounds(int fieldName, int value) {
        int max = this.calendar.getActualMaximum(fieldName);
        int min = this.calendar.getActualMinimum(fieldName);
        if (fieldName == 1) {
            max = 9999;
            min = 1752;
            int currentYear = Calendar.getInstance().get(1);
            int currentCentury = currentYear / 100 * 100;
            if (value < (currentYear + 30) % 100) {
                value += currentCentury;
            } else if (value < 100) {
                value += currentCentury - 100;
            }
        }
        if (value > max) {
            value = min;
        }
        if (value < min) {
            value = max;
        }
        return value;
    }

    int gtk_button_press_event(int widget, int event) {
        if (this.isDate() || this.isTime()) {
            GdkEventButton gdkEvent = this.getEventInfoFromOS(event);
            if (gdkEvent.button == 1) {
                this.onTextMouseClick(gdkEvent);
                return this.gtk_button_press_event(widget, event, false);
            }
        }
        return super.gtk_button_press_event(widget, event);
    }

    int gtk_button_release_event(int widget, int event) {
        if (this.isDate() || this.isTime()) {
            GdkEventButton gdkEvent = this.getEventInfoFromOS(event);
            if (gdkEvent.button == 1) {
                this.onTextMouseClick(gdkEvent);
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    private GdkEventButton getEventInfoFromOS(int nativeEventPointer) {
        GdkEventButton localEventCopy = new GdkEventButton();
        OS.memmove(localEventCopy, nativeEventPointer, GdkEventButton.sizeof);
        return localEventCopy;
    }

    int gtk_output(int widget) {
        if (this.calendar == null) {
            return 0;
        }
        int arrowType = this.getArrow(widget);
        switch (arrowType) {
            case 0x1000001: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: {
                this.commitCurrentField();
                this.incrementField(-1);
            }
        }
        return 1;
    }

    void replaceCurrentlySelectedTextRegion(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        int[] start = new int[1];
        int[] end = new int[1];
        OS.gtk_editable_get_selection_bounds(this.textEntryHandle, start, end);
        OS.gtk_editable_delete_selection(this.textEntryHandle);
        OS.gtk_editable_insert_text(this.textEntryHandle, buffer, buffer.length, start);
        OS.gtk_editable_set_position(this.textEntryHandle, start[0]);
    }

    void onTextMouseClick(GdkEventButton event) {
        Point sel = this.getSelection();
        int i = 0;
        while (i < this.fieldCount) {
            if (sel.x >= this.fieldIndices[i].x && sel.x <= this.fieldIndices[i].y) {
                this.currentField = i;
                break;
            }
            ++i;
        }
        this.selectField(this.currentField);
    }

    String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        String str = this.getText();
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    void selectAll() {
        this.checkWidget();
        if (this.textEntryHandle != 0) {
            OS.gtk_editable_select_region(this.textEntryHandle, 0, -1);
        }
    }

    void hideDateTime() {
        if (this.isDate() || this.isTime()) {
            OS.gtk_widget_hide(this.fixedHandle);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.fixedHandle != 0) {
            this.hideDateTime();
        }
    }
}

