/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ITreeModel;
import org.eclipse.pde.api.tools.internal.provisional.ITreeNode;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class DeltaSession
implements ISession {
    static Object[] NO_CHILDREN = new Object[0];
    IDelta delta;
    String baselineName;
    String timestamp;
    String description;

    public DeltaSession(String description, IDelta delta, String baselineName) {
        this.delta = delta;
        this.baselineName = baselineName;
        this.timestamp = DateFormat.getDateTimeInstance((int)2, (int)2).format(new Date(System.currentTimeMillis()));
        this.description = description;
    }

    public ITreeModel getModel() {
        TreeNode root = new TreeNode(0, null, this.delta);
        TreeModel model = new TreeModel(root);
        if (this.delta == ApiComparator.NO_DELTA) {
            root.add(new TreeNode(0, ActionMessages.CompareTaskNoChanges, null));
        } else {
            class TreeBuilder
            extends DeltaVisitor {
                TreeNode node;

                public TreeBuilder(TreeNode node) {
                    this.node = node;
                }

                public void endVisit(IDelta delta) {
                    if (delta.getChildren().length == 0) {
                        String typeName = delta.getTypeName();
                        if (typeName == null) {
                            this.node.add(new TreeNode(0, delta.getKey(), delta));
                        } else if (typeName.length() == 0) {
                            this.node.add(new TreeNode(0, delta.getMessage(), delta));
                        } else {
                            TreeNode node3;
                            int index = typeName.lastIndexOf(46);
                            String packageName = "<default package>";
                            String actualTypeName = null;
                            if (index != -1) {
                                packageName = typeName.substring(0, index);
                                actualTypeName = typeName.substring(index + 1);
                            } else {
                                actualTypeName = typeName;
                            }
                            TreeNode node2 = this.node.getNode(packageName);
                            if (node2 == null) {
                                node2 = new TreeNode(5, packageName, null);
                                this.node.add(node2);
                            }
                            if ((node3 = node2.getNode(actualTypeName)) == null) {
                                int id = 0;
                                switch (delta.getElementType()) {
                                    case 1: {
                                        id = 3;
                                        break;
                                    }
                                    case 8: {
                                        id = 2;
                                        break;
                                    }
                                    case 4: {
                                        id = 1;
                                        break;
                                    }
                                    case 6: {
                                        id = 4;
                                        break;
                                    }
                                    default: {
                                        try {
                                            String componentVersionId = delta.getComponentVersionId();
                                            if (componentVersionId == null) break;
                                            int modifiers = this.retrieveTypeModifiers(delta, typeName, componentVersionId);
                                            if (Flags.isEnum((int)modifiers)) {
                                                id = 4;
                                                break;
                                            }
                                            if (Flags.isAnnotation((int)modifiers)) {
                                                id = 3;
                                                break;
                                            }
                                            if (Flags.isInterface((int)modifiers)) {
                                                id = 2;
                                                break;
                                            }
                                            id = 1;
                                            break;
                                        }
                                        catch (CoreException coreException) {}
                                    }
                                }
                                node3 = new TreeNode(id, actualTypeName, null);
                                node2.add(node3);
                            }
                            node3.add(new TreeNode(0, delta.getMessage(), delta));
                        }
                    }
                }

                private int retrieveTypeModifiers(IDelta delta, String typeName, String componentVersionId) throws CoreException {
                    IApiComponent apiComponent;
                    int indexOfOpen = componentVersionId.lastIndexOf(40);
                    String componentID = componentVersionId.substring(0, indexOfOpen);
                    IApiBaseline baseline = ApiBaselineManager.getManager().getApiBaseline(DeltaSession.this.baselineName);
                    int modifiers = 0;
                    if (baseline != null) {
                        apiComponent = baseline.getApiComponent(componentID);
                        int kind = delta.getKind();
                        if (apiComponent != null && kind == 3) {
                            IApiType structure;
                            IApiTypeRoot typeRoot = null;
                            String id = apiComponent.getSymbolicName();
                            switch (delta.getFlags()) {
                                case 70: 
                                case 71: {
                                    String packageName = "";
                                    int indexOf = typeName.lastIndexOf(46);
                                    if (indexOf != -1) {
                                        packageName = typeName.substring(0, indexOf);
                                    }
                                    IApiComponent[] providers = apiComponent.getBaseline().resolvePackage(apiComponent, packageName);
                                    int index = 0;
                                    while (typeRoot == null && index < providers.length) {
                                        IApiComponent p = providers[index];
                                        if (!p.equals(apiComponent)) {
                                            String id2 = p.getSymbolicName();
                                            typeRoot = "org.eclipse.swt".equals(id2) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2);
                                        }
                                        ++index;
                                    }
                                    break;
                                }
                                default: {
                                    typeRoot = "org.eclipse.swt".equals(id) ? apiComponent.findTypeRoot(typeName) : apiComponent.findTypeRoot(typeName, id);
                                }
                            }
                            if (typeRoot != null && (structure = typeRoot.getStructure()) != null) {
                                modifiers = structure.getModifiers();
                            }
                        }
                    }
                    if (modifiers == 0 && (baseline = ApiBaselineManager.getManager().getWorkspaceBaseline()) != null && (apiComponent = baseline.getApiComponent(componentID)) != null) {
                        IApiTypeRoot typeRoot = null;
                        String id = apiComponent.getSymbolicName();
                        switch (delta.getFlags()) {
                            case 70: 
                            case 71: {
                                String packageName = "";
                                int indexOf = typeName.lastIndexOf(46);
                                if (indexOf != -1) {
                                    packageName = typeName.substring(0, indexOf);
                                }
                                IApiComponent[] providers = apiComponent.getBaseline().resolvePackage(apiComponent, packageName);
                                int index = 0;
                                while (typeRoot == null && index < providers.length) {
                                    IApiComponent p = providers[index];
                                    if (!p.equals(apiComponent)) {
                                        String id2 = p.getSymbolicName();
                                        typeRoot = "org.eclipse.swt".equals(id2) ? p.findTypeRoot(typeName) : p.findTypeRoot(typeName, id2);
                                    }
                                    ++index;
                                }
                                break;
                            }
                            default: {
                                typeRoot = "org.eclipse.swt".equals(id) ? apiComponent.findTypeRoot(typeName) : apiComponent.findTypeRoot(typeName, id);
                            }
                        }
                        if (typeRoot != null) {
                            IApiType structure = typeRoot.getStructure();
                            modifiers = structure.getModifiers();
                        }
                    }
                    return modifiers;
                }
            }
            this.delta.accept((DeltaVisitor)new TreeBuilder(root));
        }
        return model;
    }

    public String getDescription() {
        return NLS.bind((String)ActionMessages.SessionDescription, (Object[])new String[]{this.timestamp, this.description});
    }

    static class TreeModel
    implements ITreeModel {
        TreeNode root;

        TreeModel(TreeNode root) {
            this.root = root;
        }

        public ITreeNode getRoot() {
            return this.root;
        }
    }

    static class TreeNode
    implements ITreeNode,
    IPropertySource2,
    IAdaptable {
        private static final IPropertyDescriptor[] NO_PROPERTY_DESCRIPTORS = new IPropertyDescriptor[0];
        public static final String ID_MESSAGE = "IDelta.Message";
        public static final String ID_COMPONENT = "IDelta.Component";
        public static final String ID_ELEMENT_TYPE = "IDelta.ElementType";
        public static final String ID_FLAGS = "IDelta.Flags";
        private static final Object ID_KEY = "IDelta.Key";
        private static final Object ID_KIND = "IDelta.Kind";
        private static final Object ID_NEW_MODIFIERS = "IDelta.NewModifiers";
        private static final Object ID_OLD_MODIFIERS = "IDelta.OldModifiers";
        private static final Object ID_CURRENT_RESTRICTIONS = "IDelta.CurrentRestrictions";
        private static final Object ID_PREVIOUS_RESTRICTIONS = "IDelta.PreviousRestrictions";
        private static final Object ID_TYPENAME = "IDelta.TypeName";
        public static final String P_MESSAGE_CATEGORY = ActionMessages.MessageCategory;
        public static final String P_INFO_CATEGORY = ActionMessages.InfoCategory;
        public static final String P_MESSAGE = ActionMessages.PropertyMessageKey;
        public static final String P_COMPONENT = ActionMessages.PropertyComponentKey;
        public static final String P_ELEMENT_TYPE = ActionMessages.PropertyElementTypeKey;
        public static final String P_FLAGS = ActionMessages.PropertyFlagsKey;
        public static final String P_KEY = ActionMessages.PropertyKeyKey;
        public static final String P_KIND = ActionMessages.PropertyKindKey;
        public static final String P_NEW_MODIFIERS = ActionMessages.PropertyNewModifiersKey;
        public static final String P_OLD_MODIFIERS = ActionMessages.PropertyOldModifiersKey;
        public static final String P_CURRENT_RESTRICTIONS = ActionMessages.PropertyCurrentRestrictionsKey;
        public static final String P_PREVIOUS_RESTRICTIONS = ActionMessages.PropertyPreviousRestrictionsKey;
        public static final String P_TYPENAME = ActionMessages.PropertyTypeNameKey;
        private static List<PropertyDescriptor> Descriptors = new ArrayList<PropertyDescriptor>();
        Map<String, TreeNode> children;
        String name;
        TreeNode parent;
        Object data;
        int id;

        static {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)ID_MESSAGE, P_MESSAGE);
            propertyDescriptor.setCategory(P_MESSAGE_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor((Object)ID_COMPONENT, P_COMPONENT);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_KEY, P_KEY);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            propertyDescriptor.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_KIND, P_KIND);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_NEW_MODIFIERS, P_NEW_MODIFIERS);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_OLD_MODIFIERS, P_OLD_MODIFIERS);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_CURRENT_RESTRICTIONS, P_CURRENT_RESTRICTIONS);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_PREVIOUS_RESTRICTIONS, P_PREVIOUS_RESTRICTIONS);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor(ID_TYPENAME, P_TYPENAME);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor((Object)ID_FLAGS, P_FLAGS);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
            propertyDescriptor = new PropertyDescriptor((Object)ID_ELEMENT_TYPE, P_ELEMENT_TYPE);
            propertyDescriptor.setCategory(P_INFO_CATEGORY);
            Descriptors.add(propertyDescriptor);
        }

        static List<PropertyDescriptor> getDescriptors() {
            return Descriptors;
        }

        public TreeNode(int id, String name, Object data) {
            this.name = name;
            this.id = id;
            this.data = data;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                return NO_CHILDREN;
            }
            return this.children.values().toArray(new Object[this.children.size()]);
        }

        public TreeNode getNode(String name) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(name);
        }

        public int getId() {
            return this.id;
        }

        public void add(TreeNode node) {
            if (this.children == null) {
                this.children = new HashMap<String, TreeNode>();
            }
            this.children.put(node.name, node);
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public String toString() {
            return String.valueOf(this.name);
        }

        public Object getData() {
            return this.data;
        }

        public Object getEditableValue() {
            return this;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            if (this.data != null) {
                return TreeNode.getDescriptors().toArray(new IPropertyDescriptor[TreeNode.getDescriptors().size()]);
            }
            return NO_PROPERTY_DESCRIPTORS;
        }

        public Object getPropertyValue(Object propKey) {
            if (this.data == null) {
                return null;
            }
            IDelta delta = (IDelta)this.data;
            if (ID_MESSAGE.equals(propKey)) {
                return delta.getMessage();
            }
            if (ID_COMPONENT.equals(propKey)) {
                return delta.getComponentVersionId();
            }
            if (ID_ELEMENT_TYPE.equals(propKey)) {
                int elementType = delta.getElementType();
                StringBuffer buffer = new StringBuffer(Util.getDeltaElementType((int)elementType));
                buffer.append(" (").append(elementType).append(')');
                return String.valueOf(buffer);
            }
            if (ID_FLAGS.equals(propKey)) {
                int flags = delta.getFlags();
                StringBuffer buffer = new StringBuffer(Util.getDeltaFlagsName((int)flags));
                buffer.append(" (").append(flags).append(')');
                return String.valueOf(buffer);
            }
            if (ID_KEY.equals(propKey)) {
                return delta.getKey();
            }
            if (ID_KIND.equals(propKey)) {
                int kind = delta.getKind();
                StringBuffer buffer = new StringBuffer(Util.getDeltaKindName((int)kind));
                buffer.append(" (").append(kind).append(')');
                return String.valueOf(buffer);
            }
            if (ID_NEW_MODIFIERS.equals(propKey)) {
                return TreeNode.getDisplayedModifiers(delta.getNewModifiers());
            }
            if (ID_OLD_MODIFIERS.equals(propKey)) {
                return TreeNode.getDisplayedModifiers(delta.getOldModifiers());
            }
            if (ID_CURRENT_RESTRICTIONS.equals(propKey)) {
                int restrictions = delta.getCurrentRestrictions();
                return this.getDisplayRestrictions(restrictions);
            }
            if (ID_PREVIOUS_RESTRICTIONS.equals(propKey)) {
                int restrictions = delta.getPreviousRestrictions();
                return this.getDisplayRestrictions(restrictions);
            }
            if (ID_TYPENAME.equals(propKey)) {
                return delta.getTypeName();
            }
            return null;
        }

        private Object getDisplayRestrictions(int restrictions) {
            StringBuffer buffer = new StringBuffer(RestrictionModifiers.getRestrictionText((int)restrictions));
            buffer.append(" (0x").append(Integer.toHexString(restrictions)).append(')');
            return String.valueOf(buffer);
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IPropertySource.class) {
                return this;
            }
            return null;
        }

        private static String getDisplayedModifiers(int newModifiers) {
            StringBuffer buffer = new StringBuffer();
            if (newModifiers == 0) {
                buffer.append(ActionMessages.PropertyPackageVisibility);
            } else {
                if (Flags.isAbstract((int)newModifiers)) {
                    buffer.append("abstract");
                }
                String separator = " | ";
                if (Flags.isFinal((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("final");
                }
                if (Flags.isNative((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("native");
                }
                if (Flags.isPrivate((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("private");
                }
                if (Flags.isProtected((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("protected");
                }
                if (Flags.isPublic((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("public");
                }
                if (Flags.isStatic((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("static");
                }
                if (Flags.isStrictfp((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("strictfp");
                }
                if (Flags.isSynchronized((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("synchronized");
                }
                if (Flags.isTransient((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("transient");
                }
                if (Flags.isVolatile((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("volatile");
                }
                if (Flags.isVarargs((int)newModifiers)) {
                    if (buffer.length() > 0) {
                        buffer.append(separator);
                    }
                    buffer.append("vargars");
                }
            }
            buffer.append(" (0x").append(Integer.toHexString(newModifiers)).append(')');
            return buffer.toString();
        }

        public boolean isPropertyResettable(Object id) {
            return false;
        }
    }
}

