/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.Position;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text.Highlighter;

public class MarkerHighlighter
extends Highlighter {
    private IFile fFile;
    private Map fMatchesToAnnotations;

    public MarkerHighlighter(IFile file) {
        this.fFile = file;
        this.fMatchesToAnnotations = new HashMap();
    }

    public void addHighlights(final Match[] matches) {
        try {
            SearchPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < matches.length) {
                        IMarker marker = MarkerHighlighter.this.createMarker(matches[i]);
                        if (marker != null) {
                            MarkerHighlighter.this.fMatchesToAnnotations.put(matches[i], marker);
                        }
                        ++i;
                    }
                }
            }, (ISchedulingRule)this.fFile, 1, null);
        }
        catch (CoreException e) {
            SearchPlugin.log(e.getStatus());
        }
    }

    private IMarker createMarker(Match match) throws CoreException {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        if (position == null) {
            if (match.getOffset() < 0 || match.getLength() < 0) {
                return null;
            }
            position = new Position(match.getOffset(), match.getLength());
        } else {
            position = new Position(position.getOffset(), position.getLength());
        }
        IMarker marker = match.isFiltered() ? this.fFile.createMarker("org.eclipse.search.filteredsearchmarker") : this.fFile.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
        if (match.getBaseUnit() == 2) {
            attributes.put("charStart", new Integer(position.getOffset()));
            attributes.put("charEnd", new Integer(position.getOffset() + position.getLength()));
        } else {
            attributes.put("lineNumber", new Integer(position.getOffset()));
        }
        marker.setAttributes(attributes);
        return marker;
    }

    public void removeHighlights(Match[] matches) {
        int i = 0;
        while (i < matches.length) {
            IMarker marker = (IMarker)this.fMatchesToAnnotations.remove(matches[i]);
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    SearchPlugin.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    public void removeAll() {
        try {
            this.fFile.deleteMarkers("org.eclipse.search.searchmarker", true, 2);
            this.fFile.deleteMarkers("org.eclipse.search.filteredsearchmarker", true, 2);
            this.fMatchesToAnnotations.clear();
        }
        catch (CoreException e) {
            SearchPlugin.log(e.getStatus());
        }
    }

    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!buffer.getLocation().equals((Object)this.fFile.getFullPath())) {
            return;
        }
        Match[] matches = new Match[this.fMatchesToAnnotations.keySet().size()];
        this.fMatchesToAnnotations.keySet().toArray(matches);
        this.removeAll();
        this.addHighlights(matches);
    }
}

