/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsPackage;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.RenameAction;
import org.eclipse.rcptt.ui.actions.edit.DeleteAction;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.tags.TagsFilterComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class TagsView
extends ViewPart {
    private EContentAdapter tagsLabelListener;
    private TagsFilterComposite tagsComposite;
    private TreeViewer tagsViewer;
    private TableViewer listViewer;
    private RenameAction renameAction;
    private DeleteAction deleteAction;
    private IAction replayAction;
    private IAction refreshAction;

    public void createPartControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 0).applyTo(panel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        this.tagsComposite = new TagsFilterComposite(panel, true);
        this.tagsViewer = this.tagsComposite.getTagsViewer();
        this.listViewer = this.tagsComposite.getListViewer();
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagsView.this.listViewer.setSelection(null);
                TagsView.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.tagsViewer.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TagsView.this.tagsViewer.getSelection();
                if (!selection.isEmpty()) {
                    TagsView.this.updateSelection(selection);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection iss = (IStructuredSelection)TagsView.this.listViewer.getSelection();
                Object element = iss.getFirstElement();
                if (element instanceof IQ7NamedElement) {
                    IQ7NamedElement q7Element = (IQ7NamedElement)element;
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (activePage != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)q7Element.getResource()));
                        }
                        catch (PartInitException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                }
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagsView.this.updateSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.listViewer.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TagsView.this.listViewer.getSelection();
                if (!selection.isEmpty()) {
                    TagsView.this.updateSelection(selection);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.createActions();
        MenuManager menuTagsManager = new MenuManager();
        this.fillTagsMenu((IMenuManager)menuTagsManager);
        this.tagsViewer.getControl().setMenu(menuTagsManager.createContextMenu(this.tagsViewer.getControl()));
        MenuManager menuListManager = new MenuManager();
        this.fillListMenu((IMenuManager)menuListManager);
        this.listViewer.getControl().setMenu(menuListManager.createContextMenu(this.listViewer.getControl()));
        this.fillToolbar(this.getViewSite().getActionBars().getToolBarManager());
        UIJob setInputJob = new UIJob(this.tagsViewer.getControl().getDisplay(), "Initialize tags view"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                TagsRegistry tagsRegistry = Q7UIPlugin.getDefault().getTags();
                TagsView.this.tagsLabelListener = new EContentAdapter(){

                    public void notifyChanged(final Notification notification) {
                        super.notifyChanged(notification);
                        if (notification.getFeature() == TagsPackage.Literals.TAG__REFS || notification.getFeature() == TagsPackage.Literals.TAG__VALUE || notification.getFeature() == TagsPackage.Literals.TAG__TAGS) {
                            Q7UIPlugin.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!TagsView.this.tagsViewer.getControl().isDisposed()) {
                                        Object parent = notification.getNotifier();
                                        while (parent instanceof Tag) {
                                            TagsView.this.tagsViewer.refresh(parent, true);
                                            parent = TagsUtil.getParentTag((Tag)((Tag)parent));
                                        }
                                        TagsView.this.tagsComposite.updateList();
                                    }
                                }
                            });
                        }
                    }
                };
                TagsRegistry tagsRegistry2 = tagsRegistry;
                synchronized (tagsRegistry2) {
                    tagsRegistry.eAdapters().add((Object)TagsView.this.tagsLabelListener);
                }
                ((TagsView)TagsView.this).tagsComposite.tags = EMFObservables.observeList((EObject)tagsRegistry, (EStructuralFeature)TagsPackage.Literals.TAGS_REGISTRY__TAGS);
                TagsView.this.tagsViewer.setInput((Object)((TagsView)TagsView.this).tagsComposite.tags);
                TagsView.this.updateSelection((IStructuredSelection)StructuredSelection.EMPTY);
                return Status.OK_STATUS;
            }
        };
        setInputJob.schedule();
    }

    private void updateSelection(IStructuredSelection selection) {
        if (this.renameAction != null) {
            this.renameAction.selectionChanged(selection);
        }
        if (this.deleteAction != null) {
            this.deleteAction.selectionChanged(selection);
        }
    }

    private void createActions() {
        this.replayAction = new Action(Messages.TagsView_ReplayActionName, Images.getImageDescriptor("icons/recording/play.gif")){

            public void run() {
                IStructuredSelection selection;
                if (TagsView.this.tagsViewer.getControl().isFocusControl()) {
                    selection = (IStructuredSelection)TagsView.this.tagsViewer.getSelection();
                    if (selection.isEmpty()) {
                        selection = (IStructuredSelection)TagsView.this.listViewer.getSelection();
                    }
                } else {
                    selection = (IStructuredSelection)TagsView.this.listViewer.getSelection();
                    if (selection.isEmpty()) {
                        selection = (IStructuredSelection)TagsView.this.tagsViewer.getSelection();
                    }
                }
                LaunchUtils.launchContext(LaunchUtils.getContext((ISelection)selection), "run");
            }
        };
        this.renameAction = new RenameAction((IShellProvider)this.getSite(), this.tagsViewer.getTree());
        this.deleteAction = new DeleteAction((IShellProvider)this.getSite());
        this.refreshAction = new Action(Messages.TagsView_RefreshActionName, Images.getImageDescriptor("icons/refresh.gif")){

            public void run() {
                Object element = ((IStructuredSelection)TagsView.this.tagsViewer.getSelection()).getFirstElement();
                TagsView.this.tagsViewer.refresh(element, true);
                TagsView.this.tagsComposite.updateList();
            }
        };
    }

    private void fillTagsMenu(IMenuManager manager) {
        manager.add(this.replayAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.renameAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.refreshAction);
    }

    private void fillListMenu(IMenuManager manager) {
        manager.add(this.replayAction);
    }

    private void fillToolbar(IToolBarManager manager) {
        manager.add(this.replayAction);
        manager.add((IAction)this.deleteAction);
        manager.add(this.refreshAction);
    }

    public void setFocus() {
        if (this.listViewer.getSelection().isEmpty()) {
            this.tagsViewer.getControl().setFocus();
        } else {
            this.listViewer.getControl().setFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TagsRegistry registry;
        super.dispose();
        TagsRegistry tagsRegistry = registry = Q7UIPlugin.getDefault().getTags();
        synchronized (tagsRegistry) {
            registry.eAdapters().remove((Object)this.tagsLabelListener);
        }
        if (this.tagsComposite != null && this.tagsComposite.tags != null) {
            this.tagsComposite.tags.dispose();
        }
    }
}

