/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EEVMPage
extends AbstractVMInstallPage {
    private VMStandin fVM;
    private Text fVMName;
    private Text fVMArgs;
    private Text fEEFile;
    private VMLibraryBlock fLibraryBlock;
    private IStatus[] fFieldStatus = new IStatus[1];
    private boolean fIgnoreCallbacks = false;

    public EEVMPage() {
        super(JREMessages.EEVMPage_0);
        int i = 0;
        while (i < this.fFieldStatus.length) {
            this.fFieldStatus[i] = Status.OK_STATUS;
            ++i;
        }
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public void createControl(Composite p) {
        Composite composite = new Composite(p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SWTFactory.createLabel((Composite)composite, (String)JREMessages.EEVMPage_1, (int)1);
        this.fEEFile = SWTFactory.createSingleText((Composite)composite, (int)1);
        Button folders = SWTFactory.createPushButton((Composite)composite, (String)JREMessages.EEVMPage_2, null);
        GridData data = (GridData)folders.getLayoutData();
        data.horizontalAlignment = 3;
        SWTFactory.createLabel((Composite)composite, (String)JREMessages.addVMDialog_jreName, (int)1);
        this.fVMName = SWTFactory.createSingleText((Composite)composite, (int)2);
        Label label = SWTFactory.createLabel((Composite)composite, (String)JREMessages.AddVMDialog_23, (int)2);
        GridData gd = (GridData)label.getLayoutData();
        gd.verticalAlignment = 1;
        this.fVMArgs = SWTFactory.createText((Composite)composite, (int)2624, (int)3, (String)"");
        gd = (GridData)this.fVMArgs.getLayoutData();
        gd.widthHint = 200;
        gd.heightHint = 75;
        Button variables = SWTFactory.createPushButton((Composite)composite, (String)JREMessages.EEVMPage_3, null);
        gd = (GridData)variables.getLayoutData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 3;
        SWTFactory.createLabel((Composite)composite, (String)JREMessages.AddVMDialog_JRE_system_libraries__1, (int)3);
        this.fLibraryBlock = new VMLibraryBlock();
        this.fLibraryBlock.setWizard(this.getWizard());
        this.fLibraryBlock.createControl(composite);
        Control libControl = this.fLibraryBlock.getControl();
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        libControl.setLayoutData((Object)gd);
        this.initializeFields();
        this.fVMName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEVMPage.this.fIgnoreCallbacks) {
                    EEVMPage.this.validateVMName();
                }
            }
        });
        this.fEEFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!EEVMPage.this.fIgnoreCallbacks && EEVMPage.this.validateDefinitionFile().isOK()) {
                    EEVMPage.this.initializeFields();
                }
            }
        });
        folders.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(EEVMPage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.ee"});
                File file = EEVMPage.this.getDefinitionFile();
                String text = EEVMPage.this.fEEFile.getText();
                if (file != null && file.isFile()) {
                    text = file.getParentFile().getAbsolutePath();
                }
                dialog.setFileName(text);
                String newPath = dialog.open();
                if (newPath != null) {
                    EEVMPage.this.fEEFile.setText(newPath);
                }
            }
        });
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String expression;
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(EEVMPage.this.getShell());
                if (dialog.open() == 0 && (expression = dialog.getVariableExpression()) != null) {
                    EEVMPage.this.fVMArgs.insert(expression);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.EDIT_JRE_EE_FILE_WIZARD_PAGE);
    }

    private IStatus validateDefinitionFile() {
        String locationName = this.fEEFile.getText();
        StatusInfo s = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(2, JREMessages.EEVMPage_4);
        } else {
            final File file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.EEVMPage_5);
            } else {
                final IStatus[] temp = new IStatus[1];
                final VMStandin[] standin = new VMStandin[1];
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            standin[0] = JavaRuntime.createVMFromDefinitionFile((File)file, (String)EEVMPage.this.fVM.getName(), (String)EEVMPage.this.fVM.getId());
                            IStatus status = standin[0].getVMInstallType().validateInstallLocation(standin[0].getInstallLocation());
                            temp[0] = status.getSeverity() != 4 ? Status.OK_STATUS : status;
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
                if (s.isOK()) {
                    this.fVM = standin[0];
                }
            }
        }
        this.setDefinitionFileStatus(s);
        this.updatePageStatus();
        return s;
    }

    private void validateVMName() {
        this.nameChanged(this.fVMName.getText());
    }

    public boolean finish() {
        this.setFieldValuesToVM(this.fVM);
        this.fLibraryBlock.finish();
        return true;
    }

    public VMStandin getSelection() {
        return this.fVM;
    }

    public void setSelection(VMStandin vm) {
        super.setSelection(vm);
        this.fVM = vm;
        this.setTitle(JREMessages.EEVMPage_6);
        this.setDescription(JREMessages.EEVMPage_7);
    }

    protected void setFieldValuesToVM(VMStandin vm) {
        vm.setName(this.fVMName.getText());
        String argString = this.fVMArgs.getText().trim();
        if (argString != null && argString.length() > 0) {
            vm.setVMArgs(argString);
        } else {
            vm.setVMArgs(null);
        }
    }

    private File getDefinitionFile() {
        String path = this.fEEFile.getText().trim();
        if (path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    protected static String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    private void initializeFields() {
        try {
            String vmArgs;
            this.fIgnoreCallbacks = true;
            this.fLibraryBlock.setSelection(this.fVM);
            this.fVMName.setText(this.fVM.getName());
            this.fVMName.setSelection(this.fVM.getName().length());
            String eePath = this.fVM.getAttribute("ATTR_DEFINITION_FILE");
            if (eePath != null) {
                this.fEEFile.setText(eePath);
                this.fEEFile.setSelection(eePath.length());
            }
            if ((vmArgs = this.fVM.getVMArgs()) != null) {
                this.fVMArgs.setText(vmArgs);
            }
            this.validateVMName();
        }
        finally {
            this.fIgnoreCallbacks = false;
        }
    }

    private void setDefinitionFileStatus(IStatus status) {
        this.fFieldStatus[0] = status;
    }

    public String getErrorMessage() {
        String message = super.getErrorMessage();
        if (message == null) {
            return this.fLibraryBlock.getErrorMessage();
        }
        return message;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (complete) {
            return this.fLibraryBlock.isPageComplete();
        }
        return complete;
    }

    protected IStatus[] getVMStatus() {
        return this.fFieldStatus;
    }
}

