/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class HttpField {
    private final HttpHeader _header;
    private final String _name;
    private final String _value;

    public HttpField(HttpHeader header, String name, String value) {
        this._header = header;
        this._name = name;
        this._value = value;
    }

    public HttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public HttpField(HttpHeader header, HttpHeaderValue value) {
        this(header, header.asString(), value.asString());
    }

    public HttpField(String name, String value) {
        this((HttpHeader)((Object)HttpHeader.CACHE.get(name)), name, value);
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        String v = this.getValue();
        return this.getName() + ": " + (v == null ? "" : v);
    }

    public boolean isSame(HttpField field) {
        if (field == null) {
            return false;
        }
        if (field == this) {
            return true;
        }
        if (this._header != null && this._header == field.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(field.getName());
    }
}

