/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class Backbone {
    private Backbone() {
    }

    public static IVecInt compute(ISolver solver) throws TimeoutException {
        return Backbone.compute(solver, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver solver, IVecInt assumptions) throws TimeoutException {
        boolean result = solver.isSatisfiable(assumptions);
        if (!result) {
            return VecInt.EMPTY;
        }
        return Backbone.compute(solver, solver.primeImplicant(), assumptions);
    }

    public static IVecInt compute(ISolver solver, int[] implicant) throws TimeoutException {
        return Backbone.compute(solver, implicant, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver solver, int[] implicant, IVecInt assumptions) throws TimeoutException {
        VecInt litsToTest = new VecInt();
        int[] nArray = implicant;
        int n = implicant.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (!assumptions.contains(p)) {
                litsToTest.push(-p);
            }
            ++n2;
        }
        VecInt candidates = new VecInt();
        assumptions.copyTo(candidates);
        while (!litsToTest.isEmpty()) {
            int p = litsToTest.last();
            candidates.push(p);
            litsToTest.pop();
            if (solver.isSatisfiable(candidates)) {
                candidates.pop();
                implicant = solver.primeImplicant();
                Backbone.removeVarNotPresentAndSatisfiedLits(implicant, litsToTest, solver.nVars());
                continue;
            }
            candidates.pop().push(-p);
        }
        return candidates;
    }

    private static void removeVarNotPresentAndSatisfiedLits(int[] implicant, IVecInt litsToTest, int n) {
        int[] marks = new int[n + 1];
        int[] nArray = implicant;
        int n2 = implicant.length;
        int n3 = 0;
        while (n3 < n2) {
            int p;
            marks[(p = nArray[n3]) > 0 ? p : -p] = p;
            ++n3;
        }
        int i = 0;
        while (i < litsToTest.size()) {
            int q = litsToTest.get(i);
            int mark = marks[q > 0 ? q : -q];
            if (mark == 0 || mark == q) {
                litsToTest.delete(i);
                continue;
            }
            ++i;
        }
    }
}

