/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import java.lang.management.ThreadInfo;
import java.util.Arrays;
import org.eclipse.ui.internal.monitoring.Messages;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.monitoring.StackSample;

public class FilterHandler {
    private final Filter[] filters;

    public FilterHandler(String unparsedFilters) {
        String[] rawFilters = unparsedFilters.split(",");
        this.filters = new Filter[rawFilters.length];
        int i = 0;
        while (i < rawFilters.length) {
            String currentFilter = rawFilters[i];
            int period = currentFilter.lastIndexOf(46);
            this.filters[i] = period < 0 ? new Filter("", currentFilter) : new Filter(currentFilter.substring(0, period), currentFilter.substring(period + 1));
            ++i;
        }
        Arrays.sort(this.filters);
    }

    public boolean shouldLogEvent(StackSample[] stackSamples, int numSamples, long displayThreadId) {
        if (this.filters.length > 0) {
            int i = 0;
            while (i < numSamples) {
                if (this.hasFilteredTraces(stackSamples[i].getStackTraces(), displayThreadId)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean hasFilteredTraces(ThreadInfo[] stackTraces, long displayThreadId) {
        ThreadInfo[] threadInfoArray = stackTraces;
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            if (threadInfo.getThreadId() == displayThreadId) {
                return this.matchesFilter(threadInfo.getStackTrace());
            }
            ++n2;
        }
        MonitoringPlugin.logError(Messages.FilterHandler_missing_thread_error, null);
        return false;
    }

    private boolean matchesFilter(StackTraceElement[] stackTraces) {
        StackTraceElement[] stackTraceElementArray = stackTraces;
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            String methodName = element.getMethodName();
            String className = element.getClassName();
            int low = 0;
            int high = this.filters.length;
            while (low < high) {
                int mid = low + high >>> 1;
                Filter filter = this.filters[mid];
                int c = methodName.compareTo(filter.methodName);
                if (c == 0) {
                    c = className.compareTo(filter.className);
                }
                if (c == 0) {
                    return true;
                }
                if (c < 0) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            ++n2;
        }
        return false;
    }

    private class Filter
    implements Comparable<Filter> {
        final String className;
        final String methodName;

        public Filter(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public int compareTo(Filter other) {
            int c = this.methodName.compareTo(other.methodName);
            if (c != 0) {
                return c;
            }
            return this.className.compareTo(other.className);
        }
    }
}

