/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring.preferences;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.monitoring.EventLoopMonitorThread;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.internal.monitoring.MonitoringStartup;
import org.eclipse.ui.internal.monitoring.preferences.Messages;

public class MonitoringPreferenceListener
implements IPropertyChangeListener {
    private EventLoopMonitorThread monitoringThread;
    private boolean monitorThreadRestartInProgress;

    public MonitoringPreferenceListener(EventLoopMonitorThread thread) {
        this.monitoringThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (!(property.equals("monitoring_enabled") || property.equals("deadlock_reporting_threshold") || property.equals("long_event_error_threshold") || property.equals("long_event_warning_threshold") || property.equals("log_to_error_log") || property.equals("max_stack_samples") || property.equals("filter_traces"))) {
            return;
        }
        MonitoringPreferenceListener monitoringPreferenceListener = this;
        synchronized (monitoringPreferenceListener) {
            if (this.monitorThreadRestartInProgress) {
                return;
            }
            this.monitorThreadRestartInProgress = true;
            Display display = MonitoringPlugin.getDefault().getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MonitoringPreferenceListener.this.refreshMonitoringThread();
                }
            });
        }
    }

    private synchronized void refreshMonitoringThread() {
        if (this.monitoringThread != null) {
            this.monitoringThread.shutdown();
            this.monitoringThread = null;
        }
        this.monitorThreadRestartInProgress = false;
        MonitoringPlugin plugin = MonitoringPlugin.getDefault();
        IPreferenceStore preferences = plugin.getPreferenceStore();
        if (preferences.getBoolean("monitoring_enabled")) {
            EventLoopMonitorThread thread = MonitoringStartup.createAndStartMonitorThread();
            if (thread == null) {
                MessageDialog.openError((Shell)plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MonitoringPreferenceListener_preference_error_header, (String)Messages.MonitoringPreferenceListener_preference_error);
                return;
            }
            this.monitoringThread = thread;
        }
    }
}

