/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.op.CreatePatchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.ResetMenu;
import org.eclipse.egit.ui.internal.history.GraphContentProvider;
import org.eclipse.egit.ui.internal.history.GraphLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTPlotRenderer;
import org.eclipse.egit.ui.internal.history.TableLoader;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

class CommitGraphTable {
    private static final String LINESEP = System.getProperty("line.separator");
    private final TableViewer table;
    private Clipboard clipboard;
    private final SWTPlotRenderer renderer;
    private final Font nFont;
    private final Font hFont;
    private SWTCommitList allCommits;
    private int allCommitsLength = 0;
    private HashMap<String, PlotCommit> commitsMap = null;
    private RevFlag highlight;
    private HistoryPageInput input;
    IAction copy;
    MenuListener menuListener;
    private RevCommit commitToShow;
    private GraphLabelProvider graphLabelProvider;
    private final TableLoader tableLoader;
    private boolean trace = GitTraceLocation.HISTORYVIEW.isActive();

    static Font highlightFont() {
        FontData[] hData;
        Font n = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        Font h = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphHighlightFont");
        FontData[] nData = n.getFontData();
        if (nData.length != (hData = h.getFontData()).length) {
            return h;
        }
        int i = 0;
        while (i < nData.length) {
            if (!nData[i].equals((Object)hData[i])) {
                return h;
            }
            ++i;
        }
        return UIUtils.getBoldFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    }

    CommitGraphTable(Composite parent, TableLoader loader, ResourceManager resources) {
        this.nFont = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        this.hFont = CommitGraphTable.highlightFont();
        this.tableLoader = loader;
        final Table rawTable = new Table(parent, 268503810);
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(false);
        rawTable.setFont(this.nFont);
        rawTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (CommitGraphTable.this.tableLoader != null) {
                    TableItem item = (TableItem)event.item;
                    int index = rawTable.indexOf(item);
                    if (CommitGraphTable.this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Item " + index);
                    }
                    CommitGraphTable.this.tableLoader.loadItem(index);
                }
            }
        });
        TableLayout layout = new TableLayout();
        rawTable.setLayout((Layout)layout);
        this.createColumns(rawTable, layout);
        this.createPaintListener(rawTable);
        this.table = new TableViewer(rawTable){

            protected Widget doFindItem(Object element) {
                return element != null ? ((SWTCommit)((Object)element)).widget : null;
            }

            protected void mapElement(Object element, Widget item) {
                ((SWTCommit)((Object)element)).widget = item;
            }
        };
        this.graphLabelProvider = new GraphLabelProvider();
        this.table.setLabelProvider((IBaseLabelProvider)this.graphLabelProvider);
        this.table.setContentProvider((IContentProvider)new GraphContentProvider());
        this.renderer = new SWTPlotRenderer(rawTable.getDisplay(), resources);
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitGraphTable.this.clipboard.dispose();
            }
        });
        this.copy = this.createStandardAction(ActionFactory.COPY);
        this.table.setUseHashlookup(true);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                CommitGraphTable.this.commitToShow = (RevCommit)((PlotCommit)iss.getFirstElement());
                CommitGraphTable.this.copy.setEnabled(CommitGraphTable.this.canDoCopy());
            }
        });
        final RefHoverInformationControlManager hoverManager = new RefHoverInformationControlManager();
        hoverManager.install((Control)this.table.getTable());
        this.table.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CommitGraphTable.this.allCommits != null) {
                    CommitGraphTable.this.allCommits.dispose();
                }
                hoverManager.dispose();
            }
        });
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        this.table.addDragSupport(17, transferTypes, (DragSourceListener)new CommitDragSourceListener());
    }

    CommitGraphTable(Composite parent, final IPageSite site, MenuManager menuMgr, TableLoader loader, ResourceManager resources) {
        this(parent, loader, resources);
        final IAction selectAll = this.createStandardAction(ActionFactory.SELECT_ALL);
        this.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                site.getActionBars().updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAll);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), CommitGraphTable.this.copy);
                site.getActionBars().updateActionBars();
            }
        });
        this.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Parameterization[] parms;
                if (CommitGraphTable.this.input == null || !CommitGraphTable.this.input.isSingleFile()) {
                    return;
                }
                ICommandService srv = CommonUtils.getService((IServiceLocator)site, ICommandService.class);
                IHandlerService hsrv = CommonUtils.getService((IServiceLocator)site, IHandlerService.class);
                Command cmd = srv.getCommand("org.eclipse.egit.ui.history.ShowVersions");
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    try {
                        IParameter parm = cmd.getParameter("org.eclipse.egit.ui.history.CompareMode");
                        parms = new Parameterization[]{new Parameterization(parm, Boolean.TRUE.toString())};
                    }
                    catch (NotDefinedException e) {
                        Activator.handleError(e.getMessage(), e, true);
                        parms = null;
                    }
                } else {
                    parms = null;
                }
                ParameterizedCommand pcmd = new ParameterizedCommand(cmd, parms);
                try {
                    hsrv.executeCommandInContext(pcmd, null, hsrv.getCurrentState());
                }
                catch (Exception e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        });
        Control c = this.getControl();
        menuMgr.add((IContributionItem)new Separator("additions"));
        c.setMenu(menuMgr.createContextMenu(c));
        this.menuListener = new MenuListener(menuMgr, (ISelectionProvider)this.getTableView(), site, this.copy);
        c.addMenuDetectListener((MenuDetectListener)this.menuListener);
    }

    Control getControl() {
        return this.table.getControl();
    }

    void selectCommitStored(RevCommit c) {
        this.commitToShow = c;
        this.selectCommit(c);
    }

    void selectCommit(RevCommit c) {
        if (c instanceof PlotCommit) {
            this.table.setSelection((ISelection)new StructuredSelection((Object)c), true);
        } else if (this.commitsMap != null) {
            PlotCommit swtCommit = this.commitsMap.get(c.getId().name());
            if (swtCommit == null && this.tableLoader != null) {
                this.tableLoader.loadCommit(c);
            }
            if (swtCommit != null) {
                this.table.setSelection((ISelection)new StructuredSelection((Object)swtCommit), true);
            }
        }
    }

    void addSelectionChangedListener(ISelectionChangedListener l) {
        this.table.addPostSelectionChangedListener(l);
    }

    void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.table.removePostSelectionChangedListener(l);
    }

    void setRelativeDate(boolean booleanValue) {
        this.graphLabelProvider.setRelativeDate(booleanValue);
    }

    void setShowEmailAddresses(boolean booleanValue) {
        this.graphLabelProvider.setShowEmailAddresses(booleanValue);
    }

    private boolean canDoCopy() {
        return !this.table.getSelection().isEmpty();
    }

    private void doCopy() {
        ISelection s = this.table.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            PlotCommit d = (PlotCommit)itr.next();
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(d.getId().name());
        }
        if (this.clipboard == null || this.clipboard.isDisposed()) {
            return;
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInput(RevFlag hFlag, SWTCommitList list, SWTCommit[] asArray, HistoryPageInput input, boolean keepPosition) {
        int topIndex = -1;
        if (keepPosition) {
            topIndex = this.table.getTable().getTopIndex();
        }
        this.setHistoryPageInput(input);
        SWTCommitList oldList = this.allCommits;
        if (oldList != null && oldList != list) {
            oldList.dispose();
        }
        this.highlight = hFlag;
        this.allCommits = list;
        int newAllCommitsLength = this.allCommits.size();
        this.table.setInput((Object)asArray);
        if (asArray != null && asArray.length > 0) {
            if (oldList != list || this.allCommitsLength < newAllCommitsLength) {
                this.initCommitsMap();
            }
        } else {
            this.table.getTable().deselectAll();
        }
        this.allCommitsLength = newAllCommitsLength;
        if (this.commitToShow != null) {
            this.selectCommit(this.commitToShow);
        }
        if (keepPosition) {
            this.table.getTable().setTopIndex(topIndex);
        }
    }

    void setHistoryPageInput(HistoryPageInput input) {
        this.input = input;
        if (this.menuListener != null) {
            this.menuListener.setInput(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCommitsMap() {
        this.commitsMap = new HashMap();
        SWTCommitList sWTCommitList = this.allCommits;
        synchronized (sWTCommitList) {
            Iterator iterator = this.allCommits.iterator();
            while (iterator.hasNext()) {
                PlotCommit commit = (PlotCommit)iterator.next();
                if (commit == null) continue;
                this.commitsMap.put(commit.getId().name(), commit);
            }
        }
    }

    private void createColumns(Table rawTable, TableLayout layout) {
        int minWidth;
        TableColumn commitId = new TableColumn(rawTable, 0);
        commitId.setResizable(true);
        commitId.setText(UIText.CommitGraphTable_CommitId);
        GC gc = new GC((Drawable)rawTable.getDisplay());
        try {
            gc.setFont(rawTable.getFont());
            minWidth = gc.stringExtent((String)"0000000").x + 5;
        }
        finally {
            gc.dispose();
        }
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn graph = new TableColumn(rawTable, 0);
        graph.setResizable(true);
        graph.setText(UIText.CommitGraphTable_messageColumn);
        graph.setWidth(400);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        TableColumn author = new TableColumn(rawTable, 0);
        author.setResizable(true);
        author.setText(UIText.HistoryPage_authorColumn);
        author.setWidth(100);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn date = new TableColumn(rawTable, 0);
        date.setResizable(true);
        date.setText(UIText.HistoryPage_authorDateColumn);
        date.setWidth(100);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn committer = new TableColumn(rawTable, 0);
        committer.setResizable(true);
        committer.setText(UIText.CommitGraphTable_Committer);
        committer.setWidth(100);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn committerDate = new TableColumn(rawTable, 0);
        committerDate.setResizable(true);
        committerDate.setText(UIText.CommitGraphTable_committerDataColumn);
        committerDate.setWidth(100);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
    }

    private void createPaintListener(Table rawTable) {
        rawTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index >= 0 && event.index <= 5) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        rawTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CommitGraphTable.this.doPaint(event);
            }
        });
    }

    void doPaint(Event event) {
        SWTCommitList.SWTLane lane;
        RevCommit c = (RevCommit)((TableItem)event.item).getData();
        if (c instanceof SWTCommit && (lane = (SWTCommitList.SWTLane)((SWTCommit)c).getLane()) != null && lane.color.isDisposed()) {
            return;
        }
        if (this.highlight != null && c.has(this.highlight)) {
            event.gc.setFont(this.hFont);
        } else {
            event.gc.setFont(this.nFont);
        }
        if (event.index == 1) {
            this.renderer.paint(event, this.input == null ? null : this.input.getHead());
            return;
        }
        ITableLabelProvider lbl = (ITableLabelProvider)this.table.getLabelProvider();
        String txt = lbl.getColumnText((Object)c, event.index);
        Point textsz = event.gc.textExtent(txt);
        int texty = (event.height - textsz.y) / 2;
        event.gc.drawString(txt, event.x, event.y + texty, true);
    }

    public TableViewer getTableView() {
        return this.table;
    }

    private IAction createStandardAction(final ActionFactory af) {
        final String text = af.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getText();
        Action action = new Action(){

            public String getActionDefinitionId() {
                return af.getCommandId();
            }

            public String getId() {
                return af.getId();
            }

            public String getText() {
                return text;
            }

            public void run() {
                if (af == ActionFactory.SELECT_ALL) {
                    CommitGraphTable.this.table.getTable().selectAll();
                }
                if (af == ActionFactory.COPY) {
                    CommitGraphTable.this.doCopy();
                }
            }
        };
        return action;
    }

    private final class CommitDragSourceListener
    extends DragSourceAdapter {
        private CommitDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            RevCommit commit = this.getSelectedCommit();
            event.doit = commit.getParentCount() == 1;
        }

        public void dragSetData(DragSourceEvent event) {
            boolean isFileTransfer = FileTransfer.getInstance().isSupportedType(event.dataType);
            boolean isTextTransfer = TextTransfer.getInstance().isSupportedType(event.dataType);
            if (isFileTransfer || isTextTransfer) {
                RevCommit commit = this.getSelectedCommit();
                String patchContent = this.createPatch(commit);
                if (isTextTransfer) {
                    event.data = patchContent;
                    return;
                }
                File patchFile = null;
                try {
                    try {
                        patchFile = this.createTempFile(commit);
                        this.writeToFile(patchFile.getAbsolutePath(), patchContent);
                        event.data = new String[]{patchFile.getAbsolutePath()};
                    }
                    catch (IOException e) {
                        Activator.logError(NLS.bind((String)UIText.CommitGraphTable_UnableToWritePatch, (Object)commit.getId().name()), e);
                        if (patchFile != null) {
                            patchFile.deleteOnExit();
                        }
                    }
                }
                finally {
                    if (patchFile != null) {
                        patchFile.deleteOnExit();
                    }
                }
            }
        }

        private File createTempFile(RevCommit commit) throws IOException {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String patchName = "egit-patch" + commit.getId().name();
            File patchDir = new File(tmpDir, patchName);
            int counter = 1;
            while (patchDir.exists()) {
                patchDir = new File(tmpDir, String.valueOf(patchName) + "_" + counter);
                ++counter;
            }
            FileUtils.mkdir((File)patchDir);
            patchDir.deleteOnExit();
            String suggestedFileName = CreatePatchOperation.suggestFileName((RevCommit)commit);
            File patchFile = new File(patchDir, suggestedFileName);
            return patchFile;
        }

        private String createPatch(RevCommit commit) {
            Repository repository = CommitGraphTable.this.input.getRepository();
            CreatePatchOperation operation = new CreatePatchOperation(repository, commit);
            operation.setHeaderFormat(CreatePatchOperation.DiffHeaderFormat.EMAIL);
            operation.setContextLines(3);
            try {
                operation.execute(null);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)UIText.CommitGraphTable_UnableToCreatePatch, (Object)commit.getId().name()), e);
            }
            String patchContent = operation.getPatchContent();
            return patchContent;
        }

        private RevCommit getSelectedCommit() {
            IStructuredSelection selection = (IStructuredSelection)CommitGraphTable.this.table.getSelection();
            RevCommit commit = (RevCommit)selection.getFirstElement();
            RevWalk walk = new RevWalk(CommitGraphTable.this.input.getRepository());
            try {
                RevCommit revCommit = walk.parseCommit((AnyObjectId)commit.getId());
                return revCommit;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse commit " + commit.getId(), e);
            }
            finally {
                walk.release();
            }
        }

        private void writeToFile(String fileName, String content) throws IOException {
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), RawParseUtils.UTF8_CHARSET));
            try {
                output.write(content);
            }
            finally {
                ((Writer)output).close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MenuListener
    implements MenuDetectListener {
        private final MenuManager popupMgr;
        private final ISelectionProvider selectionProvider;
        private final IPageSite site;
        private final IAction copyAction;
        private HistoryPageInput input;

        MenuListener(MenuManager menuManager, ISelectionProvider selectionProvider, IPageSite site, IAction copyAction) {
            this.popupMgr = menuManager;
            this.selectionProvider = selectionProvider;
            this.site = site;
            this.copyAction = copyAction;
        }

        public void setInput(HistoryPageInput input) {
            this.input = input;
        }

        public void menuDetected(MenuDetectEvent e) {
            this.popupMgr.removeAll();
            int selectionSize = ((IStructuredSelection)this.selectionProvider.getSelection()).size();
            if (this.input.isSingleFile()) {
                if (selectionSize == 1) {
                    if (this.input.getSingleFile() instanceof IResource) {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareWithWorkingTree", UIText.GitHistoryPage_CompareWithWorkingTreeMenuMenuLabel));
                    } else {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareWithWorkingTree", UIText.GitHistoryPage_CompareWithCurrentHeadMenu));
                    }
                }
                if (selectionSize > 0) {
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ShowVersions", UIText.GitHistoryPage_OpenMenuLabel));
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.OpenInTextEditorCommand", UIText.GitHistoryPage_OpenInTextEditorLabel));
                }
                if (selectionSize == 1) {
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ShowBlame", UIText.CommitFileDiffViewer_ShowAnnotationsMenuLabel));
                }
            }
            if (selectionSize > 0) {
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.OpenInCommitViewerCommand", UIText.CommitGraphTable_OpenCommitLabel));
            }
            if (selectionSize == 1) {
                this.popupMgr.add((IContributionItem)new Separator());
                if (!this.input.getRepository().isBare()) {
                    if (this.hasMultipleRefNodes()) {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CheckoutCommand", UIText.GitHistoryPage_CheckoutMenuLabel2));
                    } else {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CheckoutCommand", UIText.GitHistoryPage_CheckoutMenuLabel));
                    }
                }
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.PushCommit", UIText.GitHistoryPage_pushCommit));
                this.popupMgr.add((IContributionItem)new Separator());
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreateBranch", UIText.GitHistoryPage_CreateBranchMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.DeleteBranch", UIText.CommitGraphTable_DeleteBranchAction));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.RenameBranch", UIText.CommitGraphTable_RenameBranchMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreateTag", UIText.GitHistoryPage_CreateTagMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.DeleteTag", UIText.CommitGraphTable_DeleteTagAction));
                this.popupMgr.add((IContributionItem)new Separator());
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreatePatch", UIText.GitHistoryPage_CreatePatchMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Merge", UIText.GitHistoryPage_mergeMenuItem));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.RebaseCurrent", UIText.GitHistoryPage_rebaseMenuItem));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.RebaseInteractiveCurrent", UIText.GitHistoryPage_rebaseInteractiveMenuItem));
                this.popupMgr.add((IContributionItem)new Separator());
                MenuManager resetManager = ResetMenu.createMenu((IWorkbenchSite)this.site);
                this.popupMgr.add((IContributionItem)resetManager);
            } else if (selectionSize == 2) {
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareVersions", UIText.GitHistoryPage_CompareWithEachOtherMenuLabel));
                if (!this.input.isSingleFile()) {
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareVersionsInTree", UIText.CommitGraphTable_CompareWithEachOtherInTreeMenuLabel));
                }
            }
            this.popupMgr.add((IContributionItem)new Separator());
            this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CherryPick", UIText.GitHistoryPage_cherryPickMenuItem));
            this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Revert", UIText.GitHistoryPage_revertMenuItem));
            this.popupMgr.add((IContributionItem)new Separator());
            MenuManager quickDiffManager = new MenuManager(UIText.GitHistoryPage_QuickdiffMenuLabel, null, "Quickdiff");
            this.popupMgr.add((IContributionItem)quickDiffManager);
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.SetQuickdiffBaseline", UIText.GitHistoryPage_SetAsBaselineMenuLabel));
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.eclipse.egit.ui.history.ResetQuickdiffBaselineTarget", "HEAD");
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ResetQuickdiffBaseline", UIText.GitHistoryPage_ResetBaselineToHeadMenuLabel, parameters));
            parameters = new HashMap();
            parameters.put("org.eclipse.egit.ui.history.ResetQuickdiffBaselineTarget", "HEAD^1");
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ResetQuickdiffBaseline", UIText.GitHistoryPage_ResetBaselineToParentOfHeadMenuLabel, parameters));
            this.popupMgr.add((IContributionItem)new Separator());
            MenuManager modifyManager = new MenuManager(UIText.GitHistoryPage_ModifyMenuLabel, null, "Modify");
            this.popupMgr.add((IContributionItem)modifyManager);
            if (selectionSize == 1) {
                modifyManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Reword", UIText.GitHistoryPage_rewordMenuItem));
                modifyManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Edit", UIText.GitHistoryPage_editMenuItem));
            }
            if (selectionSize >= 2) {
                modifyManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Squash", UIText.GitHistoryPage_squashMenuItem));
            }
            this.popupMgr.add((IContributionItem)new Separator("additions"));
            this.popupMgr.add(this.copyAction);
            this.popupMgr.add((IContributionItem)new Separator());
        }

        private boolean hasMultipleRefNodes() {
            try {
                Map branches = this.input.getRepository().getRefDatabase().getRefs("refs/heads/");
                int count = 0;
                for (Ref branch : branches.values()) {
                    if (!branch.getLeaf().getObjectId().equals((AnyObjectId)((RevCommit)((IStructuredSelection)this.selectionProvider.getSelection()).getFirstElement()).getId())) continue;
                    ++count;
                }
                return count > 1;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        private CommandContributionItem getCommandContributionItem(String commandId, String menuLabel) {
            CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.site, commandId, commandId, 8);
            parameter.label = menuLabel;
            return new CommandContributionItem(parameter);
        }

        private CommandContributionItem getCommandContributionItem(String commandId, String menuLabel, Map<String, String> parameters) {
            CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.site, commandId, commandId, 8);
            parameter.label = menuLabel;
            parameter.parameters = parameters;
            return new CommandContributionItem(parameter);
        }
    }

    private static final class RefHoverInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private RefHoverInformationControlCreator() {
        }

        protected IInformationControl doCreateInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    }

    private final class RefHoverInformationControlManager
    extends AbstractHoverInformationControlManager {
        protected RefHoverInformationControlManager() {
            super((IInformationControlCreator)new RefHoverInformationControlCreator());
        }

        protected void computeInformation() {
            SWTCommit commit;
            MouseEvent e = this.getHoverEvent();
            TableItem item = CommitGraphTable.this.table.getTable().getItem(new Point(e.x, e.y));
            if (item != null && (commit = (SWTCommit)((Object)item.getData())) != null && commit.getRefCount() > 0) {
                Rectangle itemBounds = item.getBounds();
                int firstColumnWidth = CommitGraphTable.this.table.getTable().getColumn(0).getWidth();
                int relativeX = e.x - firstColumnWidth - itemBounds.x;
                int i = 0;
                while (i < commit.getRefCount()) {
                    Ref ref = commit.getRef(i);
                    Point textSpan = CommitGraphTable.this.renderer.getRefHSpan(ref);
                    if (textSpan != null && relativeX >= textSpan.x && relativeX <= textSpan.y) {
                        String hoverText = this.getHoverText(ref, i, commit);
                        int width = textSpan.y - textSpan.x;
                        Rectangle rectangle = new Rectangle(firstColumnWidth + itemBounds.x + textSpan.x, itemBounds.y, width, itemBounds.height);
                        this.setInformation(hoverText, rectangle);
                        return;
                    }
                    ++i;
                }
            }
            this.setInformation(null, null);
        }

        private String getHoverText(Ref ref, int refIndex, SWTCommit commit) {
            if (ref.getName().startsWith("refs/tags/") && CommitGraphTable.this.renderer.isShownAsEllipsis(ref)) {
                StringBuilder sb = new StringBuilder(UIText.CommitGraphTable_HoverAdditionalTags);
                int i = refIndex;
                while (i < commit.getRefCount()) {
                    Ref tag = commit.getRef(i);
                    String name = tag.getName();
                    if (name.startsWith("refs/tags/")) {
                        sb.append('\n');
                        sb.append(name.substring("refs/tags/".length()));
                    }
                    ++i;
                }
                return sb.toString();
            }
            return this.getHoverTextForSingleRef(ref);
        }

        private String getHoverTextForSingleRef(Ref r) {
            String description;
            StringBuilder sb = new StringBuilder();
            String name = r.getName();
            sb.append(name);
            if (r.isSymbolic()) {
                sb.append(": ");
                sb.append(r.getLeaf().getName());
            }
            if ((description = GitLabels.getRefDescription(r)) != null) {
                sb.append("\n");
                sb.append(description);
            }
            return sb.toString();
        }
    }
}

