/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoriesViewCommandHandler<T extends RepositoryTreeNode<?>>
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    protected final RepositoryUtil util = Activator.getDefault().getRepositoryUtil();

    RepositoriesViewCommandHandler() {
    }

    public RepositoriesView getView(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        return (RepositoriesView)part;
    }

    public Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = evaluationContext instanceof IEvaluationContext ? (IEvaluationContext)evaluationContext : null;
    }

    public List<T> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    protected List<T> getSelectedNodes() {
        if (this.evaluationContext != null) {
            Object selection = this.evaluationContext.getVariable("activeMenuSelection");
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                selection = this.evaluationContext.getVariable("selection");
            }
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).toList();
            }
        }
        return Collections.emptyList();
    }

    public Shell getActiveShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    private boolean repositoryHasHead(T treeNode) {
        Repository repo = ((RepositoryTreeNode)treeNode).getRepository();
        try {
            Ref ref = repo.getRef("HEAD");
            return ref != null && ref.getObjectId() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean selectionHasHead(boolean all) {
        List<T> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.size() > 0) {
            if (all) {
                for (RepositoryTreeNode element : selectedNodes) {
                    if (this.repositoryHasHead(element)) continue;
                    return false;
                }
                return true;
            }
            return this.repositoryHasHead((RepositoryTreeNode)selectedNodes.get(0));
        }
        return false;
    }

    protected boolean selectedRepositoryHasHead() {
        return this.selectionHasHead(false);
    }

    protected boolean selectedRepositoriesHaveHead() {
        return this.selectionHasHead(true);
    }

    protected boolean isWorkingDirSelection() {
        List<T> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.isEmpty()) {
            return false;
        }
        Repository repository = null;
        for (RepositoryTreeNode selectedNode : selectedNodes) {
            String path;
            Repository nodeRepository = selectedNode.getRepository();
            if (repository == null) {
                repository = nodeRepository;
            } else if (repository != nodeRepository) {
                return false;
            }
            if (selectedNode instanceof WorkingDirNode) continue;
            if (selectedNode instanceof FolderNode) {
                path = ((File)((FolderNode)selectedNode).getObject()).getAbsolutePath();
            } else if (selectedNode instanceof FileNode) {
                path = ((File)((FileNode)selectedNode).getObject()).getAbsolutePath();
            } else {
                return false;
            }
            if (!path.startsWith(repository.getDirectory().getAbsolutePath())) continue;
            return false;
        }
        return true;
    }

    protected Collection<IPath> getSelectedFileAndFolderPaths(ExecutionEvent event) throws ExecutionException {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (T selectedNode : this.getSelectedNodes(event)) {
            RepositoryTreeNode treeNode = (RepositoryTreeNode)selectedNode;
            IPath path = treeNode.getPath();
            paths.add(path);
        }
        return paths;
    }

    static <T> T getFirstOrNull(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

