/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextServletTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, ServletRegistration> {
    private ContextController contextController;

    public ContextServletTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public ServletRegistration addingService(ServiceReference<Servlet> serviceReference) {
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return null;
        }
        String contextSelector = (String)serviceReference.getProperty("osgi.http.whiteboard.context.select");
        if (!this.contextController.matches(contextSelector)) {
            return null;
        }
        Servlet servlet = (Servlet)this.bundleContext.getService(serviceReference);
        if (this.httpServiceRuntime.getRegisteredServlets().contains(servlet)) {
            return null;
        }
        boolean asyncSupported = this.parseBoolean(serviceReference, "osgi.http.whiteboard.servlet.asyncSupported");
        List<String> errorPageList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.servlet.errorPage"));
        String[] errorPages = errorPageList.toArray(new String[errorPageList.size()]);
        Map<String, String> initParams = this.parseInitParams(serviceReference, "servlet.init.");
        List<String> patternList = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern"));
        String[] patterns = patternList.toArray(new String[patternList.size()]);
        Long serviceId = (Long)serviceReference.getProperty("service.id");
        String servletName = this.parseName(serviceReference.getProperty("osgi.http.whiteboard.servlet.name"), servlet);
        try {
            return this.contextController.addServletRegistration(servlet, asyncSupported, errorPages, initParams, patterns, serviceId, servletName, false);
        }
        catch (ServletException se) {
            this.httpServiceRuntime.log(se.getMessage(), se);
            return null;
        }
    }

    public void modifiedService(ServiceReference<Servlet> serviceReference, ServletRegistration servletRegistration) {
    }

    public void removedService(ServiceReference<Servlet> serviceReference, ServletRegistration servletRegistration) {
        this.bundleContext.ungetService(serviceReference);
        servletRegistration.destroy();
    }
}

