/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.LazyStartHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class AddActivationHeaderResolution
extends AbstractManifestMarkerResolution {
    String fHeader = null;

    public AddActivationHeaderResolution(int type, String currentHeader) {
        super(type);
        this.fHeader = currentHeader;
    }

    @Override
    protected void createChange(BundleModel model) {
        IBundle bundle = model.getBundle();
        IManifestHeader header = bundle.getManifestHeader(this.fHeader);
        if (header instanceof LazyStartHeader) {
            LazyStartHeader lheader = (LazyStartHeader)header;
            String exceptions = lheader.getAttribute("exceptions");
            if (TargetPlatformHelper.getTargetVersion() >= 3.4) {
                bundle.setHeader("Bundle-ActivationPolicy", "lazy");
                if (exceptions != null) {
                    LazyStartHeader newHeader = (LazyStartHeader)bundle.getManifestHeader("Bundle-ActivationPolicy");
                    String directive = lheader.isLazyStart() ? "exclude" : "include";
                    newHeader.setDirective(directive, exceptions);
                }
            } else {
                bundle.setHeader("Eclipse-LazyStart", Boolean.toString(lheader.isLazyStart()));
                if (exceptions != null) {
                    lheader = (LazyStartHeader)bundle.getManifestHeader("Eclipse-LazyStart");
                    lheader.setAttribute("exceptions", exceptions);
                }
            }
        }
    }

    public String getLabel() {
        String header = TargetPlatformHelper.getTargetVersion() >= 3.4 ? "Bundle-ActivationPolicy" : "Eclipse-LazyStart";
        return NLS.bind((String)PDEUIMessages.AddActivationHeaderResolution_label, (Object)header);
    }
}

