/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7UpdateSiteExtensions;
import org.eclipse.rcptt.launching.ext.AUTInformation;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.osgi.framework.Bundle;

public class Q7TargetPlatformInitializer {
    private static final String GMF = "gmf";
    private static final String DRAW2D = "draw2d";
    private static final String GEF = "gef";
    private static final String EMF_FEATURE_GROUP = "org.eclipse.emf.feature.group";
    private static final String EMF_VALIDATION_FEATURE_GROUP = "org.eclipse.emf.validation.feature.group";
    private static final String EMF_TRANSACTION_FEATURE_GROUP = "org.eclipse.emf.transaction.feature.group";
    private static final String EMF_WORKSPACE_FEATURE_GROUP = "org.eclipse.emf.workspace.feature.group";
    public static final String P2_GROUP_FEATURE = "org.eclipse.equinox.p2.type.group";
    public static final String P2_CATEGORY_FEATURE = "org.eclipse.equinox.p2.type.category";

    private static final IStatus createError(String message) {
        return Q7TargetPlatformInitializer.createError(message, null);
    }

    private static final IStatus createError(String message, Throwable error) {
        if (message == null && error != null) {
            message = error.getMessage();
        }
        return new Status(4, "org.eclipse.rcptt.launching.ext", message, error);
    }

    public static IStatus initialize(ITargetPlatformHelper iinfo, IProgressMonitor monitor) {
        monitor.beginTask("Initialize AUT configuration", 100);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IStatus rv = iinfo.getStatus();
        if (rv.matches(12)) {
            return rv;
        }
        TargetPlatformHelper info = (TargetPlatformHelper)iinfo;
        Map<String, String> map = AUTInformation.getInformationMap(iinfo);
        String version = map.get("Version");
        if (version == null) {
            return Q7TargetPlatformInitializer.createError("Invalid eclipse product location: " + iinfo.getTargetPlatformProfilePath());
        }
        List<Q7UpdateSiteExtensions.Q7RuntimeInfo> updates = Q7UpdateSiteExtensions.getDefault().getRuntimes(version);
        if (updates.size() == 0) {
            return Q7TargetPlatformInitializer.createError("Eclipse platform version " + version + " is not supported");
        }
        Q7Info q7Info = Q7TargetPlatformInitializer.collectQ7Information(updates);
        if (q7Info.q7 == null || q7Info.deps == null || q7Info.aspectj == null) {
            return Q7TargetPlatformInitializer.createError("Eclipse platform version " + version + " is not supported");
        }
        monitor.worked(20);
        try {
            IMetadataRepository repository = PDEHelper.safeLoadRepository(q7Info.q7, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            if (repository == null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Q7TargetPlatformInitializer.createError("Failed to load repository from " + q7Info.q7);
            }
            InjectionConfiguration injectionConfiguration = Q7TargetPlatformInitializer.createInjectionConfiguration((IProgressMonitor)new NullProgressMonitor(), q7Info, map, repository);
            MultiStatus rv2 = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Runtime injection failed for target platform " + iinfo, null);
            if (injectionConfiguration != null) {
                rv2.add(info.applyInjection(injectionConfiguration, (IProgressMonitor)new SubProgressMonitor(monitor, 60)));
                if (rv2.matches(8)) {
                    return rv2;
                }
            }
            if (!rv2.isOK()) {
                return rv2;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public static InjectionConfiguration createInjectionConfiguration(IProgressMonitor monitor, Q7Info q7Info, Map<String, String> map, IMetadataRepository repository) {
        boolean hasEMF = map.containsKey("EMF");
        boolean hasEMFWorkspace = map.containsKey("EMF Workspace");
        boolean hasEMFTransaction = map.containsKey("EMF Transaction");
        boolean hasEMFValidation = map.containsKey("EMF Validation");
        map.containsKey("GMF");
        InjectionConfiguration injectionConfiguration = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        UpdateSite q7Site = InjectionFactory.eINSTANCE.createUpdateSite();
        q7Site.setUri(q7Info.q7.toString());
        injectionConfiguration.getEntries().add((Object)q7Site);
        UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
        aspectsSite.setUri(q7Info.aspectj.toString());
        injectionConfiguration.getEntries().add((Object)aspectsSite);
        UpdateSite q7Deps = InjectionFactory.eINSTANCE.createUpdateSite();
        q7Deps.setUri(q7Info.deps.toString());
        if (!(hasEMF && hasEMFWorkspace && hasEMFTransaction && hasEMFValidation)) {
            if (!hasEMFWorkspace) {
                q7Deps.getUnits().add((Object)EMF_WORKSPACE_FEATURE_GROUP);
            }
            if (!hasEMFTransaction) {
                q7Deps.getUnits().add((Object)EMF_TRANSACTION_FEATURE_GROUP);
            }
            if (!hasEMFValidation) {
                q7Deps.getUnits().add((Object)EMF_VALIDATION_FEATURE_GROUP);
            }
            if (!hasEMF) {
                q7Deps.getUnits().add((Object)EMF_FEATURE_GROUP);
            }
        }
        injectionConfiguration.getEntries().add((Object)q7Deps);
        for (URI extraURI : q7Info.extra) {
            if (monitor.isCanceled()) {
                return null;
            }
            UpdateSite site = InjectionFactory.eINSTANCE.createUpdateSite();
            site.setUri(extraURI.toString());
            site.setAllUnits(true);
            injectionConfiguration.getEntries().add((Object)site);
        }
        return injectionConfiguration;
    }

    private static List<String> collectQ7InstallIDs(IProgressMonitor monitor, boolean hasGEF, boolean hasGMF, IMetadataRepository repository) {
        IQueryResult result = repository.query(QueryUtil.ALL_UNITS, monitor);
        ArrayList<String> q7Units = new ArrayList<String>();
        for (IInstallableUnit unit : result.toSet()) {
            if (Q7TargetPlatformInitializer.hasProperty(unit, P2_GROUP_FEATURE, "true") || Q7TargetPlatformInitializer.hasProperty(unit, P2_CATEGORY_FEATURE, "true")) continue;
            String unitId = unit.getId();
            if (!hasGEF && (unitId.contains(GEF) || unitId.contains(DRAW2D) || unitId.contains(GMF)) || !hasGMF && unitId.contains(GMF)) continue;
            q7Units.add(unitId);
        }
        return q7Units;
    }

    public static void logError(TargetPlatformHelper info) {
        Q7ExtLaunchingPlugin.log((IStatus)new MultiStatus("org.eclipse.rcptt.launching.ext", 0, new IStatus[]{info.getStatus()}, "Target platform initialization error", null));
    }

    public static Q7Info getInfo(ITargetPlatformHelper info) {
        Map<String, String> map = AUTInformation.getInformationMap(info);
        String version = map.get("Version");
        List<Q7UpdateSiteExtensions.Q7RuntimeInfo> updates = Q7UpdateSiteExtensions.getDefault().getRuntimes(version);
        if (updates.size() == 0) {
            return null;
        }
        return Q7TargetPlatformInitializer.collectQ7Information(updates);
    }

    public static Q7Info collectQ7Information(List<Q7UpdateSiteExtensions.Q7RuntimeInfo> updates) {
        Q7Info q7Info = new Q7Info();
        for (Q7UpdateSiteExtensions.Q7RuntimeInfo q7RuntimeInfo : updates) {
            Bundle bundleItem = Platform.getBundle((String)q7RuntimeInfo.bundle);
            URL entry = null;
            if (q7RuntimeInfo.path != null && q7RuntimeInfo.path.trim().length() > 0) {
                entry = bundleItem.getEntry(new Path(q7RuntimeInfo.path).toString());
            }
            if (entry == null) {
                try {
                    entry = new URL(q7RuntimeInfo.path);
                }
                catch (MalformedURLException e) {
                    Q7ExtLaunchingPlugin.getDefault().log(e);
                }
            }
            if (entry == null) {
                Q7ExtLaunchingPlugin.getDefault().log("Failed to locate entry for Q7Runtime:" + bundleItem.getBundleId() + " path:" + q7RuntimeInfo.path, null);
                continue;
            }
            if ("runtime".equals(q7RuntimeInfo.kind)) {
                q7Info.q7 = Q7TargetPlatformInitializer.safeToURI(entry);
                continue;
            }
            if ("dependency".equals(q7RuntimeInfo.kind)) {
                q7Info.deps = Q7TargetPlatformInitializer.safeToURI(entry);
                continue;
            }
            if ("extra".equals(q7RuntimeInfo.kind)) {
                q7Info.extra.add(Q7TargetPlatformInitializer.safeToURI(entry));
                continue;
            }
            if (!"aspectj".equals(q7RuntimeInfo.kind)) continue;
            q7Info.aspectj = Q7TargetPlatformInitializer.safeToURI(entry);
        }
        return q7Info;
    }

    private static URI safeToURI(URL q7Entry) {
        URI q7 = null;
        try {
            q7 = q7Entry.toURI();
        }
        catch (URISyntaxException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        return q7;
    }

    public static boolean hasProperty(IInstallableUnit unit, String prop, String value) {
        return unit.getProperties().containsKey(prop) && ((String)unit.getProperties().get(prop)).equals(value);
    }

    public static InjectionConfiguration getAspectJInjection(ITargetPlatformHelper targetPlatform, IProgressMonitor progressMonitor) {
        Q7Info q7Info;
        Map<String, String> map = AUTInformation.getInformationMap(targetPlatform);
        String version = map.get("Version");
        List<Q7UpdateSiteExtensions.Q7RuntimeInfo> updates = Q7UpdateSiteExtensions.getDefault().getRuntimes(version);
        if (updates.isEmpty()) {
            throw new RuntimeException("Failed to find built-in injections for " + version);
        }
        InjectionConfiguration injectionConfiguration = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        if (updates != null && (q7Info = Q7TargetPlatformInitializer.collectQ7Information(updates)) != null) {
            UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
            aspectsSite.setUri(q7Info.aspectj.toString());
            injectionConfiguration.getEntries().add((Object)aspectsSite);
        }
        return injectionConfiguration;
    }

    public static class Q7Info {
        public URI q7;
        public URI aspectj;
        public URI deps;
        public List<URI> extra = new ArrayList<URI>();
    }
}

