/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.report.internal.ReportDetailsComposite;
import org.eclipse.rcptt.ui.report.internal.TestCaseComposite;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.forms.widgets.FormImages;

public class ReportPage
extends FormPage {
    DataBindingContext dbc = new DataBindingContext();
    private Label nameLabel;
    private Text nameText;
    private Report report;

    public ReportPage(FormEditor editor, String id, String title, Report report) {
        super(editor, id, title);
        this.report = report;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).equalWidth(true).applyTo(parent);
        this.createGeneralContent(parent, toolkit);
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).equalWidth(false).applyTo(composite);
        SashForm composite2 = new SashForm(composite, 65792);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(0, 0).equalWidth(true).applyTo((Composite)composite2);
        final ReportDetailsComposite detailsComposite = new ReportDetailsComposite(this.report);
        new SectionWithToolbar((IEmbeddedComposite)new TestCaseComposite(this.report){

            @Override
            protected void doNodesSelection(List<Node> nodes) {
                detailsComposite.update(nodes);
            }
        }, 256).create((Composite)composite2, toolkit);
        new SectionWithToolbar((IEmbeddedComposite)detailsComposite, 256).create((Composite)composite2, toolkit);
        composite2.setWeights(new int[]{40, 60});
    }

    protected Composite createGeneralContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)composite);
        this.createNameControl(composite, toolkit);
        int height = composite.computeSize((int)-1, (int)-1).y;
        Color top = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        Color bot = toolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        Image gradientImage = FormImages.getInstance().getGradient(new Color[]{top, bot}, new int[]{100}, height, true, toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"), composite.getDisplay());
        composite.setBackgroundImage(gradientImage);
        Composite c1 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c1);
        c1.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
        Composite c2 = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().hint(-1, 1).span(4, 1).grab(true, false).applyTo((Control)c2);
        c2.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
        if (!Platform.getOS().equals("macosx")) {
            composite.layout();
            this.setBackgroundToHeaderLabel(this.nameLabel, gradientImage);
        }
        return composite;
    }

    protected void setBackgroundToHeaderLabel(Label label, Image backgroundImage) {
        Rectangle bounds = label.getBounds();
        bounds.x = 0;
        bounds.width = 1;
        final Image image = new Image((Device)label.getDisplay(), bounds);
        GC gc = new GC((Drawable)image);
        gc.drawImage(backgroundImage, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, bounds.width, bounds.height);
        gc.dispose();
        label.setBackgroundImage(image);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    protected void createNameControl(Composite parent, FormToolkit toolkit) {
        this.nameLabel = this.createLabel(parent, toolkit, "Name:");
        this.nameText = this.createWrappedText(parent, toolkit, this.report.getRoot().getName(), 2);
        this.nameText.setEditable(false);
        this.nameText.setBackground(null);
    }

    protected Label createLabel(Composite parent, FormToolkit toolkit, String label) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)labelControl);
        labelControl.setBackground(null);
        return labelControl;
    }

    protected Text createWrappedText(Composite parent, FormToolkit toolkit, String text, int hSpan) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).span(hSpan, 1).grab(true, false).applyTo((Control)composite);
        Text textControl = toolkit.createText(composite, text, 2048);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(111, -1).applyTo((Control)textControl);
        textControl.setBackground(null);
        return textControl;
    }
}

