/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.main;

import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.recording.CommandSet;
import org.eclipse.rcptt.core.recording.IRecordingListener;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7InternalTestCase;
import org.eclipse.rcptt.internal.launching.EclStackTrace;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.controls.ContextsTable;
import org.eclipse.rcptt.ui.controls.DescriptionComposite;
import org.eclipse.rcptt.ui.controls.EmbeddedTabFolder;
import org.eclipse.rcptt.ui.controls.OptionsComposite;
import org.eclipse.rcptt.ui.controls.ScriptComposite;
import org.eclipse.rcptt.ui.controls.StatusBarComposite;
import org.eclipse.rcptt.ui.controls.VerificationsTable;
import org.eclipse.rcptt.ui.dialogs.DialogUtil;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.panels.ActionMenuCreator;
import org.eclipse.rcptt.ui.panels.Actions;
import org.eclipse.rcptt.ui.panels.assertion.AssertionPanelWindow;
import org.eclipse.rcptt.ui.recording.RecordingContextManager;
import org.eclipse.rcptt.ui.recording.RecordingSupport;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ControlPanelWindow
extends Dialog {
    private static final String SETTINGS_KEY = "ControlPanelWindow";
    private final DataBindingContext dbc = new DataBindingContext();
    private final RecordingSupport recordingSupport;
    private final Shell parentShell;
    private final Scenario scenario = ScenarioFactory.eINSTANCE.createScenario();
    private final WritableValue testCase = new WritableValue(null, ITestCase.class);
    private AssertionPanelWindow assertionWindow;
    private EmbeddedTabFolder tabFolder;
    private CoolBar coolBar;
    private StatusBarComposite statusBar;
    private ContextsTable contextsTable;
    private final ShellAdapter closeListener = new ParentShellCloseListener();
    private final Listener keyListener = new RecordingShortcutListener();
    private VerificationsTable verificationsTable;
    private static ControlPanelWindow window;
    private final ComputedValue modeEnablementObservable = new ComputedValue(Boolean.TYPE){

        protected Object calculate() {
            RecordingSupport.RecordingMode mode = ControlPanelWindow.this.recordingSupport.getMode();
            if (mode != RecordingSupport.RecordingMode.Stopped && mode != RecordingSupport.RecordingMode.Replaying && mode != RecordingSupport.RecordingMode.Connecting) {
                return true;
            }
            return false;
        }
    };
    private CTabItem script;
    private ScriptComposite scriptPart;

    public static synchronized ControlPanelWindow openControlPanel(Shell parentShell, ITestCase testCase) throws ModelException {
        if (window != null && window.getShell() != null && !window.getShell().isDisposed() && !window.close()) {
            return null;
        }
        window = new ControlPanelWindow(parentShell, testCase);
        window.setBlockOnOpen(false);
        window.open();
        return window;
    }

    public static synchronized ControlPanelWindow getOpenedControlPanel() {
        if (window != null && window.getShell() != null && !window.getShell().isDisposed()) {
            return window;
        }
        return null;
    }

    private ControlPanelWindow(Shell parentShell, ITestCase testCase) throws ModelException {
        super(null);
        this.parentShell = parentShell;
        this.setShellStyle(80);
        if (testCase != null) {
            this.setModel(testCase);
            this.copyContent((Scenario)testCase.getNamedElement(), this.scenario);
        }
        this.recordingSupport = new RecordingSupport(this, this.scenario, testCase != null ? (Scenario)testCase.getNamedElement() : null);
        this.recordingSupport.observeMode().addChangeListener((IChangeListener)new RecordingModeListener());
        this.recordingSupport.addRecordingListener(new AssertAddedListener());
    }

    public RecordingSupport getRecordingSupport() {
        return this.recordingSupport;
    }

    private ITestCase getModel() {
        return (ITestCase)this.testCase.getValue();
    }

    private void setModel(ITestCase value) {
        this.testCase.setValue((Object)value);
    }

    public Shell getParentShell() {
        return null;
    }

    public int open() {
        int result = super.open();
        this.parentShell.setMinimized(true);
        this.getShell().setVisible(true);
        this.recordingSupport.setMode(RecordingSupport.RecordingMode.Connecting);
        return result;
    }

    protected Control createContents(Composite parent) {
        Q7UIPlugin.getDisplay().addFilter(2, this.keyListener);
        this.createToolBar(parent);
        this.createTabFolder(parent);
        ITestCase model = this.getModel();
        Q7InternalTestCase internalModel = new Q7InternalTestCase((Q7Element)ModelManager.getModelManager().getModel(), "recording_snippet", this.scenario);
        this.scriptPart = new ScriptComposite(internalModel, model != null ? (IFile)this.getModel().getResource() : null, this.getShell(), 16777300);
        ComputedValue recordingMode = new ComputedValue(){

            protected Object calculate() {
                return ControlPanelWindow.this.recordingSupport.getMode();
            }
        };
        this.dbc.bindValue(this.scriptPart.observeRecordingMode(), (IObservableValue)recordingMode);
        this.script = this.tabFolder.addTab(this.scriptPart);
        try {
            this.contextsTable = new ContextsTable((ITestCase)internalModel);
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.contextsTable.setProject(this.getSavedProject());
        this.dbc.bindValue(this.contextsTable.observeRecordingMode(), (IObservableValue)recordingMode);
        this.tabFolder.addTab(this.contextsTable);
        try {
            this.verificationsTable = new VerificationsTable((ITestCase)internalModel);
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.verificationsTable.setProject(this.getSavedProject());
        this.dbc.bindValue(this.verificationsTable.observeRecordingMode(), (IObservableValue)recordingMode);
        this.tabFolder.addTab(this.verificationsTable);
        DescriptionComposite descPart = new DescriptionComposite((NamedElement)this.scenario);
        this.dbc.bindValue(descPart.observeRecordingMode(), (IObservableValue)recordingMode);
        this.tabFolder.addTab(descPart);
        OptionsComposite optionsComposite = new OptionsComposite();
        this.tabFolder.addTab(optionsComposite);
        optionsComposite.setOptionChangeCallback(new Runnable(){

            @Override
            public void run() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Recording) {
                    ControlPanelWindow.this.recordingSupport.sendFeatures();
                }
            }
        });
        this.selectTab(this.script);
        this.statusBar = new StatusBarComposite(){

            @Override
            protected void layout() {
                super.layout();
                ControlPanelWindow.this.tabFolder.layout(true);
            }

            @Override
            protected void handleError(String taskMessage, Throwable e) {
                IStatus status;
                if (e instanceof CoreException && (e.getMessage().equals("Connection reset") || e.getMessage().equals("Connection refused: connect"))) {
                    return;
                }
                if (e instanceof CoreException && (status = ((CoreException)e).getStatus()) instanceof ExecutionStatus && PlatformUI.isWorkbenchRunning()) {
                    WorkbenchUtils.uiRun(new Runnable(){

                        @Override
                        public void run() {
                            ControlPanelWindow.this.displayExecutionFailure((ExecutionStatus)status);
                        }
                    });
                    return;
                }
                super.handleError(taskMessage, e);
            }
        };
        this.statusBar.createControl(parent);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.getShell()), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                AutLaunch aut;
                StringBuilder text = new StringBuilder(Messages.ControlPanelWindow_Title);
                ITestCase model = ControlPanelWindow.this.getModel();
                if (model != null && model.exists()) {
                    try {
                        text.append(" - ").append(model.getElementName());
                        text.append(" (").append(model.getQ7Project().getName()).append(")");
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log(e);
                    }
                }
                if ((aut = ControlPanelWindow.this.recordingSupport.getAUT()) != null) {
                    text.append(" - ").append(aut.getAut().getName());
                }
                switch (ControlPanelWindow.this.recordingSupport.getMode()) {
                    case Connecting: {
                        text.append(Messages.ControlPanelWindow_StatusConnection);
                        break;
                    }
                    case Recording: {
                        text.append(Messages.ControlPanelWindow_StatusRecording);
                        break;
                    }
                    case Asserting: {
                        text.append(Messages.ControlPanelWindow_StatusAsserting);
                        break;
                    }
                    case ImageRecognition: {
                        text.append(Messages.ControlPanelWindow_StatusImageRecognition);
                        break;
                    }
                    case Replaying: {
                        text.append(Messages.ControlPanelWindow_StatusReplaying);
                        break;
                    }
                    case WaitingForAUTRestart: {
                        text.append(Messages.ControlPanelWindow_StatusWaitingAUTToRestart);
                        break;
                    }
                }
                return text.toString();
            }
        });
        this.tabFolder.setFocus();
        return this.tabFolder;
    }

    private void displayExecutionFailure(ExecutionStatus status) {
        if (ExecutionErrorDialog.showExecutionError(this.getShell(), status)) {
            this.selectTab(this.script);
            EclSourceViewer viewer = this.scriptPart.getViewer();
            int line = status.getLine();
            int length = status.getLength();
            int column = status.getColumn();
            BlockTextSelection selection = new BlockTextSelection(viewer.getDocument(), line - 1, column - 1, line - 1, column + length - 1, 0);
            viewer.setSelection((ISelection)selection, true);
        }
    }

    private CTabFolder createTabFolder(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).applyTo(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        this.tabFolder = new EmbeddedTabFolder(body, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tabFolder);
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        int minimumCharacters = store.getInt("VIEW_MINIMUM_CHARACTERS");
        if (minimumCharacters >= 0) {
            this.tabFolder.setMinimumCharacters(minimumCharacters);
        }
        this.tabFolder.setUnselectedCloseVisible(false);
        this.tabFolder.setUnselectedImageVisible(true);
        final Color c1 = new Color((Device)Display.getCurrent(), 232, 238, 244);
        final Color c2 = new Color((Device)Display.getCurrent(), 153, 180, 209);
        EmbeddedTabFolder control = this.tabFolder;
        control.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                c1.dispose();
                c2.dispose();
            }
        });
        return this.tabFolder;
    }

    private void createToolBar(Composite parent) {
        Composite toolbarComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(toolbarComposite);
        toolbarComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        CoolBarManager coolBarManager = new CoolBarManager(0x800100);
        ToolBarManager manager = new ToolBarManager(0x800100);
        Action homeAction = new Action(){

            public void run() {
                ControlPanelWindow.this.close();
            }
        };
        homeAction.setToolTipText(Messages.ControlPanelWindow_ReturnActionTooltip);
        homeAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/home.gif"));
        manager.add((IAction)homeAction);
        Action saveAction = new Action(){

            public void run() {
                if (ControlPanelWindow.this.getModel() != null) {
                    ControlPanelWindow.this.save();
                } else {
                    ControlPanelWindow.this.saveAs();
                }
            }
        };
        saveAction.setMenuCreator((IMenuCreator)new ActionMenuCreator(){

            @Override
            protected void fill(MenuManager manager) {
                manager.add((IAction)new Action(Messages.ControlPanelWindow_SaveAction){
                    {
                        ControlPanelWindow.this.dbc.bindValue(Actions.observeEnabled((IAction)this), (IObservableValue)new ComputedValue(){

                            protected Object calculate() {
                                if (ControlPanelWindow.this.getModel() != null) {
                                    return true;
                                }
                                return false;
                            }
                        });
                    }

                    public void run() {
                        ControlPanelWindow.this.save();
                    }
                });
                manager.add((IAction)new Action(Messages.ControlPanelWindow_SaveAsAction){

                    public void run() {
                        ControlPanelWindow.this.saveAs();
                    }
                });
            }
        });
        this.dbc.bindValue(Actions.observeToolTipText((IAction)saveAction), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                if (ControlPanelWindow.this.getModel() != null) {
                    return Messages.ControlPanelWindow_SaveAction;
                }
                return Messages.ControlPanelWindow_SaveAsAction;
            }
        });
        ISharedImages sharedImages = WorkbenchPlugin.getDefault().getSharedImages();
        saveAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        saveAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        manager.add((IAction)saveAction);
        coolBarManager.add((IToolBarManager)manager);
        manager = new ToolBarManager(0x800100);
        manager.add(this.createRecordAction());
        manager.add(this.createReplayAction());
        coolBarManager.add((IToolBarManager)manager);
        manager = new ToolBarManager(0x800100);
        manager.add(this.createRecordingModeAction());
        manager.add(this.createAssertingModeAction());
        if (Q7UIPlugin.isImageRecognitionAllowed()) {
            manager.add(this.createImageRecognitionModeAction());
        }
        coolBarManager.add((IToolBarManager)manager);
        this.coolBar = coolBarManager.createControl(toolbarComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.coolBar);
        this.coolBar.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ControlPanelWindow.this.getShell().layout();
            }
        });
    }

    private IAction createReplayAction() {
        Action action = new Action(){

            public void run() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Stopped) {
                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Replaying);
                } else {
                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Stopped);
                }
            }
        };
        this.dbc.bindValue(Actions.observeEnabled((IAction)action), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                RecordingSupport.RecordingMode mode = ControlPanelWindow.this.recordingSupport.getMode();
                if (mode != RecordingSupport.RecordingMode.Stopped && mode != RecordingSupport.RecordingMode.Replaying) {
                    return false;
                }
                return true;
            }
        });
        this.dbc.bindValue(Actions.observeImageDescriptor((IAction)action), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Replaying) {
                    return Images.getImageDescriptor("icons/recording/stop.gif");
                }
                return Images.getImageDescriptor("icons/recording/play.gif");
            }
        });
        this.dbc.bindValue(Actions.observeToolTipText((IAction)action), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Replaying) {
                    return Messages.ControlPanelWindow_StopAction;
                }
                return Messages.ControlPanelWindow_ReplayAction;
            }
        });
        return action;
    }

    private IAction createRecordAction() {
        Action action = new Action(){

            public void run() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Stopped) {
                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Connecting);
                } else {
                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Stopped);
                }
            }
        };
        this.dbc.bindValue(Actions.observeEnabled((IAction)action), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                RecordingSupport.RecordingMode mode = ControlPanelWindow.this.recordingSupport.getMode();
                if (mode != RecordingSupport.RecordingMode.Stopped && mode == RecordingSupport.RecordingMode.Replaying) {
                    return false;
                }
                return true;
            }
        });
        this.dbc.bindValue(Actions.observeImageDescriptor((IAction)action), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                RecordingSupport.RecordingMode mode = ControlPanelWindow.this.recordingSupport.getMode();
                if (mode == RecordingSupport.RecordingMode.Stopped || mode == RecordingSupport.RecordingMode.Replaying) {
                    return Images.getImageDescriptor("icons/recording/record.gif");
                }
                return Images.getImageDescriptor("icons/recording/stop.gif");
            }
        });
        this.dbc.bindValue(Actions.observeToolTipText((IAction)action), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                RecordingSupport.RecordingMode mode = ControlPanelWindow.this.recordingSupport.getMode();
                if (mode == RecordingSupport.RecordingMode.Recording || mode == RecordingSupport.RecordingMode.Connecting) {
                    return Messages.ControlPanelWindow_StopAction;
                }
                return Messages.ControlPanelWindow_RecordAction;
            }
        });
        return action;
    }

    private IAction createRecordingModeAction() {
        Action action = new Action("", 8){

            public void run() {
                ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Recording);
            }
        };
        action.setImageDescriptor(Images.getImageDescriptor("icons/panel/mode_click.gif"));
        action.setToolTipText(Messages.ControlPanelWindow_SwitchToRecordModeActionToolTip);
        this.dbc.bindValue(Actions.observeEnabled((IAction)action), (IObservableValue)this.modeEnablementObservable);
        this.dbc.bindValue(Actions.observeChecked((IAction)action), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Recording) {
                    return true;
                }
                return false;
            }
        });
        return action;
    }

    private IAction createAssertingModeAction() {
        Action action = new Action("", 8){

            public void run() {
                ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Asserting);
            }
        };
        action.setImageDescriptor(Images.getImageDescriptor("icons/panel/mode_assert.gif"));
        action.setToolTipText(Messages.ControlPanelWindow_SwitchToAssertModeActionToolTip);
        this.dbc.bindValue(Actions.observeEnabled((IAction)action), (IObservableValue)this.modeEnablementObservable);
        this.dbc.bindValue(Actions.observeChecked((IAction)action), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.Asserting) {
                    return true;
                }
                return false;
            }
        });
        return action;
    }

    private IAction createImageRecognitionModeAction() {
        Action action = new Action("", 8){

            public void run() {
                ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.ImageRecognition);
            }
        };
        action.setImageDescriptor(Images.getImageDescriptor("icons/panel/mode_iml.png"));
        action.setToolTipText(Messages.ControlPanelWindow_SwitchToRecognitionModeActionToolTip);
        this.dbc.bindValue(Actions.observeEnabled((IAction)action), (IObservableValue)this.modeEnablementObservable);
        this.dbc.bindValue(Actions.observeChecked((IAction)action), (IObservableValue)new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                if (ControlPanelWindow.this.recordingSupport.getMode() == RecordingSupport.RecordingMode.ImageRecognition) {
                    return true;
                }
                return false;
            }
        });
        return action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDirty() {
        String content;
        ITestCase model = this.getModel();
        if (model != null && model.exists()) {
            try {
                String desc;
                String savedDesc;
                Scenario saved = (Scenario)model.getNamedElement();
                if (saved == null) {
                    return model.hasUnsavedChanges();
                }
                if (!EcoreUtil.equals((EObject)saved.getContent(), (EObject)this.scenario.getContent())) {
                    return true;
                }
                if (saved.getContent() == null && !EcoreUtil.equals((EObject)saved.getTeslaContent(), (EObject)this.scenario.getTeslaContent())) {
                    return true;
                }
                if (saved.getContexts().size() != this.scenario.getContexts().size()) {
                    return true;
                }
                int size = saved.getContexts().size();
                int i = 0;
                while (true) {
                    if (i >= size) {
                        if (saved.getVerifications().size() == this.scenario.getVerifications().size()) break;
                        return true;
                    }
                    if (!((String)saved.getContexts().get(i)).equals(this.scenario.getContexts().get(i))) {
                        return true;
                    }
                    ++i;
                }
                size = saved.getVerifications().size();
                i = 0;
                while (true) {
                    if (i >= size) {
                        savedDesc = saved.getDescription();
                        desc = this.scenario.getDescription();
                        if (savedDesc != null || desc == null) break;
                        return true;
                    }
                    if (!((String)saved.getVerifications().get(i)).equals(this.scenario.getVerifications().get(i))) {
                        return true;
                    }
                    ++i;
                }
                return savedDesc != null && !savedDesc.equals(desc);
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        }
        return (content = Scenarios.getScriptContent((Scenario)this.scenario)) != null && content.length() > 0;
    }

    private IProject getSavedProject() {
        ITestCase model = this.getModel();
        if (model == null) {
            return null;
        }
        return model.getQ7Project().getProject();
    }

    private boolean saveAs() {
        ITestCase newScenario;
        IQ7Element parent;
        IQ7Folder folder = null;
        if (this.getModel() != null && (parent = this.getModel().getParent()) != null && parent.exists() && parent instanceof IQ7Folder) {
            folder = (IQ7Folder)parent;
        }
        if ((newScenario = DialogUtil.openNewScenarioDialog(this.getShell(), false, folder)) == null) {
            return false;
        }
        IFile file = (IFile)newScenario.getResource();
        if (file == null) {
            return false;
        }
        IQ7Element newModel = RcpttCore.create((IResource)file);
        if (newModel == null) {
            return false;
        }
        this.setModel((ITestCase)newModel);
        this.save();
        return true;
    }

    private void save() {
        block8: {
            try {
                ITestCase model = this.getModel();
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (model.exists()) {
                    model = (ITestCase)model.getWorkingCopy((IProgressMonitor)monitor);
                    this.copyContent(this.scenario, (Scenario)model.getNamedElement());
                    try {
                        model.commitWorkingCopy(true, (IProgressMonitor)monitor);
                    }
                    finally {
                        model.discardWorkingCopy();
                    }
                    this.contextsTable.setProject(this.getSavedProject());
                    this.verificationsTable.setProject(this.getSavedProject());
                    this.copyContent((Scenario)model.getNamedElement(), this.scenario);
                    break block8;
                }
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ControlPanelWindow_SaveDialogTitle, null, "Failed to save testcase because underlying resources is not exist.", 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int value = dialog.open();
                if (value == 0) {
                    this.saveAs();
                }
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    private void copyContent(Scenario source, Scenario target) {
        target.setContent(EcoreUtil.copy((EObject)source.getContent()));
        target.setTeslaContent(EcoreUtil.copy((EObject)source.getTeslaContent()));
        target.getAttachments().clear();
        target.getAttachments().addAll(EcoreUtil.copyAll((Collection)source.getAttachments()));
        target.getContexts().clear();
        target.getContexts().addAll((Collection)source.getContexts());
        target.getVerifications().clear();
        target.getVerifications().addAll((Collection)source.getVerifications());
        target.setDescription(source.getDescription());
    }

    private boolean openSaveDialog() {
        if (this.getModel() != null && !this.getModel().exists()) {
            return true;
        }
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ControlPanelWindow_SaveDialogTitle, null, Messages.ControlPanelWindow_SaveDialogMsg, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            if (this.getModel() != null) {
                this.save();
            } else if (!this.saveAs()) {
                return false;
            }
        }
        switch (returnCode) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    private void selectTab(CTabItem tab) {
        this.tabFolder.setSelection(tab);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }

    private boolean hasDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        return root.getSection(SETTINGS_KEY) != null;
    }

    public boolean close() {
        this.recordingSupport.setMode(RecordingSupport.RecordingMode.Stopped);
        if (this.isDirty() && !this.openSaveDialog()) {
            return false;
        }
        boolean result = super.close();
        if (result && !this.parentShell.isDisposed()) {
            IFile location;
            this.dbc.dispose();
            this.parentShell.removeShellListener((ShellListener)this.closeListener);
            this.parentShell.setMinimized(false);
            this.parentShell.forceActive();
            this.parentShell.setFocus();
            ITestCase model = this.getModel();
            if (model != null && model.exists() && (location = (IFile)model.getResource()) != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)Q7UIPlugin.getActiveWindow().getActivePage(), (IFile)location);
                }
                catch (PartInitException e) {
                    Q7UIPlugin.log(e);
                }
            }
        }
        RecordingContextManager.Instance.deactivateContext();
        return result;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        GridLayoutFactory.fillDefaults().equalWidth(true).spacing(0, 0).margins(0, 0).applyTo((Composite)newShell);
        this.parentShell.addShellListener((ShellListener)this.closeListener);
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.hasDialogBoundsSettings()) {
            return super.getInitialLocation(initialSize);
        }
        return new Point(0, 0);
    }

    protected Point getInitialSize() {
        if (this.hasDialogBoundsSettings()) {
            return super.getInitialSize();
        }
        Rectangle bounds = this.parentShell.getDisplay().getBounds();
        int height = bounds.height / 2 - bounds.height / 10;
        return new Point(580, height);
    }

    public void runWithProgress(String name, IRunnableWithProgress runnable, boolean fork) {
        this.statusBar.runWithProgress(name, runnable, fork);
    }

    private void handleStopRecordShortcutPressed(KeySequence sequence) {
        TriggerSequence[] shortcuts = RecordingContextManager.Instance.getStopRecordShortcuts();
        if (shortcuts != null) {
            TriggerSequence[] triggerSequenceArray = shortcuts;
            int n = shortcuts.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerSequence s = triggerSequenceArray[n2];
                if (sequence.equals((Object)s)) {
                    this.recordingSupport.setMode(RecordingSupport.RecordingMode.Stopped);
                }
                ++n2;
            }
        }
    }

    private final class AssertAddedListener
    implements IRecordingListener {
        private AssertAddedListener() {
        }

        public void handleContainerChange() {
        }

        public void disconnected() {
        }

        public void recordMode() {
        }

        public void assertMode() {
        }

        public void startRecord() {
        }

        public void stopRecord() {
        }

        public void replay() {
        }

        public void assertAdded(final CommandSet commands) {
            Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (commands != null) {
                        if (ControlPanelWindow.this.assertionWindow == null || ControlPanelWindow.this.assertionWindow.getShell() == null || ControlPanelWindow.this.assertionWindow.getShell().isDisposed()) {
                            ControlPanelWindow.this.assertionWindow = new AssertionPanelWindow(ControlPanelWindow.this.recordingSupport, ControlPanelWindow.this.getShell());
                        }
                        ControlPanelWindow.this.assertionWindow.setInput(commands);
                    }
                }
            });
        }
    }

    private static final class ExecutionErrorDialog
    extends MessageDialog {
        private ExecutionErrorDialog(Shell parentShell, ExecutionStatus status) {
            super(parentShell, ExecutionErrorDialog.getTitle(status), null, ExecutionErrorDialog.getMessage(status), 1, ExecutionErrorDialog.getDialogButtonsLabels(status), 0);
        }

        private static String getTitle(ExecutionStatus status) {
            IQ7NamedElement element = status.getElement();
            if (element != null && element instanceof IContext) {
                try {
                    return NLS.bind((String)Messages.ControlPanelWindow_ExecutionFailedDialogTitle_Context, (Object)element.getElementName());
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            return Messages.ControlPanelWindow_ExecutionFailedDialogTitle_Script;
        }

        private static String getMessage(ExecutionStatus status) {
            return EclStackTrace.fromExecStatus((ExecutionStatus)status).print();
        }

        private static String[] getDialogButtonsLabels(ExecutionStatus status) {
            if (status.hasLocation()) {
                return new String[]{Messages.ControlPanelWindow_ErrorLocationButton, IDialogConstants.OK_LABEL};
            }
            return new String[]{IDialogConstants.OK_LABEL};
        }

        private static boolean showExecutionError(Shell parentShell, ExecutionStatus status) {
            ExecutionErrorDialog dialog = new ExecutionErrorDialog(parentShell, status);
            return dialog.open() == 0 && status.hasLocation();
        }
    }

    private final class ParentShellCloseListener
    extends ShellAdapter {
        private ParentShellCloseListener() {
        }

        public void shellClosed(ShellEvent e) {
            ControlPanelWindow.this.close();
        }
    }

    private final class RecordingModeListener
    implements IChangeListener {
        private RecordingModeListener() {
        }

        public void handleChange(ChangeEvent event) {
            Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RecordingModeListener.this.updateStatusBar();
                    RecordingModeListener.this.updateAssetionWindow();
                }
            });
        }

        private void updateStatusBar() {
            if (ControlPanelWindow.this.statusBar != null && ControlPanelWindow.this.statusBar.getControl() != null && !ControlPanelWindow.this.statusBar.getControl().isDisposed()) {
                StringBuilder message = new StringBuilder();
                message.append("Press ");
                switch (ControlPanelWindow.this.recordingSupport.getMode()) {
                    case Recording: {
                        TriggerSequence[] shortcuts = RecordingContextManager.Instance.getAssertModeShortcuts();
                        if (shortcuts == null || shortcuts.length <= 0) break;
                        message.append(Messages.bind((String)Messages.ControlPanelWindow_AssertShortcutToolTip, (Object)shortcuts[0].format()));
                        message.append(", ").append(this.getStopRecordShortcutMessage());
                        break;
                    }
                    case Asserting: {
                        TriggerSequence[] shortcuts = RecordingContextManager.Instance.getRecordModeShortcuts();
                        if (shortcuts != null && shortcuts.length > 0) {
                            message.append(Messages.bind((String)Messages.ControlPanelWindow_RecordShortcutToolTip, (Object)shortcuts[0].format()));
                            message.append(", ").append(this.getStopRecordShortcutMessage());
                            break;
                        }
                    }
                    case Stopped: {
                        TriggerSequence[] replayShortcuts;
                        TriggerSequence[] startShortcuts = RecordingContextManager.Instance.getStartRecordShortcuts();
                        if (startShortcuts != null && startShortcuts.length > 0) {
                            message.append(Messages.bind((String)Messages.ControlPanelWindow_StartRecordShortcutToolTip, (Object)startShortcuts[0].format()));
                            message.append(", ");
                        }
                        if ((replayShortcuts = RecordingContextManager.Instance.getReplayShortcuts()) == null || replayShortcuts.length <= 0) break;
                        message.append(Messages.bind((String)Messages.ControlPanelWindow_ReplayShortcutToolTip, (Object)replayShortcuts[0].format()));
                        break;
                    }
                    default: {
                        ControlPanelWindow.this.statusBar.showMessage(null);
                        return;
                    }
                }
                ControlPanelWindow.this.statusBar.showMessage(message.toString());
            }
        }

        private String getStopRecordShortcutMessage() {
            TriggerSequence[] shortcuts = RecordingContextManager.Instance.getStopRecordShortcuts();
            if (shortcuts != null && shortcuts.length > 0) {
                return Messages.bind((String)Messages.ControlPanelWindow_StopRecordShortcutToolTip, (Object)shortcuts[0].format());
            }
            return "";
        }

        private void updateAssetionWindow() {
            switch (ControlPanelWindow.this.recordingSupport.getMode()) {
                case Asserting: {
                    break;
                }
                default: {
                    if (ControlPanelWindow.this.assertionWindow == null) break;
                    ControlPanelWindow.this.assertionWindow.close();
                    ControlPanelWindow.this.assertionWindow = null;
                }
            }
        }
    }

    private final class RecordingShortcutListener
    implements Listener {
        private RecordingShortcutListener() {
        }

        public void handleEvent(Event event) {
            if (ControlPanelWindow.this.recordingSupport != null) {
                int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
                KeySequence sequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                switch (ControlPanelWindow.this.recordingSupport.getMode()) {
                    case Recording: {
                        TriggerSequence[] assertShortcuts = RecordingContextManager.Instance.getAssertModeShortcuts();
                        if (assertShortcuts != null) {
                            TriggerSequence[] triggerSequenceArray = assertShortcuts;
                            int n = assertShortcuts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TriggerSequence s = triggerSequenceArray[n2];
                                if (sequence.equals((Object)s)) {
                                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Asserting);
                                }
                                ++n2;
                            }
                        }
                        ControlPanelWindow.this.handleStopRecordShortcutPressed(sequence);
                        break;
                    }
                    case Asserting: {
                        TriggerSequence[] recordShortcuts = RecordingContextManager.Instance.getRecordModeShortcuts();
                        if (recordShortcuts != null) {
                            TriggerSequence[] triggerSequenceArray = recordShortcuts;
                            int n = recordShortcuts.length;
                            int n3 = 0;
                            while (n3 < n) {
                                TriggerSequence s = triggerSequenceArray[n3];
                                if (sequence.equals((Object)s)) {
                                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Recording);
                                }
                                ++n3;
                            }
                        }
                        ControlPanelWindow.this.handleStopRecordShortcutPressed(sequence);
                        break;
                    }
                    case Stopped: {
                        TriggerSequence[] replayShortcuts;
                        int n;
                        TriggerSequence[] startShortcuts = RecordingContextManager.Instance.getStartRecordShortcuts();
                        if (startShortcuts != null) {
                            TriggerSequence[] triggerSequenceArray = startShortcuts;
                            n = startShortcuts.length;
                            int n4 = 0;
                            while (n4 < n) {
                                TriggerSequence s = triggerSequenceArray[n4];
                                if (sequence.equals((Object)s)) {
                                    ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Connecting);
                                }
                                ++n4;
                            }
                        }
                        if ((replayShortcuts = RecordingContextManager.Instance.getReplayShortcuts()) == null) break;
                        TriggerSequence[] triggerSequenceArray = replayShortcuts;
                        int n5 = replayShortcuts.length;
                        n = 0;
                        while (n < n5) {
                            TriggerSequence s = triggerSequenceArray[n];
                            if (sequence.equals((Object)s)) {
                                ControlPanelWindow.this.recordingSupport.setMode(RecordingSupport.RecordingMode.Replaying);
                            }
                            ++n;
                        }
                        break;
                    }
                }
            }
        }
    }
}

