/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.wizards.WizardTestSuitePage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class NewTestSuiteWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardTestSuitePage testSuitePage;
    private boolean openEditor = true;
    private ITestSuite testSuite;

    public NewTestSuiteWizard() {
        this.setWindowTitle(Messages.NewTestSuiteWizard_WindowTitle);
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    public boolean openEditor() {
        return this.openEditor;
    }

    public void setOpenEditor(boolean openEditor) {
        this.openEditor = openEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.testSuitePage = new WizardTestSuitePage(this.selection);
        this.addPage((IWizardPage)this.testSuitePage);
    }

    public boolean performFinish() {
        final boolean[] result = new boolean[1];
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IProject project = NewTestSuiteWizard.this.testSuitePage.getProject();
                        String name = NewTestSuiteWizard.this.testSuitePage.getTestSuiteName();
                        IPath containerPath = NewTestSuiteWizard.this.testSuitePage.getPathInProject();
                        NewTestSuiteWizard.this.testSuite = RcpttCore.create((IProject)project).getFolder(containerPath).createTestSuite(name, true, (IProgressMonitor)new NullProgressMonitor());
                        if (NewTestSuiteWizard.this.openEditor) {
                            IDE.openEditor((IWorkbenchPage)NewTestSuiteWizard.this.getPage(), (IFile)((IFile)NewTestSuiteWizard.this.testSuite.getResource()));
                        }
                        result[0] = true;
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log(e);
                        result[0] = false;
                    }
                }
            });
        }
        catch (Throwable e) {
            Q7UIPlugin.log(e);
        }
        return result[0];
    }

    private IWorkbenchPage getPage() {
        return this.workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public IProject getProject() {
        return this.testSuitePage.getProject();
    }
}

