/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.monitoring;

import org.eclipse.ui.monitoring.StackSample;

public class UiFreezeEvent {
    private final long startTimestamp;
    private final long totalDuration;
    private final StackSample[] stackTraceSamples;
    private final boolean isStillRunning;

    public UiFreezeEvent(long startTime, long duration, StackSample[] samples, boolean stillRunning) {
        this.startTimestamp = startTime;
        this.stackTraceSamples = samples;
        this.totalDuration = duration;
        this.isStillRunning = stillRunning;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public StackSample[] getStackTraceSamples() {
        return this.stackTraceSamples;
    }

    public boolean isStillRunning() {
        return this.isStillRunning;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Freeze started at ");
        buf.append(this.startTimestamp);
        if (this.isStillRunning) {
            buf.append(" still ongoing after ");
        } else {
            buf.append(" lasted ");
        }
        buf.append(this.totalDuration);
        buf.append("ms");
        if (this.stackTraceSamples.length != 0) {
            buf.append("\nStack trace samples:");
            StackSample[] stackSampleArray = this.stackTraceSamples;
            int n = this.stackTraceSamples.length;
            int n2 = 0;
            while (n2 < n) {
                StackSample stackTraceSample = stackSampleArray[n2];
                buf.append('\n');
                buf.append(stackTraceSample.toString());
                ++n2;
            }
        }
        return buf.toString();
    }
}

