/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoNode;
import org.eclipse.rcptt.tesla.core.info.JobEntry;
import org.eclipse.rcptt.tesla.core.info.NodeProperty;
import org.eclipse.rcptt.tesla.core.info.StackTraceEntry;

public class AdvancedInformationGenerator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String STACK_TRACE = "include.stack.trace";
    private Map<String, Boolean> options = new HashMap<String, Boolean>();

    public AdvancedInformationGenerator() {
        this.options.put(STACK_TRACE, Boolean.TRUE);
    }

    public AdvancedInformationGenerator set(String property, boolean value) {
        this.options.put(property, value);
        return this;
    }

    public String generateContent(AdvancedInformation info) {
        EList<StackTraceEntry> threads;
        StringBuilder builder = new StringBuilder();
        EList<InfoNode> nodes = info.getNodes();
        builder.append("Information:").append(LINE_SEPARATOR);
        for (InfoNode infoNode : nodes) {
            this.printNode(infoNode, builder, 1);
        }
        EList<JobEntry> jobs = info.getJobs();
        if (!jobs.isEmpty()) {
            builder.append(LINE_SEPARATOR).append("Jobs information:").append(LINE_SEPARATOR);
            for (JobEntry jobEntry : jobs) {
                this.appendTabs(builder, 1).append("Job:").append(jobEntry.getName()).append(LINE_SEPARATOR);
                this.appendTabs(builder, 2).append("class=").append(jobEntry.getJobClass()).append(LINE_SEPARATOR);
                this.appendTabs(builder, 2).append("state=").append(jobEntry.getState()).append(LINE_SEPARATOR);
                if (jobEntry.getRule() == null) continue;
                this.appendTabs(builder, 2).append("rule=").append(jobEntry.getRule()).append(LINE_SEPARATOR);
            }
        }
        if (this.options.get(STACK_TRACE).equals(Boolean.TRUE) && !(threads = info.getThreads()).isEmpty()) {
            builder.append(LINE_SEPARATOR).append("Thread information:").append(LINE_SEPARATOR);
            for (StackTraceEntry trace : threads) {
                if (trace.getThreadClass().equals("org.eclipse.core.internal.jobs.Worker") && trace.getStackTrace().size() == 4) continue;
                this.appendTabs(builder, 1).append("Thread:").append(trace.getThreadName()).append(LINE_SEPARATOR);
                this.appendTabs(builder, 2).append("class=").append(trace.getThreadClass()).append(LINE_SEPARATOR);
                EList<String> list = trace.getStackTrace();
                int i = 0;
                while (i < list.size()) {
                    this.appendTabs(builder, 3).append(Integer.toString(list.size() - i - 1)).append(": ").append((String)list.get(i)).append(LINE_SEPARATOR);
                    ++i;
                }
            }
        }
        return builder.toString();
    }

    private void printNode(InfoNode infoNode, StringBuilder stream, int tabs) {
        this.appendTabs(stream, tabs);
        stream.append(infoNode.getName());
        EList<NodeProperty> list = infoNode.getProperties();
        EList<InfoNode> childs = infoNode.getChildren();
        if (!list.isEmpty() || !childs.isEmpty()) {
            stream.append(" {").append(LINE_SEPARATOR);
            if (list.size() != 0) {
                for (NodeProperty nodeProperty : list) {
                    this.appendTabs(stream, tabs + 1).append(nodeProperty.getName()).append("=").append(nodeProperty.getValue()).append(LINE_SEPARATOR);
                }
            }
            if (childs.size() != 0) {
                for (InfoNode child : childs) {
                    this.printNode(child, stream, tabs + 2);
                }
            }
            this.appendTabs(stream, tabs).append("}").append(LINE_SEPARATOR);
        } else {
            stream.append(LINE_SEPARATOR);
        }
    }

    private StringBuilder appendTabs(StringBuilder stream, int tabs) {
        int i = 0;
        while (i < tabs) {
            stream.append("  ");
            ++i;
        }
        return stream;
    }
}

