/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.ui.Control;
import org.eclipse.rcptt.tesla.core.ui.Link;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.FormTextLinkUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;

public class EclipseFormsSupport {
    public static String unify(String value) {
        return PlayerTextUtils.unifyMultilines(value);
    }

    public static Widget SWTModelMapperMap(org.eclipse.swt.widgets.Widget widget) {
        if (widget instanceof AbstractHyperlink) {
            return EclipseFormsSupport.fillHyperLink((AbstractHyperlink)widget);
        }
        if (widget instanceof org.eclipse.swt.widgets.Link) {
            return EclipseFormsSupport.fillLink((org.eclipse.swt.widgets.Link)widget);
        }
        return null;
    }

    private static Widget fillHyperLink(AbstractHyperlink widget) {
        Link label = UiFactory.eINSTANCE.createLink();
        label.setCaption(EclipseFormsSupport.unify(widget.getText()));
        label.setToltip(EclipseFormsSupport.unify(widget.getToolTipText()));
        SWTModelMapper.fillControl((Control)label, (org.eclipse.swt.widgets.Control)widget);
        return label;
    }

    private static Widget fillLink(org.eclipse.swt.widgets.Link widget) {
        Link label = UiFactory.eINSTANCE.createLink();
        label.setCaption(EclipseFormsSupport.unify(widget.getText()));
        label.setToltip(EclipseFormsSupport.unify(widget.getToolTipText()));
        SWTModelMapper.fillControl((Control)label, (org.eclipse.swt.widgets.Control)widget);
        return label;
    }

    public static Object unwrap(SWTUIElement element) {
        if (element instanceof FormTextLinkUIElement) {
            return ((FormTextLinkUIElement)element).segment;
        }
        return null;
    }

    public static SWTUIElement searchExpandable(SWTUIPlayer player, PlayerSelectionFilter filter) {
        return player.selectWidget(filter, ExpandableComposite.class);
    }

    public static SWTUIElement searchLink(SWTUIPlayer player, PlayerSelectionFilter filter) {
        return player.selectWidget(filter, org.eclipse.swt.widgets.Link.class, IHyperlinkSegment.class, AbstractHyperlink.class);
    }

    public static SWTUIElement searchFormText(SWTUIPlayer swtuiPlayer, PlayerSelectionFilter filter) {
        return swtuiPlayer.selectWidget(filter, FormText.class);
    }

    public static boolean isHyperLinkSegment(SWTUIElement w) {
        return EclipseFormsSupport.unwrap(w) instanceof IHyperlinkSegment;
    }

    public static void clickOnFormText(SWTUIElement w) {
        FormText fText = (FormText)PlayerWrapUtils.unwrapWidget(w);
        FormTextModel model = EclipseFormsSupport.getFormTextModel(fText);
        if (model.getHyperlinkCount() < 1) {
            return;
        }
        model.selectLink(model.getHyperlink(0));
        EclipseFormsSupport.callActivateSelectLink(fText);
    }

    public static void clickOnLink(SWTUIElement w, boolean doubleClick) {
        IHyperlinkSegment segment = (IHyperlinkSegment)PlayerWrapUtils.unwrap(w);
        FormText fText = (FormText)((FormTextLinkUIElement)w).widget;
        FormTextModel model = EclipseFormsSupport.getFormTextModel(fText);
        if (model.getHyperlinkCount() < 1) {
            return;
        }
        model.selectLink(segment);
        EclipseFormsSupport.callActivateSelectLink(fText);
    }

    public static void clickOnExpandable(SWTUIElement w) {
        ExpandableComposite ec = (ExpandableComposite)PlayerWrapUtils.unwrapWidget(w);
        boolean newState = !ec.isExpanded();
        TeslaSWTAccess.callMethod(ExpandableComposite.class, (Object)ec, "fireExpanding", new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{newState, true});
        ec.setExpanded(newState);
        TeslaSWTAccess.callMethod(ExpandableComposite.class, (Object)ec, "fireExpanding", new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{newState, false});
        if (newState) {
            FormUtil.ensureVisible((org.eclipse.swt.widgets.Control)ec);
        }
    }

    public static SWTUIElement wrapSegment(SWTUIPlayer player, Object s) {
        if (s instanceof IHyperlinkSegment) {
            return new FormTextLinkUIElement(null, (IHyperlinkSegment)s, player);
        }
        return null;
    }

    public static void formsChildren(SWTUIPlayer swtuiPlayer, List<SWTUIElement> results, org.eclipse.swt.widgets.Widget widget, SWTUIElement[] ignores, Class<?>[] classes) {
        if (widget instanceof FormText) {
            FormText fText = (FormText)widget;
            FormTextModel model = EclipseFormsSupport.getFormTextModel(fText);
            if (PlayerWidgetUtils.isVisible((org.eclipse.swt.widgets.Control)fText)) {
                int i = 0;
                while (i < model.getHyperlinkCount()) {
                    FormTextLinkUIElement wrap = new FormTextLinkUIElement((org.eclipse.swt.widgets.Control)fText, model.getHyperlink(i), swtuiPlayer);
                    ChildrenCollector.addItem(results, wrap, ignores, classes);
                    ++i;
                }
            }
        }
    }

    public static String getText(Object widget) {
        if (widget instanceof IHyperlinkSegment) {
            return ((IHyperlinkSegment)widget).getText();
        }
        if (widget instanceof ExpandableComposite) {
            return ((ExpandableComposite)widget).getText();
        }
        if (widget instanceof Hyperlink) {
            return ((Hyperlink)widget).getText();
        }
        if (widget instanceof FormText) {
            FormText fText = (FormText)widget;
            FormTextModel model = EclipseFormsSupport.getFormTextModel(fText);
            return model.getAccessibleText();
        }
        return null;
    }

    public static void addKinds(Map<Class<?>, ElementKind> elementKinds) {
        elementKinds.put(ExpandableComposite.class, ElementKind.Expandable);
        elementKinds.put(IHyperlinkSegment.class, ElementKind.Link);
        elementKinds.put(Hyperlink.class, ElementKind.Link);
    }

    public static Class<?> getSearchableClass(Object w) {
        if (w instanceof AbstractHyperlink) {
            return AbstractHyperlink.class;
        }
        if (w instanceof ExpandableComposite) {
            return ExpandableComposite.class;
        }
        return null;
    }

    public static ElementKind getKind(Object w) {
        if (w instanceof AbstractHyperlink) {
            return ElementKind.Link;
        }
        if (w instanceof ExpandableComposite) {
            return ElementKind.Expandable;
        }
        return null;
    }

    public static FormTextModel getFormTextModel(FormText fText) {
        FormTextModel model = null;
        try {
            Field field = FormText.class.getDeclaredField("model");
            field.setAccessible(true);
            model = (FormTextModel)field.get(fText);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return model;
    }

    public static void callActivateSelectLink(FormText fText) {
        try {
            Method selectlink = FormText.class.getDeclaredMethod("activateSelectedLink", new Class[0]);
            selectlink.setAccessible(true);
            selectlink.invoke((Object)fText, new Object[0]);
        }
        catch (Throwable e) {
            TeslaCore.log((Throwable)e);
        }
    }

    public static Widget mapFormText(org.eclipse.swt.widgets.Widget widget) {
        if (widget instanceof FormText) {
            return EclipseFormsSupport.fillFormText((FormText)widget);
        }
        return null;
    }

    private static Widget fillFormText(FormText widget) {
        org.eclipse.rcptt.tesla.core.ui.FormText formText = UiFactory.eINSTANCE.createFormText();
        SWTModelMapper.fillControl((Control)formText, (org.eclipse.swt.widgets.Control)widget);
        String text = "";
        FormTextModel model = TeslaSWTAccess.getField(FormTextModel.class, widget, "model");
        if (model != null) {
            text = model.getAccessibleText();
        }
        formText.setText(text);
        return formText;
    }
}

