/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.launching.events.AutEvent;
import org.eclipse.rcptt.core.launching.events.AutEventLocation;
import org.eclipse.rcptt.core.launching.events.EventsFactory;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.runtime.ui.AutEventManager;
import org.eclipse.rcptt.runtime.ui.Q7Monitor;
import org.eclipse.rcptt.tesla.ui.ide.events.UIIDEManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.runtime.ui";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (AutEventManager.getQ7EclPort() != -1) {
            new Q7Monitor().start();
            this.sendInitialState();
            UIIDEManager.addListener((UIIDEManager.IUIIDEListener)new UIIDEManager.IUIIDEListener(){

                public void handleNewWorkspaceLocation(String path) {
                    AutEventLocation location = EventsFactory.eINSTANCE.createAutEventLocation();
                    location.setLocation(path);
                    try {
                        AutEventManager.getInstance().sendEvent((AutEvent)location);
                    }
                    catch (CoreException e) {
                        Activator.log(e.getMessage(), e);
                    }
                }
            });
        }
        ReportManager.reload();
    }

    private void sendInitialState() {
        AutEventManager.getInstance().sendInit();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        Activator.log(Activator.createStatus(t));
    }

    public static void log(String message, Throwable t) {
        Activator.log(Activator.createStatus(message, t));
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void info(String message, Object ... args) {
        Activator.info(null, message, args);
    }

    public static void info(Throwable e, String message, Object ... args) {
        Activator.log((IStatus)new Status(1, PLUGIN_ID, String.format(message, args), e));
    }

    public static void err(Throwable cause, String message, Object ... args) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, String.format(message, args), cause));
    }

    public static IStatus createStatus(Throwable t) {
        return new Status(4, PLUGIN_ID, t.getMessage(), t);
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }
}

