/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.util.List;
import org.eclipse.help.internal.standalone.EclipseController;
import org.eclipse.help.internal.standalone.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneHelp
extends EclipseController {
    private static final String HELP_APPLICATION_ID = "org.eclipse.help.base.helpApplication";

    public StandaloneHelp(String[] args) {
        super(HELP_APPLICATION_ID, args);
    }

    public static void main(String[] args) {
        try {
            StandaloneHelp help = new StandaloneHelp(args);
            List<String> helpCommand = Options.getHelpCommand();
            if (help.executeCommand(helpCommand)) {
                return;
            }
            StandaloneHelp.printMainUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayContext(String contextId, int x, int y) {
    }

    public void displayContextInfopop(String contextId, int x, int y) {
    }

    public void displayHelp() throws Exception {
        this.sendHelpCommand("displayHelp", new String[0]);
    }

    public void displayHelp(String href) throws Exception {
        this.sendHelpCommand("displayHelp", new String[]{"href=" + href});
    }

    public void displayHelpWindow() throws Exception {
        this.sendHelpCommand("displayHelpWindow", new String[0]);
    }

    public void displayHelpWindow(String href) throws Exception {
        this.sendHelpCommand("displayHelpWindow", new String[]{"href=" + href});
    }

    private boolean executeCommand(List<String> helpCommands) throws Exception {
        if (helpCommands.size() <= 0) {
            return false;
        }
        String command = helpCommands.get(0);
        if ("start".equalsIgnoreCase(command)) {
            this.start();
            return true;
        }
        if ("shutdown".equalsIgnoreCase(command)) {
            this.shutdown();
            return true;
        }
        if ("displayHelp".equalsIgnoreCase(command)) {
            if (helpCommands.size() >= 2) {
                this.displayHelp(helpCommands.get(1));
            } else {
                this.displayHelp();
            }
            return true;
        }
        if ("displayHelpWindow".equalsIgnoreCase(command)) {
            if (helpCommands.size() >= 2) {
                this.displayHelpWindow(helpCommands.get(1));
            } else {
                this.displayHelpWindow();
            }
            return true;
        }
        if ("install".equalsIgnoreCase(command) || "enable".equalsIgnoreCase(command) || "disable".equalsIgnoreCase(command) || "uninstall".equalsIgnoreCase(command) || "update".equalsIgnoreCase(command) || "search".equalsIgnoreCase(command) || "listFeatures".equalsIgnoreCase(command) || "addSite".equalsIgnoreCase(command) || "removeSite".equalsIgnoreCase(command) || "apply".equalsIgnoreCase(command)) {
            return this.executeUpdateCommand(command);
        }
        if ("displayContext".equalsIgnoreCase(command)) {
            if (helpCommands.size() >= 4) {
                this.displayContext(helpCommands.get(1), Integer.parseInt(helpCommands.get(2)), Integer.parseInt(helpCommands.get(3)));
                return true;
            }
        } else if ("displayContextInfopop".equalsIgnoreCase(command) && helpCommands.size() >= 4) {
            this.displayContextInfopop(helpCommands.get(1), Integer.parseInt(helpCommands.get(2)), Integer.parseInt(helpCommands.get(3)));
            return true;
        }
        return false;
    }

    private static void printMainUsage() {
        System.out.println("Parameters syntax:");
        System.out.println();
        System.out.println("-command start | shutdown | (displayHelp [href]) [-eclipsehome eclipseInstallPath] [-host helpServerHost] [-port helpServerPort] [platform options] [-vmargs [Java VM arguments]]");
        System.out.println();
        System.out.println("where:");
        System.out.println(" href is the URL of the help resource to display,");
        System.out.println(" eclipseInstallPath specifies Eclipse installation directory; this directory is a parent to \"plugins\" directory and eclipse executable;  the option must be provided, when current directory from which information center is launched, is not the same as Eclipse installation directory,");
        System.out.println(" helpServerHost specifies host name of the interface that help server will use,");
        System.out.println(" helpServerPort specifies port number that help server will use,");
        System.out.println(" platform options are other options that are supported by Eclipse Executable.");
    }
}

