/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredCheckboxTree
extends FilteredTree {
    private static final long FILTER_DELAY = 400L;
    FormToolkit fToolkit;
    CachedCheckboxTreeViewer checkboxViewer;

    public FilteredCheckboxTree(Composite parent, FormToolkit toolkit) {
        this(parent, toolkit, 0);
    }

    public FilteredCheckboxTree(Composite parent, FormToolkit toolkit, int treeStyle) {
        this(parent, toolkit, treeStyle, new PatternFilter());
    }

    public FilteredCheckboxTree(Composite parent, FormToolkit toolkit, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
        this.fToolkit = toolkit;
    }

    protected TreeViewer doCreateTreeViewer(Composite actParent, int style) {
        int treeStyle = style | 0x20 | 2 | 0x200 | 0x100 | 0x800;
        Tree tree = null;
        tree = this.fToolkit != null ? this.fToolkit.createTree(actParent, treeStyle) : new Tree(actParent, treeStyle);
        this.checkboxViewer = new CachedCheckboxTreeViewer(tree);
        return this.checkboxViewer;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        WorkbenchJob filterJob = super.doCreateRefreshJob();
        filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    FilteredCheckboxTree.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).FilteredCheckboxTree.this.checkboxViewer.getTree().isDisposed()) {
                                return;
                            }
                            (this).FilteredCheckboxTree.this.checkboxViewer.restoreLeafCheckState();
                        }
                    });
                }
            }
        });
        return filterJob;
    }

    protected Text doCreateFilterText(Composite actParent) {
        Text parentText = super.doCreateFilterText(actParent);
        if (this.fToolkit != null) {
            int style = parentText.getStyle();
            parentText.dispose();
            return this.fToolkit.createText(actParent, null, style);
        }
        return parentText;
    }

    public void clearFilter() {
        this.getPatternFilter().setPattern(null);
        this.setFilterText(this.getInitialText());
        this.textChanged();
    }

    public CachedCheckboxTreeViewer getCheckboxTreeViewer() {
        return this.checkboxViewer;
    }

    protected long getRefreshJobDelay() {
        return 400L;
    }
}

