/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DeleteCompletedHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) {
        MarkerSupportView view = this.getView(event);
        if (view == null) {
            return this;
        }
        List<IMarker> completed = this.getCompletedTasks(view);
        if (completed.size() == 0) {
            MessageDialog.openInformation((Shell)view.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)MarkerMessages.deleteCompletedTasks_noneCompleted);
            return this;
        }
        String message = completed.size() == 1 ? MarkerMessages.deleteCompletedTasks_permanentSingular : NLS.bind((String)MarkerMessages.deleteCompletedTasks_permanentPlural, (Object)String.valueOf(completed.size()));
        if (!MessageDialog.openConfirm((Shell)view.getSite().getShell(), (String)MarkerMessages.deleteCompletedTasks_dialogTitle, (String)message)) {
            return view;
        }
        IMarker[] markers = new IMarker[completed.size()];
        completed.toArray(markers);
        DeleteMarkersOperation op = new DeleteMarkersOperation(markers, MarkerMessages.deleteCompletedAction_title);
        this.execute((IUndoableOperation)op, MarkerMessages.deleteCompletedTasks_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(view.getSite().getShell()));
        return this;
    }

    private List<IMarker> getCompletedTasks(ExtendedMarkersView view) {
        ArrayList<IMarker> completed = new ArrayList<IMarker>();
        MarkerSupportItem[] items = view.getAllConcreteItems();
        int i = 0;
        while (i < items.length) {
            MarkerSupportItem markerItem = items[i];
            if (markerItem.getAttributeValue("done", false) && markerItem.getMarker() != null) {
                completed.add(markerItem.getMarker());
            }
            ++i;
        }
        return completed;
    }
}

