/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.mozilla;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfo;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfoManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;

public class nsISupports {
    static final boolean IsSolaris;
    static final int FIRST_METHOD_ID;
    static final int LAST_METHOD_ID;
    public static final String NS_ISUPPORTS_IID_STR = "00000000-0000-0000-c000-000000000046";
    int address;

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        IsSolaris = osName.startsWith("sunos") || osName.startsWith("solaris");
        FIRST_METHOD_ID = IsSolaris ? 2 : 0;
        LAST_METHOD_ID = FIRST_METHOD_ID + 2;
        IIDStore.RegisterIID(nsISupports.class, 0, new nsID(NS_ISUPPORTS_IID_STR));
    }

    protected static boolean IsXULRunner10() {
        return MozillaVersion.CheckVersion(5, true);
    }

    protected static boolean IsXULRunner24() {
        return MozillaVersion.CheckVersion(6, true);
    }

    protected static boolean IsXULRunner31() {
        return MozillaVersion.CheckVersion(7, true);
    }

    protected static boolean IsXULRVersionOrLater(int version) {
        return MozillaVersion.CheckVersion(version, false);
    }

    private static byte[] toByteArray(String str) {
        byte[] bytes = new byte[str.length() + 1];
        int i = str.length();
        while (i-- > 0) {
            bytes[i] = (byte)str.charAt(i);
        }
        return bytes;
    }

    protected int getGetterIndex(String attribute) {
        return this.getMethodIndex(attribute);
    }

    protected int getSetterIndex(String attribute) {
        return this.getMethodIndex(attribute) + 1;
    }

    protected int getMethodIndex(String methodString) {
        int[] result = new int[]{0};
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            return -1;
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        rc = serviceManager.GetServiceByContractID(nsISupports.toByteArray("@mozilla.org/xpti/interfaceinfomanager-service;1"), IIDStore.GetIID(nsIInterfaceInfoManager.class), result);
        serviceManager.Release();
        if (rc != 0) {
            return -1;
        }
        nsIInterfaceInfoManager iim = new nsIInterfaceInfoManager(result[0]);
        result[0] = 0;
        rc = iim.GetInfoForName(nsISupports.toByteArray(this.getClass().getSimpleName()), result);
        iim.Release();
        if (rc != 0) {
            return -1;
        }
        nsIInterfaceInfo info = new nsIInterfaceInfo(result[0]);
        int[] index = new int[1];
        int[] dummy = new int[1];
        rc = info.GetMethodInfoForName(nsISupports.toByteArray(methodString), index, dummy);
        info.Release();
        if (rc != 0) {
            throw new SWTError(rc);
        }
        return index[0];
    }

    public nsISupports(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public int QueryInterface(nsID uuid, int[] result) {
        return XPCOM.VtblCall(FIRST_METHOD_ID, this.getAddress(), uuid, result);
    }

    public int AddRef() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 1, this.getAddress());
    }

    public int Release() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 2, this.getAddress());
    }
}

